/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.util.ObjectSizer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class InvalidateByTemplateEvent
implements InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = 0x50002002L;
    private static final long CACHE_COMMAND_NONE = 0L;
    private static final long CACHE_COMMAND_CLEAR = 1L;
    private static final long CACHE_COMMAND_INVALIDATE_BY_TEMPLATE = 2L;
    private static final long CACHE_COMMAND_INVALIDATE_BY_ID = 4L;
    private static final long CACHE_COMMAND_SPARE2 = 8L;
    private long cacheCommand = 0L;
    protected String template = null;
    protected long timeStamp = -1L;
    public int source;
    private ValueSet removedIds;
    private long drsClock = -1L;

    public InvalidateByTemplateEvent(String template, int source) {
        this.template = template;
        this.source = source;
        this.timeStamp = System.currentTimeMillis();
        this.setCacheCommand_InvalidateByTemplate();
    }

    public InvalidateByTemplateEvent(String template, long timeStamp, int source) {
        this.template = template;
        this.source = source;
        this.timeStamp = timeStamp;
        this.setCacheCommand_InvalidateByTemplate();
    }

    public ValueSet getRemovedIds() {
        return this.removedIds;
    }

    public void addRemovedIds(ValueSet ids) {
        if (this.removedIds == null) {
            this.removedIds = new ValueSet(4);
        }
        this.removedIds.union(ids);
    }

    public InvalidateByTemplateEvent() {
    }

    void setCacheCommand_Clear() {
        this.cacheCommand |= 1L;
    }

    private void setCacheCommand_InvalidateByTemplate() {
        this.cacheCommand |= 2L;
    }

    public boolean isCacheCommand_Clear() {
        return (this.cacheCommand & 1L) == 1L;
    }

    public boolean isCacheCommand_InvalidateByTemplate() {
        return (this.cacheCommand & 2L) == 2L;
    }

    public String getTemplate() {
        return this.template;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.template);
        out.writeLong(this.timeStamp);
        out.writeLong(this.drsClock);
        out.writeInt(this.source);
        out.writeLong(this.cacheCommand);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.template = (String)in.readObject();
        this.timeStamp = in.readLong();
        this.drsClock = in.readLong();
        this.source = in.readInt();
        this.cacheCommand = in.readLong();
    }

    public long getSerializedSize() {
        long totalSize = 0L;
        if (this.template != null) {
            totalSize += ObjectSizer.getSize(this.template);
        }
        return totalSize;
    }
}

