/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.ApplicationRegistry;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.servlet.OpenAPIServletBase;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIUtils;
import io.smallrye.openapi.runtime.io.Format;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@WebServlet(name="ApplicationServlet", urlPatterns={"/"}, loadOnStartup=1)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationServlet
extends OpenAPIServletBase {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ApplicationServlet.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private ServiceTracker<ApplicationRegistry, ApplicationRegistry> appRegistryTracker;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        BundleContext bundleContext = (BundleContext)config.getServletContext().getAttribute("osgi-bundlecontext");
        this.appRegistryTracker = new ServiceTracker(bundleContext, ApplicationRegistry.class, null);
        this.appRegistryTracker.open();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.appRegistryTracker.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Format responseFormat = this.getResponseFormat(request);
        String contentType = responseFormat == Format.JSON ? "application/json" : "text/plain";
        String servletPath = request.getServletPath();
        if (servletPath == null || servletPath.equals("/")) {
            String document;
            ApplicationRegistry appRegistry = (ApplicationRegistry)this.appRegistryTracker.getService();
            OpenAPIProvider currentProvider = null;
            if (appRegistry != null) {
                currentProvider = appRegistry.getOpenAPIProvider();
            }
            if (currentProvider != null) {
                Info configuredInfo;
                OpenAPI model = OpenAPIUtils.shallowCopy((OpenAPI)currentProvider.getModel());
                if (OpenAPIUtils.containsServersDefinition((OpenAPI)currentProvider.getModel())) {
                    if (LoggingUtils.isEventEnabled((TraceComponent)tc)) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Server information was already set by the user. So not setting Liberty's server information", (Object[])new Object[0]);
                    }
                } else {
                    List<Server> servers = this.getOpenAPIModelServers(request, currentProvider.getApplicationPath());
                    model.setServers(servers);
                }
                if ((configuredInfo = OpenAPIUtils.getConfiguredInfo((Config)ConfigProvider.getConfig())) != null) {
                    model.setInfo(configuredInfo);
                }
                document = OpenAPIUtils.getOpenAPIDocument((OpenAPI)model, (Format)responseFormat);
            } else {
                OpenAPI defaultOpenAPIModel = OpenAPIUtils.createBaseOpenAPIDocument();
                defaultOpenAPIModel.setServers(this.getOpenAPIModelServers(request));
                document = OpenAPIUtils.getOpenAPIDocument((OpenAPI)defaultOpenAPIModel, (Format)responseFormat);
            }
            if (document != null) {
                this.writeResponse(response, document, Response.Status.OK, contentType);
            } else {
                if (LoggingUtils.isEventEnabled((TraceComponent)tc)) {
                    Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Null document. Return 500.", (Object[])new Object[0]);
                }
                this.writeResponse(response, null, Response.Status.INTERNAL_SERVER_ERROR, contentType);
            }
        } else {
            this.writeResponse(response, null, Response.Status.NOT_FOUND, contentType);
        }
    }
}

