/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.URLDataSource;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.Base64DecoderStream;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.attachment.ImageDataContentHandler;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.attachment.QuotedPrintableDecoderStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class AttachmentUtil {
    public static final String ATTACHMENT_XOP_FOLLOW_URLS_PROPERTY = "org.apache.cxf.attachment.xop.follow.urls";
    public static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private static volatile int counter;
    private static final String ATT_UUID;
    private static final Random BOUND_RANDOM;
    private static final CommandMap DEFAULT_COMMAND_MAP;
    private static final MailcapCommandMap COMMAND_MAP;
    private static final Logger LOG;
    static final long serialVersionUID = -7879054247116030646L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private AttachmentUtil() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static CommandMap getCommandMap() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getCommandMap", new Object[0]);
        }
        MailcapCommandMap mailcapCommandMap = COMMAND_MAP;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mailcapCommandMap = mailcapCommandMap;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getCommandMap", mailcapCommandMap);
        }
        return mailcapCommandMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isMtomEnabled(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "isMtomEnabled", new Object[]{message});
        }
        boolean mtomEnabled = false;
        mtomEnabled = MessageUtils.getContextualBoolean(message, "mtom-enabled", false);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MTOM enabled: " + mtomEnabled);
        }
        boolean bl = mtomEnabled;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "isMtomEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void setStreamedAttachmentProperties(Message message, CachedOutputStream bos) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "setStreamedAttachmentProperties", new Object[]{message, bos});
        }
        Object directory = message.getContextualProperty("attachment-directory");
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("setStreamedAttachmentProperties: Attachment directory: " + directory);
        }
        if (directory != null) {
            if (directory instanceof File) {
                bos.setOutputDir((File)directory);
            } else {
                bos.setOutputDir(new File((String)directory));
            }
        }
        Object threshold = message.getContextualProperty("attachment-memory-threshold");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setStreamedAttachmentProperties: Attachment memory threshold: " + threshold);
        }
        if (threshold != null) {
            if (threshold instanceof Long) {
                bos.setThreshold((Long)threshold);
            } else {
                bos.setThreshold(Long.parseLong((String)threshold));
            }
        } else {
            bos.setThreshold(102400L);
        }
        Object maxSize = message.getContextualProperty("attachment-max-size");
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("setStreamedAttachmentProperties: Attachment maxSize: " + maxSize);
        }
        if (maxSize != null) {
            if (maxSize instanceof Long) {
                bos.setMaxSize((Long)maxSize);
            } else {
                bos.setMaxSize(Long.parseLong((String)maxSize));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "setStreamedAttachmentProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String ret_cid;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "createContentID", new Object[]{ns});
        }
        String cid = "cxf.apache.org";
        String name = ATT_UUID + "-" + String.valueOf(++counter);
        if (ns != null && ns.length() > 0) {
            try {
                URI uri = new URI(ns);
                String host = uri.getHost();
                cid = host != null ? host : ns;
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("createContentID caught exception: " + e + " setting cid to ns: " + ns);
                }
                cid = ns;
            }
        }
        String string = ret_cid = URLEncoder.encode(name, StandardCharsets.UTF_8.name()) + "@" + URLEncoder.encode(cid, StandardCharsets.UTF_8.name());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createContentID", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getUniqueBoundaryValue() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getUniqueBoundaryValue", new Object[0]);
        }
        long leastSigBits = 0L;
        long mostSigBits = 0L;
        Random random = BOUND_RANDOM;
        synchronized (random) {
            mostSigBits = BOUND_RANDOM.nextLong();
            leastSigBits = BOUND_RANDOM.nextLong();
        }
        mostSigBits &= 0xFFFFFFFFFFFF0FFFL;
        leastSigBits &= 0x3FFFFFFFFFFFFFFFL;
        UUID result = new UUID(mostSigBits |= 0x4000L, leastSigBits |= Long.MIN_VALUE);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("getUniqueBoundaryValue returning : uuid:" + result.toString());
        }
        String string = "uuid:" + result.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getUniqueBoundaryValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getAttachmentPartHeader(Attachment att) {
        String id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentPartHeader", new Object[]{att});
        }
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(HttpHeaderHelper.getHeaderKey("Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        if ((id = att.getId()).charAt(0) == '<') {
            id = id.substring(1, id.length() - 1);
        }
        buffer.append("Content-ID: <" + id + ">\r\n\r\n");
        String string = buffer.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentPartHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getDHMap", new Object[]{attachments});
        }
        DHMap dataHandlers = null;
        if (attachments != null) {
            dataHandlers = attachments instanceof LazyAttachmentCollection ? ((LazyAttachmentCollection)attachments).createDataHandlerMap() : new DHMap(attachments);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("getDHMap: dataHandlers" + dataHandlers);
        }
        AbstractMap abstractMap = dataHandlers == null ? new LinkedHashMap() : dataHandlers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            abstractMap = abstractMap;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getDHMap", abstractMap);
        }
        return abstractMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String cleanContentId(String id) {
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "cleanContentId", new Object[]{id});
            }
            if (id != null) {
                if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                if (id.startsWith("cid:")) {
                    id = id.substring(4);
                }
                try {
                    id = URLDecoder.decode(id, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOG.isLoggable(Level.FINEST)) break block8;
                    LOG.finest("cleanContentId ignoring UnsupportedEncodingException: " + e);
                }
            }
        }
        if (id == null) {
            id = BODY_ATTACHMENT_ID;
        }
        String string = id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "cleanContentId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String getHeaderValue(List<String> v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", new Object[]{v});
        }
        if (v != null && !v.isEmpty()) {
            String string = v.get(0);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String getHeaderValue(List<String> v, String delim) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", new Object[]{v, delim});
        }
        if (v != null && !v.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (String s : v) {
                if (b.length() > 0) {
                    b.append(delim);
                }
                b.append(s);
            }
            String string = b.toString();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeaderValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String getHeader(Map<String, List<String>> headers, String h) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getHeader", new Object[]{headers, h});
        }
        String string = AttachmentUtil.getHeaderValue(headers.get(h));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String getHeader(Map<String, List<String>> headers, String h, String delim) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getHeader", new Object[]{headers, h, delim});
        }
        String string = AttachmentUtil.getHeaderValue(headers.get(h), delim);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Attachment createAttachment(InputStream stream, Map<String, List<String>> headers) throws IOException {
        InputStream ins;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "createAttachment", new Object[]{stream, headers});
        }
        String id = AttachmentUtil.cleanContentId(AttachmentUtil.getHeader(headers, "Content-ID"));
        AttachmentImpl att = new AttachmentImpl(id);
        String ct = AttachmentUtil.getHeader(headers, "Content-Type");
        String cd = AttachmentUtil.getHeader(headers, "Content-Disposition");
        String fileName = AttachmentUtil.getContentDispositionFileName(cd);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("createAttachment: Content-ID: " + id + ", Content-Type: " + ct + ", Content-Disposition: " + cd + ", filename: " + fileName);
        }
        String encoding = null;
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("createAttachment processing header: " + name);
            }
            if (name.equalsIgnoreCase("Content-Transfer-Encoding") && "binary".equalsIgnoreCase(encoding = AttachmentUtil.getHeader(headers, name))) {
                att.setXOP(true);
            }
            att.setHeader(name, AttachmentUtil.getHeaderValue(e.getValue()));
        }
        if (encoding == null) {
            encoding = "binary";
        }
        if ((ins = AttachmentUtil.decode(stream, encoding)) != stream) {
            headers.remove("Content-Transfer-Encoding");
        }
        AttachmentDataSource source = new AttachmentDataSource(ct, ins);
        if (!StringUtils.isEmpty(fileName)) {
            source.setName(fileName);
        }
        att.setDataHandler(new DataHandler((DataSource)source));
        AttachmentImpl attachmentImpl = att;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attachmentImpl = attachmentImpl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createAttachment", attachmentImpl);
        }
        return attachmentImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String getContentDispositionFileName(String cd) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getContentDispositionFileName", new Object[]{cd});
        }
        if (StringUtils.isEmpty(cd)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("getContentDispositionFileName returning NULL");
            }
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getContentDispositionFileName", string);
            }
            return string;
        }
        ContentDisposition c = new ContentDisposition(cd);
        String s = c.getParameter("filename");
        if (s == null) {
            s = c.getParameter("name");
        }
        String string = s;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getContentDispositionFileName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static InputStream decode(InputStream in, String encoding) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "decode", new Object[]{in, encoding});
        }
        if (encoding == null) {
            InputStream inputStream = in;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                inputStream = inputStream;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "decode", inputStream);
            }
            return inputStream;
        }
        if ("binary".equals(encoding = encoding.toLowerCase()) || "7bit".equals(encoding) || "8bit".equals(encoding)) {
            InputStream inputStream = in;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                inputStream = inputStream;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "decode", inputStream);
            }
            return inputStream;
        }
        if ("base64".equals(encoding)) {
            Base64DecoderStream base64DecoderStream = new Base64DecoderStream(in);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                base64DecoderStream = base64DecoderStream;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "decode", base64DecoderStream);
            }
            return base64DecoderStream;
        }
        if ("quoted-printable".equals(encoding)) {
            QuotedPrintableDecoderStream quotedPrintableDecoderStream = new QuotedPrintableDecoderStream(in);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                quotedPrintableDecoderStream = quotedPrintableDecoderStream;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "decode", quotedPrintableDecoderStream);
            }
            return quotedPrintableDecoderStream;
        }
        throw new IOException("Unknown encoding " + encoding);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isTypeSupported(String contentType, List<String> types) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "isTypeSupported", new Object[]{contentType, types});
        }
        if (contentType == null) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "isTypeSupported", bl);
            }
            return bl;
        }
        contentType = contentType.toLowerCase();
        for (String s : types) {
            if (contentType.indexOf(s) == -1) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "isTypeSupported", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "isTypeSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Attachment createMtomAttachment(boolean isXop, String mimeType, String elementNS, byte[] data, int offset, int length, int threshold) {
        String id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachment", new Object[]{isXop, mimeType, elementNS, data, offset, length, threshold});
        }
        if (!isXop || length <= threshold) {
            Attachment attachment = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                attachment = attachment;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachment", attachment);
            }
            return attachment;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(isXop);
        AttachmentImpl attachmentImpl = att;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attachmentImpl = attachmentImpl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachment", attachmentImpl);
        }
        return attachmentImpl;
    }

    /*
     * Unable to fully structure code
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Attachment createMtomAttachmentFromDH(boolean isXop, DataHandler handler, String elementNS, int threshold) {
        block17: {
            block20: {
                block18: {
                    block19: {
                        block15: {
                            block16: {
                                if (AttachmentUtil.LOG != null && AttachmentUtil.LOG.isLoggable(Level.FINER)) {
                                    AttachmentUtil.LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", new Object[]{isXop, handler, elementNS, threshold});
                                }
                                if (!isXop) {
                                    v0 = null;
                                    if (AttachmentUtil.LOG != null && AttachmentUtil.LOG.isLoggable(Level.FINER)) {
                                        v0 = v0;
                                        AttachmentUtil.LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", v0);
                                    }
                                    return v0;
                                }
                                ds = handler.getDataSource();
                                if (!(ds instanceof FileDataSource)) ** GOTO lbl27
                                fds = (FileDataSource)ds;
                                file = fds.getFile();
                                if (file.length() >= (long)threshold) break block15;
                                if (AttachmentUtil.LOG.isLoggable(Level.FINEST)) {
                                    AttachmentUtil.LOG.finest("createMtomAttachmentFromDH: file.length is < threshold: " + file.length());
                                }
                                v1 = null;
                                if (AttachmentUtil.LOG == null || !AttachmentUtil.LOG.isLoggable(Level.FINER)) break block16;
                                v1 = v1;
                                AttachmentUtil.LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", v1);
                            }
                            return v1;
                        }
                        break block17;
lbl27:
                        // 1 sources

                        if (!ds.getClass().getName().endsWith("ObjectDataSource")) break block17;
                        o = handler.getContent();
                        if (!(o instanceof String) || ((String)o).length() >= threshold) break block18;
                        if (AttachmentUtil.LOG.isLoggable(Level.FINEST)) {
                            AttachmentUtil.LOG.finest("createMtomAttachmentFromDH: handler size is < threshold: " + ((String)o).length());
                        }
                        v2 = null;
                        if (AttachmentUtil.LOG == null || !AttachmentUtil.LOG.isLoggable(Level.FINER)) break block19;
                        v2 = v2;
                        AttachmentUtil.LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", v2);
                    }
                    return v2;
                }
                try {
                    if (!(o instanceof byte[]) || ((byte[])o).length >= threshold) break block17;
                    if (AttachmentUtil.LOG.isLoggable(Level.FINEST)) {
                        AttachmentUtil.LOG.finest("createMtomAttachmentFromDH: byte size is < threshold: " + ((byte[])o).length);
                    }
                    v3 = null;
                    if (AttachmentUtil.LOG == null || !AttachmentUtil.LOG.isLoggable(Level.FINER)) break block20;
                }
                catch (IOException e1) {
                    if (!AttachmentUtil.LOG.isLoggable(Level.FINEST)) break block17;
                    AttachmentUtil.LOG.finest("Ignoring IOException: " + e1);
                }
                v3 = v3;
                AttachmentUtil.LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", v3);
            }
            return v3;
        }
        try {
            id = AttachmentUtil.createContentID(elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault(e);
        }
        att = new AttachmentImpl(id, handler);
        if (!StringUtils.isEmpty(handler.getName())) {
            file = handler.getName();
            f = new File((String)file);
            if (f.exists() && f.isFile()) {
                file = f.getName();
            }
            att.setHeader("Content-Disposition", "attachment;name=\"" + (String)file + "\"");
        }
        att.setXOP(isXop);
        v4 = att;
        if (AttachmentUtil.LOG != null && AttachmentUtil.LOG.isLoggable(Level.FINER)) {
            v4 = v4;
            AttachmentUtil.LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "createMtomAttachmentFromDH", v4);
        }
        return v4;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static DataSource getAttachmentDataSource(String contentId, Collection<Attachment> atts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentDataSource", new Object[]{contentId, atts});
        }
        if (contentId.startsWith("cid:")) {
            DataSource dataSource;
            block14: {
                block12: {
                    URLDataSource uRLDataSource;
                    block13: {
                        try {
                            contentId = URLDecoder.decode(contentId.substring(4), StandardCharsets.UTF_8.name());
                        }
                        catch (UnsupportedEncodingException ue) {
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("UnsupportedEncodingException occurred: " + ue);
                            }
                            contentId = contentId.substring(4);
                        }
                        if (contentId.indexOf("://") == -1) {
                            DataSource dataSource2 = AttachmentUtil.loadDataSource(contentId, atts);
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                dataSource2 = dataSource2;
                                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentDataSource", dataSource2);
                            }
                            return dataSource2;
                        }
                        try {
                            boolean followUrls = Boolean.valueOf(SystemPropertyAction.getProperty(ATTACHMENT_XOP_FOLLOW_URLS_PROPERTY, "false"));
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("org.apache.cxf.attachment.xop.follow.urls property is set to: " + followUrls);
                            }
                            if (!followUrls) break block12;
                            uRLDataSource = new URLDataSource(new URL(contentId));
                            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block13;
                        }
                        catch (MalformedURLException e) {
                            throw new Fault(e);
                        }
                        uRLDataSource = uRLDataSource;
                        LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentDataSource", uRLDataSource);
                    }
                    return uRLDataSource;
                }
                dataSource = AttachmentUtil.loadDataSource(contentId, atts);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block14;
                dataSource = dataSource;
                LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentDataSource", dataSource);
            }
            return dataSource;
        }
        DataSource dataSource = AttachmentUtil.loadDataSource(contentId, atts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataSource = dataSource;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "getAttachmentDataSource", dataSource);
        }
        return dataSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static DataSource loadDataSource(String contentId, Collection<Attachment> atts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentUtil", "loadDataSource", new Object[]{contentId, atts});
        }
        LazyDataSource lazyDataSource = new LazyDataSource(contentId, atts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            lazyDataSource = lazyDataSource;
            LOG.exiting("org.apache.cxf.attachment.AttachmentUtil", "loadDataSource", lazyDataSource);
        }
        return lazyDataSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        ATT_UUID = UUID.randomUUID().toString();
        BOUND_RANDOM = new Random();
        DEFAULT_COMMAND_MAP = CommandMap.getDefaultCommandMap();
        COMMAND_MAP = new EnhancedMailcapCommandMap();
        LOG = LogUtils.getL7dLogger(AttachmentUtil.class);
        COMMAND_MAP.addMailcap("image/*;;x-java-content-handler=" + ImageDataContentHandler.class.getName());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class DHMap
    extends AbstractMap<String, DataHandler> {
        final Collection<Attachment> list;
        static final long serialVersionUID = 5251424324165190450L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DHMap(Collection<Attachment> l) {
            this.list = l;
        }

        @Override
        public Set<Map.Entry<String, DataHandler>> entrySet() {
            return new AbstractSet<Map.Entry<String, DataHandler>>(){
                static final long serialVersionUID = -336110386824919298L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Iterator<Map.Entry<String, DataHandler>> iterator() {
                    final Iterator<Attachment> it = list.iterator();
                    return new Iterator<Map.Entry<String, DataHandler>>(){
                        static final long serialVersionUID = -5959461020778514409L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, DataHandler> next() {
                            final Attachment a = (Attachment)it.next();
                            return new Map.Entry<String, DataHandler>(){
                                static final long serialVersionUID = 4302303811930031521L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public String getKey() {
                                    return a.getId();
                                }

                                @Override
                                public DataHandler getValue() {
                                    return a.getDataHandler();
                                }

                                @Override
                                public DataHandler setValue(DataHandler value) {
                                    return null;
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.attachment.AttachmentUtil$DHMap$1$1$1", DHMap.1.class, null, null);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            it.remove();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.attachment.AttachmentUtil$DHMap$1$1", DHMap.1.class, null, null);
                        }
                    };
                }

                @Override
                public int size() {
                    return list.size();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.attachment.AttachmentUtil$DHMap$1", 1.class, null, null);
                }
            };
        }

        @Override
        public DataHandler put(String key, DataHandler value) {
            Iterator<Attachment> i = this.list.iterator();
            DataHandler ret = null;
            while (i.hasNext()) {
                Attachment a = i.next();
                if (!a.getId().equals(key)) continue;
                i.remove();
                ret = a.getDataHandler();
                break;
            }
            this.list.add(new AttachmentImpl(key, value));
            return ret;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.attachment.AttachmentUtil$DHMap", DHMap.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static final class EnhancedMailcapCommandMap
    extends MailcapCommandMap {
        static final long serialVersionUID = 3735242128470608214L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EnhancedMailcapCommandMap() {
        }

        public synchronized DataContentHandler createDataContentHandler(String mimeType) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("createDataContentHandler using DEFAULT_COMMAND_MAP");
                }
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType);
            }
            return dch;
        }

        public DataContentHandler createDataContentHandler(String mimeType, DataSource ds) {
            DataContentHandler dch = super.createDataContentHandler(mimeType);
            if (dch == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("createDataContentHandler using DEFAULT_COMMAND_MAP for DataSource: " + (ds != null ? ds.getName() : "NULL"));
                }
                dch = DEFAULT_COMMAND_MAP.createDataContentHandler(mimeType, ds);
            }
            return dch;
        }

        public synchronized CommandInfo[] getAllCommands(String mimeType) {
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            CommandInfo[] commands = super.getAllCommands(mimeType);
            CommandInfo[] defaultCommands = DEFAULT_COMMAND_MAP.getAllCommands(mimeType);
            ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>(Arrays.asList(commands));
            for (CommandInfo defCmdInfo : defaultCommands) {
                String defCmdName = defCmdInfo.getCommandName();
                boolean cmdNameExist = false;
                for (CommandInfo cmdInfo : commands) {
                    if (isFinestEnabled) {
                        LOG.finest("getAllCommands: processing cmd: " + cmdInfo.getCommandName());
                    }
                    if (!cmdInfo.getCommandName().equals(defCmdName)) continue;
                    cmdNameExist = true;
                    if (!isFinestEnabled) break;
                    LOG.finest("getAllCommands: Found command " + defCmdName);
                    break;
                }
                if (cmdNameExist) continue;
                if (isFinestEnabled) {
                    LOG.finest("getAllCommands: Cmd does not exist, using default: " + defCmdName);
                }
                cmdList.add(defCmdInfo);
            }
            CommandInfo[] allCommandArray = new CommandInfo[]{};
            return cmdList.toArray(allCommandArray);
        }

        public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
            CommandInfo cmdInfo = super.getCommand(mimeType, cmdName);
            if (cmdInfo == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("super getCommand returned null, so using default");
                }
                cmdInfo = DEFAULT_COMMAND_MAP.getCommand(mimeType, cmdName);
            }
            return cmdInfo;
        }

        public synchronized String[] getMimeTypes() {
            String[] mimeTypes = super.getMimeTypes();
            String[] defMimeTypes = DEFAULT_COMMAND_MAP.getMimeTypes();
            HashSet<String> mimeTypeSet = new HashSet<String>();
            mimeTypeSet.addAll(Arrays.asList(mimeTypes));
            mimeTypeSet.addAll(Arrays.asList(defMimeTypes));
            String[] mimeArray = new String[]{};
            return mimeTypeSet.toArray(mimeArray);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.attachment.AttachmentUtil$EnhancedMailcapCommandMap", EnhancedMailcapCommandMap.class, null, null);
        }
    }
}

