/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;

@Trivial
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageImpl.class);
    private static final long serialVersionUID = -3020763696429459865L;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] contents = new Object[20];
    private int index;
    private static final Object NOT_FOUND = new Object();

    public MessageImpl() {
    }

    public MessageImpl(int initialSize, float factor) {
        super(initialSize, factor);
    }

    public MessageImpl(Message m) {
        super(m);
        if (!(m instanceof MessageImpl)) {
            throw new RuntimeException("Not a MessageImpl! " + m.getClass());
        }
        MessageImpl impl = (MessageImpl)m;
        this.exchange = impl.getExchange();
        this.id = impl.id;
        this.interceptorChain = impl.interceptorChain;
        this.contents = impl.contents;
        this.index = impl.index;
    }

    @Override
    public Collection<Attachment> getAttachments() {
        return CastUtils.cast((Collection)this.get(ATTACHMENTS));
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.put(ATTACHMENTS, attachments);
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return this.get(Destination.class);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("MessageImpl", "getContent");
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            if (isFinestEnabled) {
                LOG.finest("getContent returning class: " + (this.contents[x + 1] != null ? this.contents[x + 1].getClass().getCanonicalName() : "NULL"));
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.exiting("MessageImpl", "getContent");
            }
            return (T)this.contents[x + 1];
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting("MessageImpl", "getContent", "contents did not match format.");
        }
        return null;
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        boolean isFinestEnabled;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("MessageImpl", "setContent");
        }
        if (isFinestEnabled = LOG.isLoggable(Level.FINEST)) {
            this.logContent(content);
        }
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            if (isFinestEnabled) {
                LOG.finest("setContent: Found format: Setting contents[" + x + 1 + "] to " + (content != null ? content.getClass().getCanonicalName() : "NULL"));
            }
            this.contents[x + 1] = content;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.exiting("MessageImpl", "setContent");
            }
            return;
        }
        if (this.index >= this.contents.length) {
            if (isFinestEnabled) {
                LOG.finest("Index: " + this.index + " is >= contents length: " + this.contents.length);
            }
            Object[] tmp = new Object[this.contents.length + 10];
            System.arraycopy(this.contents, 0, tmp, 0, this.contents.length);
            this.contents = tmp;
        }
        this.contents[this.index] = format;
        this.contents[this.index + 1] = content;
        this.index += 2;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting("MessageImpl", "setContent");
        }
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("MessageImpl", "removeContent");
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            if (isFinestEnabled) {
                LOG.finest("removeContent: Found content for format: " + (format != null ? format.getCanonicalName() : "null"));
            }
            this.index -= 2;
            if (x != this.index) {
                this.contents[x] = this.contents[this.index];
                this.contents[x + 1] = this.contents[this.index + 1];
            }
            if (isFinestEnabled) {
                LOG.finest("removeContent: " + (this.contents[this.index] != null ? this.contents[this.index].getClass().getCanonicalName() : "null"));
            }
            this.contents[this.index] = null;
            this.contents[this.index + 1] = null;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.exiting("MessageImpl", "removeContent");
            }
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.exiting("MessageImpl", "removeContent");
        }
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        HashSet c = new HashSet();
        for (int x = 0; x < this.index; x += 2) {
            c.add((Class)this.contents[x]);
        }
        return c;
    }

    public void setDestination(Destination d) {
        this.put(Destination.class, d);
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("MessageImpl:setId to " + i);
        }
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object getContextualProperty(String key) {
        Object o = this.getOrDefault(key, NOT_FOUND);
        if (o != NOT_FOUND) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("MessageImpl:getContextualProperty from default for " + key);
            }
            return o;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("MessageImpl:getContextualProperty from Exchange for " + key);
        }
        return this.getFromExchange(key);
    }

    private Object getFromExchange(String key) {
        Exchange ex = this.getExchange();
        if (ex != null) {
            Service sv;
            Map<String, Object> p;
            Object o = ex.getOrDefault(key, NOT_FOUND);
            if (o != NOT_FOUND) {
                return o;
            }
            Endpoint ep = ex.getEndpoint();
            if (ep != null) {
                o = ep.getOrDefault(key, NOT_FOUND);
                if (o != NOT_FOUND) {
                    return o;
                }
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                    p = ei.getBinding().getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                }
            }
            if ((sv = ex.getService()) != null && (o = sv.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
        }
        return null;
    }

    private void logContent(Object content) {
        if (content instanceof List) {
            for (Object o1 : (List)content) {
                if (o1 != null && o1.getClass() != null) {
                    LOG.finest("Setcontent param: " + o1.getClass().getCanonicalName());
                }
                if (!(o1 instanceof Holder) || o1 == null || ((Holder)o1).value == null) continue;
                LOG.finest("Setcontent Holder type: " + ((Holder)o1).value.getClass());
            }
        }
    }

    private Set<String> getExchangeKeySet() {
        HashSet<String> keys = new HashSet<String>();
        Exchange ex = this.getExchange();
        if (ex != null) {
            Endpoint ep;
            Service sv;
            Map<String, Object> p;
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && !p.isEmpty()) {
                keys.addAll(p.keySet());
            }
            if ((sv = ex.getService()) != null && !sv.isEmpty()) {
                keys.addAll(sv.keySet());
            }
            if ((ep = ex.getEndpoint()) != null) {
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getBinding().getProperties();
                    if (p != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                    if ((p = ei.getProperties()) != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                }
                if (!ep.isEmpty()) {
                    keys.addAll(ep.keySet());
                }
            }
            if (!ex.isEmpty()) {
                keys.addAll(ex.keySet());
            }
        }
        return keys;
    }

    @Override
    public Set<String> getContextualPropertyKeys() {
        Set<String> s = this.getExchangeKeySet();
        s.addAll(this.keySet());
        return s;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }

    @Override
    public void resetContextCache() {
    }

    public void setContextualProperty(String key, Object v) {
        if (!this.containsKey(key)) {
            this.put(key, v);
        }
    }
}

