/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class JcaPGPKeyConverter {
    private static final int X25519_KEY_SIZE = 32;
    private static final int ED25519_KEY_SIZE = 32;
    private static final PGPKdfParameters DEFAULT_KDF_PARAMETERS = new PGPKdfParameters(8, 7);
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, privateKey);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n, pGPAlgorithmParameters, publicKey, date);
        return new PGPPublicKey(new PublicKeyPacket(n, date, bCPGKey), this.fingerPrintCalculator);
    }

    public PGPPublicKey getPGPPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, null, publicKey, date);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey();
        }
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePrivate("DSA", dSAPrivateKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    if (CryptlibObjectIdentifiers.curvey25519.equals(eCDHPublicBCPGKey.getCurveOID())) {
                        return this.implGetPrivateKeyPKCS8("XDH", new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(eCSecretBCPGKey.getX())))));
                    }
                    return this.implGetPrivateKeyEC("ECDH", eCDHPublicBCPGKey, eCSecretBCPGKey);
                }
                case 19: {
                    return this.implGetPrivateKeyEC("ECDSA", (ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    EdSecretBCPGKey edSecretBCPGKey = (EdSecretBCPGKey)bCPGKey;
                    return this.implGetPrivateKeyPKCS8("EdDSA", new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(BigIntegers.asUnsignedByteArray(32, edSecretBCPGKey.getX()))));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(elGamalSecretBCPGKey.getX(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePrivate("ElGamal", dHPrivateKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    return this.implGeneratePrivate("RSA", rSAPrivateCrtKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PublicKey getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePublic("DSA", dSAPublicKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (eCDHPublicBCPGKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHPublicBCPGKey.getEncodedPoint());
                        if (byArray.length < 1 || 64 != byArray[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509("XDH", new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), Arrays.copyOfRange(byArray, 1, byArray.length)));
                    }
                    return this.implGetPublicKeyEC("ECDH", eCDHPublicBCPGKey);
                }
                case 19: {
                    return this.implGetPublicKeyEC("ECDSA", (ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    byte[] byArray = BigIntegers.asUnsignedByteArray(edDSAPublicBCPGKey.getEncodedPoint());
                    if (byArray.length < 1 || 64 != byArray[0]) {
                        throw new IllegalArgumentException("Invalid Ed25519 public key");
                    }
                    return this.implGetPublicKeyX509("EdDSA", new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), Arrays.copyOfRange(byArray, 1, byArray.length)));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(elGamalPublicBCPGKey.getY(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePublic("ElGamal", dHPublicKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    return this.implGeneratePublic("RSA", rSAPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException {
        return this.getECParameterSpec(aSN1ObjectIdentifier, JcaJcePGPUtil.getX9Parameters(aSN1ObjectIdentifier));
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParameters x9ECParameters) throws InvalidParameterSpecException, NoSuchProviderException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
        algorithmParameters.init(new ECGenParameterSpec(ECNamedCurveTable.getName(aSN1ObjectIdentifier)));
        return algorithmParameters.getParameterSpec(ECParameterSpec.class);
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                return new DSASecretBCPGKey(dSAPrivateKey.getX());
            }
            case 18: {
                if (privateKey instanceof ECPrivateKey) {
                    ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                    return new ECSecretBCPGKey(eCPrivateKey.getS());
                }
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(privateKey.getEncoded());
                try {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverse(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets())));
                }
                catch (IOException iOException) {
                    throw new PGPException(iOException.getMessage(), iOException);
                }
            }
            case 19: {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                return new ECSecretBCPGKey(eCPrivateKey.getS());
            }
            case 22: {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(privateKey.getEncoded());
                try {
                    return new EdSecretBCPGKey(new BigInteger(1, ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets()));
                }
                catch (IOException iOException) {
                    throw new PGPException(iOException.getMessage(), iOException);
                }
            }
            case 16: 
            case 20: {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                return new ElGamalSecretBCPGKey(dHPrivateKey.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                return new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            return new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            return new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY());
        }
        if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            return new ElGamalPublicBCPGKey(dHParameterSpec.getP(), dHParameterSpec.getG(), dHPublicKey.getY());
        }
        if (publicKey instanceof ECPublicKey) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            X9ECParametersHolder x9ECParametersHolder = ECNamedCurveTable.getByOIDLazy(aSN1ObjectIdentifier);
            DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParametersHolder.getCurve(), dEROctetString);
            if (n == 18) {
                PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(pGPAlgorithmParameters);
                return new ECDHPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
            }
            if (n == 19) {
                return new ECDSAPublicBCPGKey(aSN1ObjectIdentifier, x9ECPoint.getPoint());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (publicKey.getAlgorithm().regionMatches(true, 0, "ED2", 0, 3)) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            System.arraycopy(subjectPublicKeyInfo.getPublicKeyData().getBytes(), 0, byArray, 1, byArray.length - 1);
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, byArray));
        }
        if (publicKey.getAlgorithm().regionMatches(true, 0, "X2", 0, 2)) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            byte[] byArray = new byte[33];
            byArray[0] = 64;
            System.arraycopy(subjectPublicKeyInfo.getPublicKeyData().getBytes(), 0, byArray, 1, byArray.length - 1);
            PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(pGPAlgorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, byArray), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
        }
        throw new PGPException("unknown key class");
    }

    private PrivateKey implGeneratePrivate(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey implGeneratePublic(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePublic(keySpec);
    }

    private PGPKdfParameters implGetKdfParameters(PGPAlgorithmParameters pGPAlgorithmParameters) {
        return null == pGPAlgorithmParameters ? DEFAULT_KDF_PARAMETERS : (PGPKdfParameters)pGPAlgorithmParameters;
    }

    private PrivateKey implGetPrivateKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws GeneralSecurityException, PGPException {
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.getECParameterSpec(eCPublicBCPGKey.getCurveOID()));
        return this.implGeneratePrivate(string, eCPrivateKeySpec);
    }

    private PrivateKey implGetPrivateKeyPKCS8(String string, PrivateKeyInfo privateKeyInfo) throws GeneralSecurityException, IOException, PGPException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
        return this.implGeneratePrivate(string, pKCS8EncodedKeySpec);
    }

    private PublicKey implGetPublicKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey) throws GeneralSecurityException, IOException, PGPException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = JcaJcePGPUtil.getX9Parameters(aSN1ObjectIdentifier);
        org.bouncycastle.math.ec.ECPoint eCPoint = JcaJcePGPUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(aSN1ObjectIdentifier, x9ECParameters));
        return this.implGeneratePublic(string, eCPublicKeySpec);
    }

    private PublicKey implGetPublicKeyX509(String string, SubjectPublicKeyInfo subjectPublicKeyInfo) throws GeneralSecurityException, IOException, PGPException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        return this.implGeneratePublic(string, x509EncodedKeySpec);
    }
}

