/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connectionpool.monitor.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.connectionpool.monitor.metrics.ConnectionPoolMetricAdapter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.ibm.ws.monitor.internal.MonitoringFrameworkExtender"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true)
public class MetricsManager {
    private static MetricsManager instance;
    private static final TraceComponent tc;
    private static final String MONITORING_GROUP_FILTER = "filter";
    private static volatile boolean isConnPoolEnabled;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ConnectionPoolMetricAdapter> metricRuntimes;

    public static boolean isConnPoolEnabled() {
        return isConnPoolEnabled;
    }

    @Activate
    public void activate(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
        instance = this;
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    @Deactivate
    public void deactivate() {
        instance = null;
    }

    public static MetricsManager getInstance() {
        if (instance != null) {
            return instance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No MetricsManager Instance available ", (Object[])new Object[0]);
        }
        return null;
    }

    public void updateWaitTimeMetrics(String poolName, Duration duration) {
        if (isConnPoolEnabled) {
            this.metricRuntimes.stream().forEach(adapters -> adapters.updateWaitTimeMetrics(poolName, duration));
        }
    }

    public void updateInUseTimeMetrics(String poolName, Duration duration) {
        if (isConnPoolEnabled) {
            this.metricRuntimes.stream().forEach(adapters -> adapters.updateInUseTimeMetrics(poolName, duration));
        }
    }

    private void resolveMonitorFilter(Map<String, Object> properties) {
        String filter = (String)properties.get(MONITORING_GROUP_FILTER);
        if (filter != null && filter.length() != 0) {
            isConnPoolEnabled = filter.length() > 0 ? Stream.of(filter.split(",")).anyMatch(item -> item.equals("ConnectionPool")) : true;
        } else if (filter == null) {
            isConnPoolEnabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("ConnectionPool filter is enabled set to: [%s]", isConnPoolEnabled), (Object[])new Object[0]);
        }
    }

    static {
        tc = Tr.register(MetricsManager.class);
        isConnPoolEnabled = true;
    }
}

