/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.saml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.ws.rs.ProcessingException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PropagationHandler
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(PropagationHandler.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    static final long serialVersionUID = 7323809712387623421L;

    public PropagationHandler() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Object samlHandler = message.get((Object)"com.ibm.ws.jaxrs.client.saml.sendToken");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Please check if customer is using the [com.ibm.ws.jaxrs.client.saml.sendToken], client configuration property and the value should be true", (Object[])new Object[0]);
        }
        if (samlHandler != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client configuration property [com.ibm.ws.jaxrs.client.saml.sendToken] value is " + samlHandler), (Object[])new Object[0]);
            }
            String handler = samlHandler.toString().toLowerCase();
            this.configClientSAMLHandler(message, handler);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={NoClassDefFoundError.class})
    private void configClientSAMLHandler(Message message, String samlHander) {
        if (samlHander.equals("true")) {
            String address;
            String saml = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Entering SAML Handler", (Object[])new Object[0]);
            }
            if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)).startsWith("https") && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user is using SSL connection", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"About to get a SAML authentication token from the runAs Subject", (Object[])new Object[0]);
            }
            try {
                saml = PropagationHandler.getEncodedSaml20Token();
                if (saml == null || saml.isEmpty()) return;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved the encoded SAML token. About to set it on the request Header " + saml), (Object[])new Object[0]);
                }
                Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
                headers.put("Authorization", Arrays.asList("SAML " + saml));
                message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
                return;
            }
            catch (NoClassDefFoundError ncdfe) {
                Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{ncdfe});
                return;
            }
            catch (Throwable ncdfe) {
                void e;
                FFDCFilter.processException((Throwable)ncdfe, (String)"com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler", (String)"100", (Object)((Object)this), (Object[])new Object[]{message, samlHander});
                Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e});
                throw new ProcessingException((Throwable)e);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"No client SAML handler configuration is specified, skipping this handler.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchMethodException.class})
    public static String getEncodedSaml20Token() {
        String base64Saml = null;
        String samlString = null;
        try {
            Subject subject = WSSubject.getRunAsSubject();
            for (Object credential : subject.getPrivateCredentials()) {
                try {
                    Class<?> credentialClass = credential.getClass();
                    Method method = credentialClass.getDeclaredMethod("getSAMLAsString", new Class[0]);
                    samlString = (String)method.invoke(credential, new Object[0]);
                    break;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler", (String)"127", null, (Object[])new Object[0]);
                    Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            }
        }
        catch (Exception subject) {
            void e;
            FFDCFilter.processException((Throwable)subject, (String)"com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler", (String)"131", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting SAML token from subject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        if (samlString != null) {
            byte[] output = samlString.getBytes(StandardCharsets.UTF_8);
            if (output != null) {
                base64Saml = Base64Coder.base64EncodeToString((byte[])output);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error while trying to get token bytes using utf-8:", (Object[])new Object[0]);
            }
        }
        return base64Saml;
    }
}

