/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.ExtractableArtifactEntry;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileContainerUtils;
import com.ibm.ws.artifact.zip.internal.ZipFileNestedDirContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipFileEntry
implements ExtractableArtifactEntry {
    static final TraceComponent tc = Tr.register(ZipFileEntry.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
    private final ZipFileContainer rootContainer;
    private final ZipFileContainerUtils.ZipEntryData zipEntryData;
    private final AtomicBoolean jarProtocolVirtualDirWarning = new AtomicBoolean();
    private final String name;
    private final String a_path;
    private volatile ZipFileNestedDirContainer localContainer;
    private volatile ArtifactContainer enclosingContainer;
    public static final boolean LOCAL_ONLY = true;
    public static final boolean LOCAL_AND_REMOTE = false;
    private volatile Boolean conversion;
    static final long serialVersionUID = -3899951938424616126L;

    @Trivial
    protected ZipFileEntry(ZipFileContainer rootContainer, ArtifactContainer enclosingContainer, ZipFileContainerUtils.ZipEntryData zipEntryData, String name, String a_path) {
        this.rootContainer = rootContainer;
        this.enclosingContainer = enclosingContainer;
        this.zipEntryData = zipEntryData;
        this.name = name;
        this.a_path = a_path;
    }

    @Trivial
    public ArtifactContainer getRoot() {
        return this.rootContainer;
    }

    @Trivial
    public ContainerFactoryHolder getContainerFactoryHolder() {
        return this.rootContainer.getContainerFactoryHolder();
    }

    public File extract() throws IOException {
        return this.rootContainer.extract(this);
    }

    @Trivial
    public ZipFileContainerUtils.ZipEntryData getZipEntryData() {
        return this.zipEntryData;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    public URL getResource() {
        URI entryUri;
        String useRelPath = this.getRelativePath();
        if (this.zipEntryData == null || this.zipEntryData.isDirectory()) {
            useRelPath = useRelPath + "/";
        }
        if ((entryUri = this.rootContainer.createEntryUri(useRelPath)) == null) {
            return null;
        }
        if (this.zipEntryData == null && "jar".equals(this.rootContainer.getProtocol())) {
            if (this.jarProtocolVirtualDirWarning.compareAndSet(false, true)) {
                Tr.warning((TraceComponent)tc, (String)"CWWKM0129W.missing.dir.entry", (Object[])new Object[]{this.rootContainer.getArchiveFilePath(), useRelPath});
            }
            return null;
        }
        try {
            return entryUri.toURL();
        }
        catch (MalformedURLException e) {
            if (FrameworkState.isStopping()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MalformedURLException during OSGi framework stop.", (Object[])new Object[]{e.getMessage()});
                } else {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"269");
                }
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream() throws IOException {
        InputStream baseInputStream;
        if (this.zipEntryData == null || this.zipEntryData.isDirectory()) {
            return null;
        }
        final ZipFileHandle zipFileHandle = this.rootContainer.getZipFileHandle();
        ZipFile zipFile = zipFileHandle.open();
        try {
            baseInputStream = zipFileHandle.getInputStream(zipFile, this.zipEntryData.getPath());
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry", (String)"199", (Object)this, (Object[])new Object[0]);
            zipFileHandle.close();
            throw th;
        }
        if (baseInputStream == null) {
            throw new FileNotFoundException("Zip file [ " + zipFile.getName() + " ] failed to provide input stream for entry [ " + this.zipEntryData.getPath() + " ]");
        }
        InputStream inputStream = new InputStream(){
            private final InputStream wrappedInputStream;
            private volatile boolean isClosed;
            static final long serialVersionUID = -2231034182933932328L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.wrappedInputStream = baseInputStream;
            }

            public synchronized void finalize() throws Throwable {
                this.close();
                super.finalize();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (!this.isClosed) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.isClosed) {
                            try {
                                this.wrappedInputStream.close();
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry$1", (String)"235", (Object)this, (Object[])new Object[0]);
                            }
                            zipFileHandle.close();
                            this.isClosed = true;
                        }
                    }
                }
            }

            @Override
            @Trivial
            public int read(byte[] b) throws IOException {
                return this.wrappedInputStream.read(b);
            }

            @Override
            @Trivial
            public int read(byte[] b, int off, int len) throws IOException {
                return this.wrappedInputStream.read(b, off, len);
            }

            @Override
            @Trivial
            public long skip(long n) throws IOException {
                return this.wrappedInputStream.skip(n);
            }

            @Override
            @Trivial
            public int available() throws IOException {
                return this.wrappedInputStream.available();
            }

            @Override
            @Trivial
            public void mark(int readlimit) {
                this.wrappedInputStream.mark(readlimit);
            }

            @Override
            @Trivial
            public void reset() throws IOException {
                this.wrappedInputStream.reset();
            }

            @Override
            @Trivial
            public boolean markSupported() {
                return this.wrappedInputStream.markSupported();
            }

            @Override
            public int read() throws IOException {
                return this.wrappedInputStream.read();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.internal.ZipFileEntry$1", 1.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
            }
        };
        return inputStream;
    }

    @Trivial
    public long getSize() {
        if (this.zipEntryData != null) {
            return this.zipEntryData.getSize();
        }
        return 0L;
    }

    @Trivial
    public long getLastModified() {
        if (this.zipEntryData != null) {
            return this.zipEntryData.getTime();
        }
        return 0L;
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    public String getPath() {
        return this.a_path;
    }

    @Trivial
    public String getAbsolutePath() {
        return this.a_path;
    }

    @Trivial
    public String getRelativePath() {
        return this.a_path.substring(1);
    }

    @Trivial
    @Deprecated
    public String getPhysicalPath() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipFileNestedDirContainer convertToLocalContainer() {
        if (this.zipEntryData != null && !this.zipEntryData.isDirectory()) {
            return null;
        }
        if (this.localContainer == null) {
            ZipFileEntry zipFileEntry = this;
            synchronized (zipFileEntry) {
                if (this.localContainer == null) {
                    this.localContainer = new ZipFileNestedDirContainer(this.rootContainer, this, this.name, this.a_path);
                }
            }
        }
        return this.localContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactContainer getEnclosingContainer() {
        if (this.enclosingContainer == null) {
            ZipFileEntry zipFileEntry = this;
            synchronized (zipFileEntry) {
                if (this.enclosingContainer == null) {
                    String a_enclosingPath = PathUtils.getParent((String)this.a_path);
                    int parentLen = a_enclosingPath.length();
                    if (parentLen == 1) {
                        this.enclosingContainer = this.rootContainer;
                    } else {
                        String r_enclosingPath = a_enclosingPath.substring(1);
                        int lastSlash = r_enclosingPath.lastIndexOf(47);
                        String enclosingName = lastSlash == -1 ? r_enclosingPath : r_enclosingPath.substring(lastSlash + 1);
                        ZipFileEntry entryInEnclosingContainer = this.rootContainer.createEntry(enclosingName, a_enclosingPath, r_enclosingPath);
                        this.enclosingContainer = entryInEnclosingContainer.convertToLocalContainer();
                    }
                }
            }
        }
        return this.enclosingContainer;
    }

    public ArtifactContainer convertToContainer() {
        return this.convertToContainer(false);
    }

    public ArtifactContainer convertToContainer(boolean localOnly) {
        ZipFileNestedDirContainer useLocalContainer = this.convertToLocalContainer();
        if (useLocalContainer != null || localOnly) {
            return useLocalContainer;
        }
        if (this.conversion != null && !this.conversion.booleanValue()) {
            return null;
        }
        File newCacheDir = this.rootContainer.getCacheDir(this);
        ArtifactContainer container = this.getContainerFactoryHolder().getContainerFactory().getContainer(newCacheDir, this.getEnclosingContainer(), (ArtifactEntry)this, (Object)this.zipEntryData);
        if (this.conversion == null) {
            this.conversion = container == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return container;
    }
}

