/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ManagedThreadFactoryService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ManagedVirtualThreadAction
implements Runnable {
    private static final TraceComponent tc = Tr.register(ManagedVirtualThreadAction.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final Runnable action;
    private final ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory;
    static final long serialVersionUID = -7579963949472749194L;

    ManagedVirtualThreadAction(ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory, Runnable action) {
        this.action = action;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("run " + this.action.getClass().getName()), (Object[])new Object[0]);
        }
        try {
            ArrayList contextAppliedToThread = this.threadFactory.threadContextDescriptor.taskStarting();
            try {
                this.action.run();
            }
            finally {
                this.threadFactory.threadContextDescriptor.taskStopping(contextAppliedToThread);
            }
        }
        catch (Error contextAppliedToThread) {
            void x;
            FFDCFilter.processException((Throwable)contextAppliedToThread, (String)"com.ibm.ws.concurrent.internal.ManagedVirtualThreadAction", (String)"68", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        catch (RuntimeException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ManagedVirtualThreadAction", (String)"72", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"run");
        }
    }
}

