/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threadContext;

import com.ibm.ejs.util.FastStack;
import com.ibm.ws.threadContext.ThreadContext;
import com.ibm.ws.util.WSThreadLocal;

public class ThreadContextImpl<T>
extends WSThreadLocal<ThreadContext<T>>
implements ThreadContext<T> {
    private T ivInitialStackEntry = null;

    public ThreadContextImpl() {
    }

    public ThreadContextImpl(T initialStackEntry) {
        this.ivInitialStackEntry = initialStackEntry;
    }

    @Override
    protected ThreadContext<T> initialValue() {
        FastStackThreadContextAdapter<T> stack = new FastStackThreadContextAdapter<T>();
        if (this.ivInitialStackEntry != null) {
            stack.push(this.ivInitialStackEntry);
        }
        return stack;
    }

    @Override
    public T beginContext(T object) {
        return ((ThreadContext)this.get()).beginContext(object);
    }

    @Override
    public T endContext() {
        return ((ThreadContext)this.get()).endContext();
    }

    @Override
    public T getContext() {
        return ((ThreadContext)this.get()).getContext();
    }

    @Override
    public int getContextIndex() {
        return ((ThreadContext)this.get()).getContextIndex();
    }

    private static class FastStackThreadContextAdapter<T>
    extends FastStack<T>
    implements ThreadContext<T> {
        private FastStackThreadContextAdapter() {
        }

        @Override
        public T beginContext(T object) {
            Object oldObj = this.peek();
            this.push(object);
            return oldObj;
        }

        @Override
        public T endContext() {
            return this.pop();
        }

        @Override
        public T getContext() {
            return this.peek();
        }

        @Override
        public int getContextIndex() {
            return this.getTopOfStackIndex();
        }
    }
}

