/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.appconfig.appProperties"}, service={AppPropertiesComponent.class})
public class AppPropertiesComponent {
    private static final Pattern keyValuePattern;
    private volatile Map<String, String> properties = Collections.emptyMap();
    private volatile String pid;
    static final long serialVersionUID = -955824372487124821L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPid() {
        return this.pid;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.properties = this.processProperties(properties);
        this.pid = (String)properties.get("service.pid");
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.properties = this.processProperties(properties);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.pid = null;
        this.properties = Collections.emptyMap();
    }

    private Map<String, String> processProperties(Map<String, Object> properties) {
        HashMap<String, PropertyEntry> propertyEntries = new HashMap<String, PropertyEntry>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Matcher m;
            if (!(entry.getValue() instanceof String) || !(m = keyValuePattern.matcher(entry.getKey())).matches()) continue;
            String index = m.group(1);
            PropertyEntry propertyEntry = propertyEntries.computeIfAbsent(index, k -> new PropertyEntry());
            if (m.group(2).equals("name")) {
                propertyEntry.name = (String)entry.getValue();
                continue;
            }
            propertyEntry.value = (String)entry.getValue();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyEntry entry : propertyEntries.values()) {
            if (entry.name == null || entry.value == null) continue;
            result.put(entry.name, entry.value);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.AppPropertiesComponent", AppPropertiesComponent.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
        keyValuePattern = Pattern.compile("property.(\\d+).(name|value)");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PropertyEntry {
        private String name;
        private String value;
        static final long serialVersionUID = -3494396024714161984L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PropertyEntry() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.AppPropertiesComponent$PropertyEntry", PropertyEntry.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
        }
    }
}

