/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AbstractMBeanIntrospector {
    private static final String INDENT = "    ";
    static final long serialVersionUID = -4867995079561392481L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void introspect(ObjectName objectName, QueryExp query, PrintWriter writer) {
        for (MBeanServer mbeanServer : this.getMBeanServers()) {
            for (ObjectName mbean : mbeanServer.queryNames(objectName, query)) {
                this.introspectMBeanAttributes(mbeanServer, mbean, writer);
            }
        }
    }

    Collection<MBeanServer> getMBeanServers() {
        HashSet<MBeanServer> mbeanServers = new HashSet<MBeanServer>();
        mbeanServers.add(ManagementFactory.getPlatformMBeanServer());
        mbeanServers.addAll(MBeanServerFactory.findMBeanServer(null));
        return mbeanServers;
    }

    @FFDCIgnore(value={Throwable.class})
    void introspectMBeanAttributes(MBeanServer mbeanServer, ObjectName mbean, PrintWriter writer) {
        try {
            MBeanAttributeInfo[] attrs;
            writer.println();
            writer.print(mbeanServer.getMBeanInfo(mbean).getDescription());
            writer.println(" (" + mbean.getCanonicalName() + ")");
            String indent = INDENT;
            for (MBeanAttributeInfo attr : attrs = mbeanServer.getMBeanInfo(mbean).getAttributes()) {
                StringBuilder sb = new StringBuilder();
                sb.append(indent).append(attr.getName()).append(": ");
                sb.append(this.getFormattedAttribute(mbeanServer, mbean, attr, indent));
                writer.println(sb.toString());
            }
        }
        catch (Throwable t) {
            Throwable rootCause = t;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<<Introspection failed: ");
            sb.append(rootCause.getMessage() != null ? rootCause.getMessage() : rootCause);
            sb.append(">>");
            writer.println(sb.toString());
        }
    }

    @FFDCIgnore(value={Throwable.class})
    String getFormattedAttribute(MBeanServer mbeanServer, ObjectName mbean, MBeanAttributeInfo attr, String indent) {
        try {
            Object attribute = mbeanServer.getAttribute(mbean, attr.getName());
            if (attribute == null) {
                return "null";
            }
            if (CompositeData.class.isAssignableFrom(attribute.getClass())) {
                return this.getFormattedCompositeData((CompositeData)CompositeData.class.cast(attribute), indent);
            }
            if (TabularData.class.isAssignableFrom(attribute.getClass())) {
                return this.getFormattedTabularData((TabularData)TabularData.class.cast(attribute), indent);
            }
            if (attribute.getClass().isArray()) {
                return this.getFormattedArray(attribute, indent);
            }
            return String.valueOf(attribute);
        }
        catch (Throwable t) {
            Throwable rootCause = t;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<<Unavailable: ");
            sb.append(rootCause.getMessage() != null ? rootCause.getMessage() : rootCause);
            sb.append(">>");
            return sb.toString();
        }
    }

    String getFormattedArray(Object attribute, String indent) {
        int arrayLength = Array.getLength(attribute);
        if (arrayLength == 0) {
            return "[]";
        }
        Class<?> componentType = attribute.getClass().getComponentType();
        if (componentType.equals(Boolean.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((boolean[])attribute), indent);
        }
        if (componentType.equals(Byte.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((byte[])attribute), indent);
        }
        if (componentType.equals(Character.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((char[])attribute), indent);
        }
        if (componentType.equals(Double.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((double[])attribute), indent);
        }
        if (componentType.equals(Float.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((float[])attribute), indent);
        }
        if (componentType.equals(Integer.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((int[])attribute), indent);
        }
        if (componentType.equals(Long.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((long[])attribute), indent);
        }
        if (componentType.equals(Short.TYPE)) {
            return this.formatPrimitiveArrayString(Arrays.toString((short[])attribute), indent);
        }
        StringBuilder sb = new StringBuilder();
        indent = indent + INDENT;
        Object[] array = (Object[])attribute;
        for (int i = 0; i < array.length; ++i) {
            sb.append("\n").append(indent).append("[").append(i).append("]: ");
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    String formatPrimitiveArrayString(String string, String indent) {
        StringBuilder sb = new StringBuilder();
        indent = indent + INDENT;
        String[] data = string.substring(1, string.length() - 2).split(", ");
        for (int i = 0; i < data.length; ++i) {
            sb.append("\n").append(indent).append("[").append(i).append("]: ");
            sb.append(data[i]);
        }
        return sb.toString();
    }

    String getFormattedCompositeData(CompositeData cd, String indent) {
        StringBuilder sb = new StringBuilder();
        indent = indent + INDENT;
        CompositeType type = cd.getCompositeType();
        for (String key : type.keySet()) {
            sb.append("\n").append(indent);
            sb.append(key).append(": ");
            OpenType<?> openType = type.getType(key);
            if (openType instanceof SimpleType) {
                sb.append(cd.get(key));
                continue;
            }
            if (openType instanceof CompositeType) {
                CompositeData nestedData = (CompositeData)cd.get(key);
                sb.append(this.getFormattedCompositeData(nestedData, indent));
                continue;
            }
            if (!(openType instanceof TabularType)) continue;
            TabularData tabularData = (TabularData)cd.get(key);
            sb.append(tabularData);
        }
        return String.valueOf(sb);
    }

    String getFormattedTabularData(TabularData td, String indent) {
        StringBuilder sb = new StringBuilder();
        indent = indent + INDENT;
        sb.append("{");
        Collection<?> values = td.values();
        int valuesRemaining = values.size();
        for (CompositeData cd : values) {
            sb.append(this.getFormattedCompositeData(cd, indent));
            if (--valuesRemaining <= 0) continue;
            sb.append("\n").append(indent).append("}, {");
        }
        sb.append("}");
        return String.valueOf(sb);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.AbstractMBeanIntrospector", AbstractMBeanIntrospector.class, null, null);
    }
}

