/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WASURLObjectFactoryFinder
implements URLObjectFactoryFinder {
    private static final TraceComponent tc = Tr.register(WASURLObjectFactoryFinder.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    static final long serialVersionUID = 3510482142624895282L;

    public ObjectFactory findFactory(String urlSchema, Hashtable<?, ?> env) throws NamingException {
        String str22;
        ArrayList<String> pkgPrefixes = new ArrayList<String>();
        if (env != null && null != (str22 = (String)env.get("java.naming.factory.url.pkgs"))) {
            StringTokenizer st = new StringTokenizer(str22, ":");
            while (st.hasMoreTokens()) {
                pkgPrefixes.add(st.nextToken());
            }
        }
        pkgPrefixes.add("com.sun.jndi.url");
        try {
            return this.findFactory(urlSchema, pkgPrefixes);
        }
        catch (ClassNotFoundException str22) {
            FFDCFilter.processException((Throwable)str22, (String)"com.ibm.ws.jndi.internal.WASURLObjectFactoryFinder", (String)"62", (Object)this, (Object[])new Object[]{urlSchema, env});
            return null;
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private ObjectFactory findFactory(String urlSchema, List<String> pkgPrefixes) throws ClassNotFoundException {
        Throwable cnfe = null;
        ClassLoader tccl = Privileged.getThreadContextClassLoader();
        for (String pkgPrefix : pkgPrefixes) {
            String className = pkgPrefix + "." + urlSchema + "." + urlSchema + "URLContextFactory";
            try {
                return Privileged.getConstructor(tccl, className).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                if (null == cnfe) {
                    cnfe = new ClassNotFoundException("Could not find factory for schema '" + urlSchema + "'");
                }
                cnfe.addSuppressed(e);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.internal.WASURLObjectFactoryFinder", (String)"81", (Object)this, (Object[])new Object[]{urlSchema, pkgPrefixes});
            }
        }
        if (null != cnfe) {
            throw cnfe;
        }
        return null;
    }

    private static enum Privileged implements PrivilegedAction<ClassLoader>
    {
        GET_TCCL{

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };


        static ClassLoader getThreadContextClassLoader() {
            return AccessController.doPrivileged(GET_TCCL);
        }

        @FFDCIgnore(value={PrivilegedActionException.class})
        static Constructor<? extends ObjectFactory> getConstructor(final ClassLoader tccl, final String className) throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<? extends ObjectFactory>>(){
                    static final long serialVersionUID = 5636670913575639974L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Constructor<? extends ObjectFactory> run() throws ClassNotFoundException, NoSuchMethodException {
                        Class<?> clazz = Class.forName(className, true, tccl);
                        if (!ObjectFactory.class.isAssignableFrom(clazz)) {
                            throw new ClassCastException(ObjectFactory.class.getName() + " is not assignable from " + clazz.getName());
                        }
                        Class<?> ofc = clazz;
                        return ofc.getConstructor(new Class[0]);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.WASURLObjectFactoryFinder$Privileged$2", 2.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }
}

