/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryLogManagerImpl
implements RecoveryLogManager {
    private static final TraceComponent tc = Tr.register(RecoveryLogManagerImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final String _clientName;
    private final int _clientIdentity;
    private final int _clientVersion;
    private final RecoveryAgent _recoveryAgent;
    private final HashMap<Integer, HashMap<FailureScope, RecoveryLog>> _recoveryLogs;
    private final HashMap<Integer, HashMap<String, MultiScopeLog>> _multiScopeRecoveryLogs;
    private final HashMap<String, RecoveryLogFactory> _customLogFactories;
    private String _traceId;
    private SharedServerLeaseLog _leaseLog;
    static final long serialVersionUID = -5766238134306905275L;

    @ManualTrace
    RecoveryLogManagerImpl(RecoveryAgent recoveryAgent, HashMap<String, RecoveryLogFactory> customLogFactories) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryLogManagerImpl", (Object[])new Object[]{recoveryAgent, customLogFactories});
        }
        this._recoveryAgent = recoveryAgent;
        this._customLogFactories = customLogFactories;
        this._clientName = this._recoveryAgent.clientName();
        this._clientVersion = this._recoveryAgent.clientVersion();
        this._clientIdentity = this._recoveryAgent.clientIdentifier();
        this._recoveryLogs = new HashMap();
        this._multiScopeRecoveryLogs = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryLogManagerImpl", (Object)this);
        }
    }

    @Override
    @ManualTrace
    public synchronized RecoveryLog getRecoveryLog(FailureScope failureScope, LogProperties logProperties) throws InvalidLogPropertiesException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoveryLog", (Object[])new Object[]{failureScope, logProperties, this});
        }
        if (!(logProperties instanceof FileLogProperties) && !(logProperties instanceof CustomLogProperties)) {
            InvalidLogPropertiesException ilpe = new InvalidLogPropertiesException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRecoveryLog", (Object)ilpe);
            }
            throw ilpe;
        }
        int logIdentifier = logProperties.logIdentifier();
        RecoveryLog recoveryLog = null;
        HashMap<FailureScope, RecoveryLog> logsByFailureScope = this._recoveryLogs.get(logIdentifier);
        if (logsByFailureScope != null) {
            recoveryLog = logsByFailureScope.get(failureScope);
        } else {
            logsByFailureScope = new HashMap();
            this._recoveryLogs.put(logIdentifier, logsByFailureScope);
        }
        if (recoveryLog == null) {
            if (logProperties instanceof FileLogProperties) {
                MultiScopeLog multiScopeRecoveryLog = null;
                HashMap<String, MultiScopeLog> multiScopeLogsByServerName = null;
                String serverName = failureScope.serverName();
                FileLogProperties fileLogProperties = (FileLogProperties)logProperties;
                int logType = fileLogProperties.logType();
                if (logType == 0) {
                    multiScopeLogsByServerName = this._multiScopeRecoveryLogs.get(logIdentifier);
                    if (multiScopeLogsByServerName != null) {
                        multiScopeRecoveryLog = multiScopeLogsByServerName.get(serverName);
                    } else {
                        multiScopeLogsByServerName = new HashMap();
                        this._multiScopeRecoveryLogs.put(logIdentifier, multiScopeLogsByServerName);
                    }
                }
                if (multiScopeRecoveryLog == null) {
                    multiScopeRecoveryLog = new MultiScopeRecoveryLog(fileLogProperties, this._recoveryAgent, failureScope);
                    if (logType == 0) {
                        multiScopeLogsByServerName.put(serverName, multiScopeRecoveryLog);
                    }
                }
                recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
            } else if (logProperties instanceof CustomLogProperties) {
                MultiScopeLog multiScopeRecoveryLog = null;
                HashMap<String, MultiScopeLog> multiScopeLogsByServerName = null;
                String serverName = failureScope.serverName();
                CustomLogProperties customLogProperties = (CustomLogProperties)logProperties;
                int logType = customLogProperties.logType();
                if (logType == 0) {
                    multiScopeLogsByServerName = this._multiScopeRecoveryLogs.get(logIdentifier);
                    if (multiScopeLogsByServerName != null) {
                        multiScopeRecoveryLog = multiScopeLogsByServerName.get(serverName);
                    } else {
                        multiScopeLogsByServerName = new HashMap();
                        this._multiScopeRecoveryLogs.put(logIdentifier, multiScopeLogsByServerName);
                    }
                }
                if (multiScopeRecoveryLog == null) {
                    String customLogId = customLogProperties.pluginId();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Look in properties with customLogId, " + customLogId), (Object[])new Object[0]);
                    }
                    RecoveryLogFactory factory = this._customLogFactories.get(customLogId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved factory, " + factory), (Object[])new Object[0]);
                    }
                    if (factory == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Custom recovery log factory NOT FOUND for ", (Object[])new Object[]{customLogId});
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
                        }
                        throw new InvalidLogPropertiesException();
                    }
                    recoveryLog = factory.createRecoveryLog(customLogProperties, this._recoveryAgent, Configuration.getRecoveryLogComponent(), failureScope);
                    if (recoveryLog == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Custom recovery log factory returned NULL recovery log", (Object[])new Object[]{customLogId});
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog");
                        }
                        throw new InvalidLogPropertiesException();
                    }
                    if (logType == 0 && recoveryLog instanceof MultiScopeLog) {
                        multiScopeRecoveryLog = (MultiScopeLog)recoveryLog;
                        multiScopeLogsByServerName.put(serverName, multiScopeRecoveryLog);
                        recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
                    }
                } else {
                    recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
                }
            }
            logsByFailureScope.put(failureScope, recoveryLog);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryLog", (Object)recoveryLog);
        }
        return recoveryLog;
    }

    @Override
    @ManualTrace
    public SharedServerLeaseLog getLeaseLog(String localRecoveryIdentity, String recoveryGroup, int leaseCheckInterval, String leaseCheckStrategy, int leaseLength, LogProperties logProperties) throws InvalidLogPropertiesException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeaseLog", (Object[])new Object[]{localRecoveryIdentity, recoveryGroup, leaseCheckInterval, leaseCheckStrategy, leaseLength, logProperties, this});
        }
        SharedServerLeaseLog leaseLog = null;
        CustomLogProperties customLogProperties = null;
        if (logProperties instanceof CustomLogProperties) {
            customLogProperties = (CustomLogProperties)logProperties;
            String customLogId = customLogProperties.pluginId();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Look in properties with customLogId, " + customLogId), (Object[])new Object[0]);
            }
            RecoveryLogFactory factory = this._customLogFactories.get(customLogId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieved factory, " + factory), (Object[])new Object[0]);
            }
            if (factory == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Custom recovery log factory NOT FOUND for ", (Object[])new Object[]{customLogId});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
                }
                throw new InvalidLogPropertiesException();
            }
            leaseLog = factory.createLeaseLog(customLogProperties);
            if (leaseLog == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Custom recovery log factory returned NULL lease log", (Object[])new Object[]{customLogId});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
                }
                throw new InvalidLogPropertiesException();
            }
        } else if (logProperties instanceof FileLogProperties) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found FileLogProperties", (Object[])new Object[0]);
            }
            FileLogProperties fileLogProperties = (FileLogProperties)logProperties;
            Path logDirStem = Paths.get(fileLogProperties.logDirectoryStem(), new String[0]);
            leaseLog = FileSharedServerLeaseLog.getFileSharedServerLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLeaseLog");
            }
            throw new InvalidLogPropertiesException();
        }
        leaseLog.setPeerRecoveryLeaseTimeout(leaseLength);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeaseLog", (Object)leaseLog);
        }
        this._leaseLog = leaseLog;
        return leaseLog;
    }

    public String toString() {
        if (this._traceId == null) {
            this._traceId = "RecoveryLogManagerImpl:clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":clientIdentity=" + this._clientIdentity + " @" + System.identityHashCode(this);
        }
        return this._traceId;
    }

    @Override
    @Trivial
    public SharedServerLeaseLog getLeaseLog() {
        return this._leaseLog;
    }
}

