/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyBooleanConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="LOGGER", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class DefaultBucketConfiguration
extends PropertyBooleanConfiguration {
    private static final String CLASS_NAME = DefaultBucketConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    static final long serialVersionUID = 8738557165181594525L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DefaultBucketConfiguration(String metricName, boolean value) {
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration", "<init>", new Object[]{metricName, value});
        }
        this.metricName = metricName;
        this.isEnabled = value;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Collection<DefaultBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration", "parse", new Object[]{input});
        }
        ArrayDeque<DefaultBucketConfiguration> metricBucketConfiCollection = new ArrayDeque<DefaultBucketConfiguration>();
        if (input == null || input.length() == 0) {
            Collection<DefaultBucketConfiguration> collection = null;
            if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
                collection = collection;
                LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration", "parse", collection);
            }
            return collection;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            DefaultBucketConfiguration metricDefaultedBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            boolean isEnabledParam = Boolean.parseBoolean(keyValueSplit[1].trim());
            metricDefaultedBucketConfiguration = new DefaultBucketConfiguration(metricName, isEnabledParam);
            metricBucketConfiCollection.addFirst(metricDefaultedBucketConfiguration);
        }
        ArrayDeque<DefaultBucketConfiguration> arrayDeque = metricBucketConfiCollection;
        if (LOGGER != null && LOGGER.isLoggable(Level.FINER)) {
            arrayDeque = arrayDeque;
            LOGGER.exiting("io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration", "parse", arrayDeque);
        }
        return arrayDeque;
    }
}

