/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HistogramBucketMaxConfiguration
extends PropertySingleValueConfiguration<Double> {
    private static final TraceComponent tc = Tr.register(HistogramBucketMaxConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -8691098106822524695L;

    public HistogramBucketMaxConfiguration(String metricName, Double value) {
        super(metricName, value);
    }

    public static Collection<HistogramBucketMaxConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<HistogramBucketMaxConfiguration> metricBucketMinMax = new ArrayDeque<HistogramBucketMaxConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketMaxConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length != 2) continue;
            if (keyValueSplit[1].matches("[0-9]+[.]*[0-9]*")) {
                Double value = Double.parseDouble(keyValueSplit[1].trim());
                metricBucketConfiguration = new HistogramBucketMaxConfiguration(metricName, value);
            } else {
                Tr.warning((TraceComponent)tc, (String)"invalidHistogramValueConfigured.warning.CWMMC0015W", (Object[])new Object[]{keyValueSplit[1], "mp.metrics.distribution.histogram.buckets"});
            }
            if (metricBucketConfiguration == null) continue;
            metricBucketMinMax.addFirst(metricBucketConfiguration);
        }
        return metricBucketMinMax;
    }
}

