/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricPercentileConfiguration
extends PropertyArrayConfiguration<Double> {
    private boolean isDisabled = false;
    private static final TraceComponent tc = Tr.register(MetricPercentileConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -1156351104109061813L;

    public MetricPercentileConfiguration(String metricName, Double[] percentileValues) {
        super(metricName, percentileValues);
    }

    public MetricPercentileConfiguration(String metricName, boolean isDisabled) {
        super(metricName, null);
        this.isDisabled = isDisabled;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public static Collection<MetricPercentileConfiguration> parseMetricPercentiles(String input) {
        String[] metricValuePairs;
        ArrayDeque<MetricPercentileConfiguration> metricPercentileConfigCollection = new ArrayDeque<MetricPercentileConfiguration>();
        if (input == null || input.length() == 0) {
            input = "*=";
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            MetricPercentileConfiguration metricPercentileConfiguration;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            if (keyValueSplit.length == 1) {
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, true);
            } else {
                Object[] percentileValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                    if (s.matches("[0][.][0-9]+")) {
                        return Double.parseDouble(s);
                    }
                    Tr.warning((TraceComponent)tc, (String)"invalidPercentileValueConfigured.warning.CWMMC0017W", (Object[])new Object[]{s, "mp.metrics.distribution.percentiles"});
                    return null;
                }).filter(d -> d != null && d >= 0.0 && d <= 1.0).toArray(Double[]::new);
                Arrays.sort(percentileValues);
                metricPercentileConfiguration = new MetricPercentileConfiguration(metricName, (Double[])percentileValues);
            }
            metricPercentileConfigCollection.addFirst(metricPercentileConfiguration);
        }
        return metricPercentileConfigCollection;
    }
}

