/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.PropertyConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricsConfigurationManager {
    private static final TraceComponent tc = Tr.register(MetricsConfigurationManager.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final String MP_PERCENTILES_PROP = "mp.metrics.distribution.percentiles";
    static final String MP_HISTOGRAM_BUCKET_PROP = "mp.metrics.distribution.histogram.buckets";
    static final String MP_TIMER_BUCKET_PROP = "mp.metrics.distribution.timer.buckets";
    static final String MP_DEFAULT_BUCKET_PROP = "mp.metrics.distribution.percentiles-histogram.enabled";
    static final String MP_HISTOGRAM_MAX_CONFIG = "mp.metrics.distribution.histogram.max-value";
    static final String MP_HISTOGRAM_MIN_CONFIG = "mp.metrics.distribution.histogram.min-value";
    static final String MP_TIMER_MAX_CONFIG = "mp.metrics.distribution.timer.max-value";
    static final String MP_TIMER_MIN_CONFIG = "mp.metrics.distribution.timer.min-value";
    private static MetricsConfigurationManager instance;
    private volatile Map<String, Collection<MetricPercentileConfiguration>> percentilesConfigMap = new HashMap<String, Collection<MetricPercentileConfiguration>>();
    private volatile Map<String, Collection<HistogramBucketConfiguration>> histogramBucketsConfigMap = new HashMap<String, Collection<HistogramBucketConfiguration>>();
    private volatile Map<String, Collection<TimerBucketConfiguration>> timerBucketsConfigMap = new HashMap<String, Collection<TimerBucketConfiguration>>();
    private volatile Map<String, Collection<DefaultBucketConfiguration>> defaultBucketConfigMap = new HashMap<String, Collection<DefaultBucketConfiguration>>();
    private volatile Map<String, Collection<HistogramBucketMaxConfiguration>> defaultHistogramBucketMaxConfig = new HashMap<String, Collection<HistogramBucketMaxConfiguration>>();
    private volatile Map<String, Collection<HistogramBucketMinConfiguration>> defaultHistogramBucketMinConfig = new HashMap<String, Collection<HistogramBucketMinConfiguration>>();
    private volatile Map<String, Collection<TimerBucketMaxConfiguration>> defaultTimerBucketMaxConfig = new HashMap<String, Collection<TimerBucketMaxConfiguration>>();
    private volatile Map<String, Collection<TimerBucketMinConfiguration>> defaultTimerBucketMinConfig = new HashMap<String, Collection<TimerBucketMinConfiguration>>();
    static final long serialVersionUID = -3656142232618906783L;

    private MetricsConfigurationManager() {
    }

    public static synchronized MetricsConfigurationManager getInstance() {
        if (instance == null) {
            instance = new MetricsConfigurationManager();
        }
        return instance;
    }

    public synchronized MetricPercentileConfiguration getPercentilesConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.percentilesConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_PERCENTILES_PROP, String.class);
            return input.isPresent() ? MetricPercentileConfiguration.parseMetricPercentiles((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            MetricPercentileConfiguration retVal = (MetricPercentileConfiguration)MetricPercentileConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_PERCENTILES_PROP, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized HistogramBucketConfiguration getHistogramBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.histogramBucketsConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_BUCKET_PROP, String.class);
            return input.isPresent() ? HistogramBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketConfiguration retVal = (HistogramBucketConfiguration)HistogramBucketConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_HISTOGRAM_BUCKET_PROP, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized TimerBucketConfiguration getTimerBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.timerBucketsConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_BUCKET_PROP, String.class);
            return input.isPresent() ? TimerBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketConfiguration retVal = (TimerBucketConfiguration)TimerBucketConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_TIMER_BUCKET_PROP, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized DefaultBucketConfiguration getDefaultBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultBucketConfigMap.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_DEFAULT_BUCKET_PROP, String.class);
            return input.isPresent() ? DefaultBucketConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            DefaultBucketConfiguration retVal = (DefaultBucketConfiguration)DefaultBucketConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_DEFAULT_BUCKET_PROP, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized HistogramBucketMaxConfiguration getDefaultHistogramMaxBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultHistogramBucketMaxConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_MAX_CONFIG, String.class);
            return input.isPresent() ? HistogramBucketMaxConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketMaxConfiguration retVal = (HistogramBucketMaxConfiguration)HistogramBucketMaxConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_HISTOGRAM_MAX_CONFIG, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized HistogramBucketMinConfiguration getDefaultHistogramMinBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultHistogramBucketMinConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_HISTOGRAM_MIN_CONFIG, String.class);
            return input.isPresent() ? HistogramBucketMinConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            HistogramBucketMinConfiguration retVal = (HistogramBucketMinConfiguration)HistogramBucketMinConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_HISTOGRAM_MIN_CONFIG, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized TimerBucketMaxConfiguration getDefaultTimerMaxBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultTimerBucketMaxConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_MAX_CONFIG, String.class);
            return input.isPresent() ? TimerBucketMaxConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketMaxConfiguration retVal = (TimerBucketMaxConfiguration)TimerBucketMaxConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_TIMER_MAX_CONFIG, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    public synchronized TimerBucketMinConfiguration getDefaultTimerMinBucketConfiguration(String metricName) {
        String appName = this.getApplicationName();
        Collection computedValues = this.defaultTimerBucketMinConfig.computeIfAbsent(appName, f -> {
            Optional input = ConfigProvider.getConfig().getOptionalValue(MP_TIMER_MIN_CONFIG, String.class);
            return input.isPresent() ? TimerBucketMinConfiguration.parse((String)input.get()) : null;
        });
        if (computedValues != null && computedValues.size() != 0) {
            TimerBucketMinConfiguration retVal = (TimerBucketMinConfiguration)TimerBucketMinConfiguration.matches(computedValues, metricName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning \"{0}\" configuration for metric:\"{1}\" with values: {2} ", (Object[])new Object[]{MP_TIMER_MIN_CONFIG, metricName, retVal});
            }
            return retVal;
        }
        return null;
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    public synchronized void removeConfiguration(String appName) {
        if (appName == null || appName.isEmpty()) {
            return;
        }
        this.removeApplicationFromMap(appName, this.percentilesConfigMap);
        this.removeApplicationFromMap(appName, this.histogramBucketsConfigMap);
        this.removeApplicationFromMap(appName, this.timerBucketsConfigMap);
        this.removeApplicationFromMap(appName, this.defaultBucketConfigMap);
        this.removeApplicationFromMap(appName, this.defaultHistogramBucketMaxConfig);
        this.removeApplicationFromMap(appName, this.defaultHistogramBucketMinConfig);
        this.removeApplicationFromMap(appName, this.defaultTimerBucketMaxConfig);
        this.removeApplicationFromMap(appName, this.defaultTimerBucketMinConfig);
    }

    private <T extends PropertyConfiguration> void removeApplicationFromMap(String appName, Map<String, Collection<T>> map) {
        if (map != null && !map.isEmpty()) {
            map.remove(appName);
        }
    }
}

