/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.cookies;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.cookies.CookieUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SameSiteCookieUtils {
    private static final TraceComponent tc = Tr.register(CookieUtils.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int UNSUPPORTED_IOS_VERSION = 12;
    private static final int UNSUPPORTED_MACOS_MAJOR_VERSION = 10;
    private static final int UNSUPPORTED_MACOS_MINOR_VERSION = 14;
    private static final Pattern IosVersion = Pattern.compile(".*\\(ip.+; cpu .*os (\\d+)[_\\d]*.*\\) applewebkit\\/.*");
    private static final Pattern MacOsVersion = Pattern.compile(".*\\(macintosh;.*mac os x (\\d+)_(\\d+)[_\\d]*.*\\) applewebkit\\/.*");
    private static final Pattern Safari = Pattern.compile(".*version\\/.* safari\\/.*");
    private static final Pattern MacEmbeddedBrowser = Pattern.compile("^mozilla\\/[\\.\\d]+ \\(macintosh;.*mac os x [_\\d]+\\) applewebkit\\/[\\.\\d]+ \\(khtml, like gecko\\)$");
    private static final Pattern ucBrowser = Pattern.compile(".*ucbrowser/.*");
    private static final Pattern ucBrowserVersion = Pattern.compile(".*ucbrowser/(\\d+)\\.(\\d+)\\.(\\d+)[\\.\\d]*.*");
    private static final int UC_MAJOR_VERSION = 12;
    private static final int UC_MINOR_VERSION = 13;
    private static final int UC_BUILD_VERSION = 2;
    private static final Pattern chromiumBased = Pattern.compile(".*chrom(e|ium).*");
    private static final Pattern chromiumVersion = Pattern.compile(".*chrom[^\\/]+\\/(\\d+)[\\.\\d]*.*");
    private static final int CHROMIUM_MIN_MAJOR_VERSION = 51;
    private static final int CHROMIUM_MAX_MAJOR_VERSION = 66;

    private SameSiteCookieUtils() {
    }

    public static boolean isSameSiteNoneIncompatible(String userAgent) {
        String normalizedUserAgent = userAgent.toLowerCase().trim();
        return SameSiteCookieUtils.hasWebKitSameSiteBug(normalizedUserAgent) || SameSiteCookieUtils.dropsUnrecognizedSameSiteAttribute(normalizedUserAgent);
    }

    private static boolean hasWebKitSameSiteBug(String userAgent) {
        return SameSiteCookieUtils.isIosVersion(12, userAgent) || SameSiteCookieUtils.isMacOSVersion(10, 14, userAgent) && (SameSiteCookieUtils.isSafari(userAgent) || SameSiteCookieUtils.isMacEmbeddedBrowser(userAgent));
    }

    private static boolean isIosVersion(int major, String userAgent) {
        boolean isSameVersion;
        block3: {
            isSameVersion = false;
            try {
                Matcher m = IosVersion.matcher(userAgent);
                if (m.matches()) {
                    int version = Integer.parseInt(m.group(1));
                    isSameVersion = version == major;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(SameSiteCookieUtils.class.getName() + ".isIosVersion"), (String)"1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing IOS User-Agent; " + userAgent), (Object[])new Object[0]);
            }
        }
        return isSameVersion;
    }

    private static boolean isMacOSVersion(int major, int minor, String userAgent) {
        boolean isSameVersion;
        block3: {
            isSameVersion = false;
            try {
                Matcher m = MacOsVersion.matcher(userAgent);
                if (m.matches()) {
                    int majorVersion = Integer.parseInt(m.group(1));
                    int minorVersion = Integer.parseInt(m.group(2));
                    isSameVersion = majorVersion == major && minorVersion == minor;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(SameSiteCookieUtils.class.getName() + ".isMacOSVersion"), (String)"1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing IOS User-Agent; " + userAgent), (Object[])new Object[0]);
            }
        }
        return isSameVersion;
    }

    private static boolean isSafari(String userAgent) {
        return Safari.matcher(userAgent).matches() && !SameSiteCookieUtils.isChromiumBased(userAgent);
    }

    private static boolean isMacEmbeddedBrowser(String userAgent) {
        return MacEmbeddedBrowser.matcher(userAgent).matches();
    }

    private static boolean dropsUnrecognizedSameSiteAttribute(String userAgent) {
        boolean isUnsupportedUserAgent = false;
        if (SameSiteCookieUtils.isUcBrowser(userAgent)) {
            isUnsupportedUserAgent = !SameSiteCookieUtils.isUcBrowserSameSiteCompatible(userAgent);
        } else if (SameSiteCookieUtils.isChromiumBased(userAgent)) {
            isUnsupportedUserAgent = !SameSiteCookieUtils.isChromiumVersionSameSiteCompatible(userAgent);
        }
        return isUnsupportedUserAgent;
    }

    private static boolean isUcBrowser(String userAgent) {
        return ucBrowser.matcher(userAgent).matches();
    }

    private static boolean isUcBrowserSameSiteCompatible(String userAgent) {
        boolean supportsSameSite = false;
        try {
            Matcher m = ucBrowserVersion.matcher(userAgent);
            if (m.matches()) {
                int majorVersion = Integer.parseInt(m.group(1));
                int minorVersion = Integer.parseInt(m.group(2));
                int buildVersion = Integer.parseInt(m.group(3));
                supportsSameSite = majorVersion != 12 ? majorVersion > 12 : (minorVersion != 13 ? minorVersion > 13 : buildVersion >= 2);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(SameSiteCookieUtils.class.getName() + ".isUcBrowserSameSiteCompatible"), (String)"1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing UC based User-Agent; " + userAgent), (Object[])new Object[0]);
            }
            supportsSameSite = true;
        }
        return supportsSameSite;
    }

    private static boolean isChromiumBased(String userAgent) {
        return chromiumBased.matcher(userAgent).matches();
    }

    private static boolean isChromiumVersionSameSiteCompatible(String userAgent) {
        boolean supportsSameSite;
        block3: {
            supportsSameSite = true;
            try {
                Matcher m = chromiumVersion.matcher(userAgent);
                if (m.matches()) {
                    int majorVersion = Integer.parseInt(m.group(1));
                    supportsSameSite = majorVersion < 51 || majorVersion > 66;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(SameSiteCookieUtils.class.getName() + ".isChromiumVersionSameSiteCompatible"), (String)"1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing Chromium based User-Agent; " + userAgent), (Object[])new Object[0]);
            }
        }
        return supportsSameSite;
    }
}

