/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.accesslists.filterlist.FilterList;
import io.openliberty.accesslists.filterlist.FilterListFastStr;
import io.openliberty.accesslists.filterlist.FilterListSlowStr;
import io.openliberty.accesslists.filterlist.FilterListStr;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TrustedHeaderOriginLists {
    private static final TraceComponent tc = Tr.register(TrustedHeaderOriginLists.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.TrustedHeaderOriginLists");
    private FilterList trustedAddresses = null;
    private FilterList sensitiveTrustedAddresses = null;
    private FilterListStr trustedHosts = null;
    private FilterListStr sensitiveTrustedHosts = null;
    private boolean trustAllOrigins = false;
    private boolean trustAllSensitiveOrigins = false;
    private boolean disableAllOrigins = false;
    private boolean disableAllSensitiveOrigins = false;
    static final long serialVersionUID = 2541511345885365744L;

    protected TrustedHeaderOriginLists() {
    }

    protected void parseTrustedPrivateHeaderOrigin(String[] trustedPrivateHeaderHosts, String[] trustedSensitiveHeaderHosts) {
        ArrayList<String> addrs = new ArrayList<String>();
        if (trustedPrivateHeaderHosts != null && trustedPrivateHeaderHosts.length > 0) {
            for (String host : trustedPrivateHeaderHosts) {
                if ("none".equalsIgnoreCase(host)) {
                    addrs.clear();
                    this.disableAllOrigins = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: none", (Object[])new Object[0]);
                    }
                    break;
                }
                if ("*".equals(host)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: *", (Object[])new Object[0]);
                    }
                    this.trustAllOrigins = true;
                    addrs.clear();
                    break;
                }
                addrs.add(host);
            }
        } else {
            this.trustAllOrigins = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: *", (Object[])new Object[0]);
            }
        }
        if (!addrs.isEmpty()) {
            String[] restrictPrivateHeaderOrigin = new HashSet();
            for (String s : addrs) {
                if (s == null || s.isEmpty()) continue;
                restrictPrivateHeaderOrigin.add(s.toLowerCase());
            }
            this.parseAndSetOrigins((HashSet<String>)restrictPrivateHeaderOrigin, false);
        }
        addrs.clear();
        if (trustedSensitiveHeaderHosts != null && trustedSensitiveHeaderHosts.length > 0) {
            for (String host : trustedSensitiveHeaderHosts) {
                if ("none".equalsIgnoreCase(host)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: none", (Object[])new Object[0]);
                    }
                    this.disableAllSensitiveOrigins = true;
                    return;
                }
                if ("*".equals(host)) {
                    addrs.clear();
                    this.trustAllSensitiveOrigins = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: *", (Object[])new Object[0]);
                    }
                    break;
                }
                addrs.add(host);
            }
        } else {
            this.disableAllSensitiveOrigins = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: none", (Object[])new Object[0]);
            }
            return;
        }
        if (!addrs.isEmpty()) {
            HashSet<String> restrictSensitiveHeaderOrigin = new HashSet<String>();
            for (String s : addrs) {
                if (s == null || s.isEmpty()) continue;
                restrictSensitiveHeaderOrigin.add(s.toLowerCase());
            }
            this.parseAndSetOrigins(restrictSensitiveHeaderOrigin, true);
        }
    }

    @ManualTrace
    private void parseAndSetOrigins(HashSet<String> origins, boolean sensitive) {
        ArrayList<String> addrs = new ArrayList<String>();
        ArrayList<String> hosts = new ArrayList<String>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseAndSetOrigins sensitive=" + sensitive), (Object[])new Object[0]);
        }
        if (origins != null && !origins.isEmpty()) {
            for (String origin : origins) {
                boolean result = this.isStringIPAddressesValid(new String[]{origin});
                if (result) {
                    addrs.add(origin);
                    continue;
                }
                result = this.isStringHostnameValid(origin);
                if (!result) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) continue;
                    if (!sensitive) {
                        Tr.warning((TraceComponent)tc, (String)"trusted.header.origin.invalid.value", (Object[])new Object[]{origin});
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"trusted.sensitive.header.origin.invalid.value", (Object[])new Object[]{origin});
                    continue;
                }
                hosts.add(origin);
            }
        }
        if (!sensitive) {
            this.trustedAddresses = new FilterList();
            if (addrs != null && !addrs.isEmpty()) {
                this.trustedAddresses.buildData(addrs.toArray(new String[0]), false);
                this.trustedAddresses.setActive(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trusted private headers host addresses: " + Arrays.toString(addrs.toArray())), (Object[])new Object[0]);
                }
            }
            this.trustedHosts = new FilterListFastStr();
            if (hosts != null && !hosts.isEmpty()) {
                if (!this.trustedHosts.buildData(hosts.toArray(new String[0]))) {
                    this.trustedHosts = new FilterListSlowStr();
                    this.trustedHosts.buildData(hosts.toArray(new String[0]));
                }
                this.trustedHosts.setActive(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trusted private headers host names: " + Arrays.toString(addrs.toArray())), (Object[])new Object[0]);
                }
            }
        } else {
            this.sensitiveTrustedAddresses = new FilterList();
            if (addrs != null && !addrs.isEmpty()) {
                this.sensitiveTrustedAddresses.buildData(addrs.toArray(new String[0]), false);
                this.sensitiveTrustedAddresses.setActive(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trusted sensitive private headers host addresses: " + Arrays.toString(addrs.toArray())), (Object[])new Object[0]);
                }
            }
            this.sensitiveTrustedHosts = new FilterListFastStr();
            if (hosts != null && !hosts.isEmpty()) {
                if (!this.sensitiveTrustedHosts.buildData(hosts.toArray(new String[0]))) {
                    this.sensitiveTrustedHosts = new FilterListSlowStr();
                    this.sensitiveTrustedHosts.buildData(hosts.toArray(new String[0]));
                }
                this.sensitiveTrustedHosts.setActive(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("trusted sensitive private headers host names: " + Arrays.toString(hosts.toArray())), (Object[])new Object[0]);
                }
            }
        }
    }

    @ManualTrace
    protected boolean isTrusted(InetAddress remoteAddr, boolean isSensitive) {
        boolean isTrusted;
        boolean bl = isTrusted = !isSensitive && this.trustAllOrigins || this.trustAllSensitiveOrigins;
        if (!isTrusted) {
            if (remoteAddr != null) {
                String hostname;
                if (this.sensitiveTrustedAddresses != null && this.sensitiveTrustedAddresses.getActive()) {
                    isTrusted = remoteAddr instanceof Inet6Address ? this.sensitiveTrustedAddresses.findInList6(remoteAddr.getAddress()) : this.sensitiveTrustedAddresses.findInList(remoteAddr.getAddress());
                }
                if (!isSensitive && !this.disableAllOrigins) {
                    if (!isTrusted && this.trustedAddresses != null && this.trustedAddresses.getActive()) {
                        isTrusted = remoteAddr instanceof Inet6Address ? this.trustedAddresses.findInList6(remoteAddr.getAddress()) : this.trustedAddresses.findInList(remoteAddr.getAddress());
                    }
                    String hostname2 = null;
                    if (!isTrusted && this.sensitiveTrustedHosts != null && this.sensitiveTrustedHosts.getActive() && (hostname2 = this.getHostName(remoteAddr)) != null) {
                        hostname2 = hostname2.toLowerCase();
                        isTrusted = this.sensitiveTrustedHosts.findInList(hostname2);
                    }
                    if (!isTrusted && this.trustedHosts != null && this.trustedHosts.getActive() && (hostname2 != null || (hostname2 = this.getHostName(remoteAddr)) != null)) {
                        hostname2 = hostname2.toLowerCase();
                        isTrusted = this.trustedHosts.findInList(hostname2);
                    }
                } else if (!this.disableAllSensitiveOrigins && !isTrusted && this.sensitiveTrustedHosts != null && this.sensitiveTrustedHosts.getActive() && (hostname = this.getHostName(remoteAddr)) != null) {
                    hostname = hostname.toLowerCase();
                    isTrusted = this.sensitiveTrustedHosts.findInList(hostname);
                }
            } else if (!isSensitive) {
                boolean bl2 = isTrusted = !this.disableAllOrigins;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isTrusted returning " + isTrusted + " for remote address = " + remoteAddr + " sensitive = " + isSensitive));
        }
        return isTrusted;
    }

    private boolean isStringIPAddressesValid(String[] value) {
        FilterList f = new FilterList();
        return f.buildData(value, true);
    }

    private boolean isStringHostnameValid(String value) {
        if (value.startsWith("*")) {
            value = value.substring(1);
        }
        if (value.length() > 0) {
            for (int n = 0; n < value.length(); ++n) {
                char c = value.charAt(n);
                char cint = c;
                if (cint == '-' || cint == '.' || '/' < c && c < ':' || '@' < c && c < '[' || '`' < c && c < '{') continue;
                return false;
            }
        }
        return true;
    }

    private String getHostName(final InetAddress address) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 1808171888872115222L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return address.getHostName();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.TrustedHeaderOriginLists$1");
            }
        });
    }
}

