/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.clientconfig;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.UriBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JAXRSClientConfigHolder {
    private static final TraceComponent tc = Tr.register(JAXRSClientConfigHolder.class, null, null);
    private static volatile Map<String, Map<String, String>> configInfo = new TreeMap<String, Map<String, String>>();
    private static volatile Map<String, String> uriMap = new HashMap<String, String>();
    private static volatile Map<String, Map<String, String>> resolvedConfigInfo = new LinkedHashMap<String, Map<String, String>>(500, 0.75f, true){
        static final long serialVersionUID = -4760009481831520795L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Map<String, String>> eldest) {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.clientconfig.JAXRSClientConfigHolder$1", 1.class, null, null);
        }
    };
    private static boolean wildcardsPresentInConfigInfo = false;
    static final long serialVersionUID = 7206009420669359688L;

    public static synchronized void addConfig(String id, String uri, Map<String, String> params) {
        uriMap.put(id, uri);
        configInfo.put(uri, params);
        resolvedConfigInfo.clear();
        if (uri.endsWith("*")) {
            wildcardsPresentInConfigInfo = true;
        }
    }

    public static synchronized void removeConfig(String objectId) {
        String uri = uriMap.get(objectId);
        if (uri != null) {
            configInfo.remove(uri);
        }
        uriMap.remove(objectId);
        resolvedConfigInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getURIProps(UriBuilder uriBuilder) {
        boolean debug;
        boolean bl = debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        if (configInfo.isEmpty()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"getUriprops is empty, return null", (Object[])new Object[0]);
            }
            return null;
        }
        String uri = uriBuilder.build(new Object[0]).toString();
        Map<String, Map<String, String>> map = resolvedConfigInfo;
        synchronized (map) {
            Map<String, String> props = resolvedConfigInfo.get(uri);
            if (props != null) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops cache hit, uri: " + uri + "props: " + props), (Object[])new Object[0]);
                }
                return props.isEmpty() ? null : props;
            }
        }
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        Class<JAXRSClientConfigHolder> clazz = JAXRSClientConfigHolder.class;
        synchronized (JAXRSClientConfigHolder.class) {
            Map<String, String> props = configInfo.get(uri);
            if (props != null) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops exact match: " + uri), (Object[])new Object[0]);
                }
                mergedProps.putAll(props);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!wildcardsPresentInConfigInfo) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops no wildcards, cache and return what we've got: " + mergedProps), (Object[])new Object[0]);
                }
                clazz = JAXRSClientConfigHolder.class;
                synchronized (JAXRSClientConfigHolder.class) {
                    resolvedConfigInfo.put(uri, mergedProps);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return mergedProps.isEmpty() ? null : mergedProps;
                }
            }
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"begin wildcard search", (Object[])new Object[0]);
            }
            clazz = JAXRSClientConfigHolder.class;
            synchronized (JAXRSClientConfigHolder.class) {
                Iterator<String> it = configInfo.keySet().iterator();
                String trimmedKey = null;
                while (it.hasNext()) {
                    String key = it.next();
                    if (!key.endsWith("*") || !uri.startsWith(trimmedKey = key.substring(0, key.length() - 1))) continue;
                    if (debug) {
                        Tr.debug((TraceComponent)tc, (String)("getUriprops match = " + key + ", will merge these props: " + configInfo.get(key)), (Object[])new Object[0]);
                    }
                    mergedProps.putAll(configInfo.get(key));
                }
                resolvedConfigInfo.put(uri, mergedProps);
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops final result for uri: " + uri + "values: " + mergedProps), (Object[])new Object[0]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return mergedProps.isEmpty() ? null : mergedProps;
            }
        }
    }
}

