/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public abstract class LooseApplication {
    protected final String buildDirectory;
    protected final LooseConfigData config;
    private static final String MANIFEST_TARGET = "/META-INF/MANIFEST.MF";

    public LooseApplication(String buildDirectory, LooseConfigData config) {
        this.buildDirectory = buildDirectory;
        this.config = config;
    }

    public LooseConfigData getConfig() {
        return this.config;
    }

    public Element getDocumentRoot() {
        return this.config.getDocumentRoot();
    }

    public Element addArchive(Element parent, String target) {
        return this.config.addArchive(parent, target);
    }

    public void addOutputDir(Element parent, File outputDirectory, String target) throws DOMException, IOException {
        this.config.addDir(parent, outputDirectory, target);
    }

    public void addMetaInfFiles(Element parent, File outputDirectory) throws Exception {
        boolean existsAndHasAdditionalFiles;
        File metaInfFolder = new File(outputDirectory + "/META-INF");
        boolean bl = existsAndHasAdditionalFiles = metaInfFolder.exists() && metaInfFolder.list().length > 0;
        if (existsAndHasAdditionalFiles) {
            this.addFiles(parent, metaInfFolder, "/META-INF");
        }
    }

    private void addFiles(Element parent, File file, String targetPrefix) throws DOMException, IOException {
        for (File subFile : file.listFiles()) {
            if (subFile.isDirectory()) {
                this.addFiles(parent, subFile, targetPrefix + "/" + subFile.getName());
                continue;
            }
            this.config.addFile(parent, subFile, targetPrefix + "/" + subFile.getName());
        }
    }

    public void addManifestFileWithParent(Element parent, File manifestFile) throws Exception {
        this.config.addFile(parent, this.getManifestOrDefault(manifestFile, this.buildDirectory), MANIFEST_TARGET);
    }

    public void addManifestFileWithParent(Element parent, File manifestFile, String destDir) throws Exception {
        this.config.addFile(parent, this.getManifestOrDefault(manifestFile, destDir), MANIFEST_TARGET);
    }

    public void addManifestFile(File manifestFile) throws Exception {
        this.config.addFile(this.getManifestOrDefault(manifestFile, this.buildDirectory), MANIFEST_TARGET);
    }

    public void addManifestFile(File manifestFile, String destDir) throws Exception {
        this.config.addFile(this.getManifestOrDefault(manifestFile, destDir), MANIFEST_TARGET);
    }

    private File getManifestOrDefault(File manifestFile, String destDir) throws IOException, PluginExecutionException {
        File defaultManifestFileLocation = new File(destDir + "/tmp" + MANIFEST_TARGET);
        defaultManifestFileLocation.getParentFile().mkdirs();
        if (manifestFile != null && manifestFile.exists() && manifestFile.isFile()) {
            FileUtils.copyFile((File)manifestFile, (File)defaultManifestFileLocation);
        } else {
            FileOutputStream fos = new FileOutputStream(defaultManifestFileLocation);
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.write(fos);
            fos.close();
        }
        return defaultManifestFileLocation;
    }
}

