/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.AbstractContainerSupportUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ServerFeatureUtil
extends AbstractContainerSupportUtil {
    public static final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    public static final String REPOSITORY_RESOLVER_ARTIFACT_ID = "repository-resolver";
    public static final String INSTALL_MAP_ARTIFACT_ID = "install-map";
    private static final int COPY_FILE_TIMEOUT_MILLIS = 300000;
    public static final String WLP_INSTALL_DIR = "wlp.install.dir";
    public static final String WLP_USER_DIR = "wlp.user.dir";
    public static final String USR_EXTENSION_DIR = "usr.extension.dir";
    public static final String SHARED_APP_DIR = "shared.app.dir";
    public static final String SHARED_CONFIG_DIR = "shared.config.dir";
    public static final String SHARED_RESOURCES_DIR = "shared.resource.dir";
    public static final String SHARED_STACKGROUP_DIR = "shared.stackgroup.dir";
    public static final String SERVER_CONFIG_DIR = "server.config.dir";
    private Map<String, File> libertyDirectoryPropertyToFile = null;

    @Override
    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public Set<String> getServerFeatures(File serverDirectory, Map<String, File> libertyDirPropFiles) {
        if (libertyDirPropFiles != null) {
            this.libertyDirectoryPropertyToFile = new HashMap<String, File>(libertyDirPropFiles);
        } else {
            this.warn("The properties for directories are null and could lead to server include files not being processed for server features.");
            this.libertyDirectoryPropertyToFile = new HashMap<String, File>();
        }
        Properties bootstrapProperties = this.getBootstrapProperties(new File(serverDirectory, "bootstrap.properties"));
        Set<String> result = this.getConfigDropinsFeatures(null, serverDirectory, bootstrapProperties, "defaults");
        result = this.getServerXmlFeatures(result, new File(serverDirectory, "server.xml"), bootstrapProperties, null);
        return this.getConfigDropinsFeatures(result, serverDirectory, bootstrapProperties, "overrides");
    }

    private void initializeLibertyDirectoryPropertyFiles(File serverDirectory) {
        this.libertyDirectoryPropertyToFile = new HashMap<String, File>();
        if (serverDirectory.exists()) {
            try {
                this.libertyDirectoryPropertyToFile.put(SERVER_CONFIG_DIR, serverDirectory.getCanonicalFile());
                File wlpUserDir = serverDirectory.getParentFile().getParentFile();
                this.libertyDirectoryPropertyToFile.put(WLP_USER_DIR, wlpUserDir.getCanonicalFile());
                File wlpInstallDir = wlpUserDir.getParentFile();
                this.libertyDirectoryPropertyToFile.put(WLP_INSTALL_DIR, wlpInstallDir.getCanonicalFile());
                File userExtDir = new File(wlpUserDir, "extension");
                this.libertyDirectoryPropertyToFile.put(USR_EXTENSION_DIR, userExtDir.getCanonicalFile());
                File userSharedDir = new File(wlpUserDir, "shared");
                File userSharedAppDir = new File(userSharedDir, "app");
                File userSharedConfigDir = new File(userSharedDir, "config");
                File userSharedResourcesDir = new File(userSharedDir, "resources");
                File userSharedStackGroupsDir = new File(userSharedDir, "stackGroups");
                this.libertyDirectoryPropertyToFile.put(SHARED_APP_DIR, userSharedAppDir.getCanonicalFile());
                this.libertyDirectoryPropertyToFile.put(SHARED_CONFIG_DIR, userSharedConfigDir.getCanonicalFile());
                this.libertyDirectoryPropertyToFile.put(SHARED_RESOURCES_DIR, userSharedResourcesDir.getCanonicalFile());
                this.libertyDirectoryPropertyToFile.put(SHARED_STACKGROUP_DIR, userSharedStackGroupsDir.getCanonicalFile());
            }
            catch (Exception e) {
                this.warn("The properties for directories could not be initialized because an error occurred when accessing them.");
                this.debug("Exception received: " + e.getMessage(), e);
            }
        } else {
            this.warn("The " + serverDirectory + " directory cannot be accessed. Skipping its server features.");
        }
    }

    private Set<String> getConfigDropinsFeatures(Set<String> origResult, File serverDirectory, Properties bootstrapProperties, String folderName) {
        File configDropinsFolder;
        Set<String> result = origResult;
        try {
            configDropinsFolder = new File(new File(serverDirectory, "configDropins"), folderName).getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The " + serverDirectory + "/configDropins/" + folderName + " directory cannot be accessed. Skipping its server features.");
            this.debug("Exception received: " + e.getMessage(), e);
            return result;
        }
        File[] configDropinsXmls = configDropinsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (configDropinsXmls == null || configDropinsXmls.length == 0) {
            return result;
        }
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File left, File right) {
                return left.getAbsolutePath().toLowerCase().compareTo(right.getAbsolutePath().toLowerCase());
            }
        };
        Collections.sort(Arrays.asList(configDropinsXmls), comparator);
        for (File xml : configDropinsXmls) {
            Set<String> features = this.getServerXmlFeatures(result, xml, bootstrapProperties, null);
            if (features == null) continue;
            result = features;
        }
        return result;
    }

    private Set<String> getServerXmlFeatures(Set<String> origResult, File serverFile, Properties bootstrapProperties, List<File> parsedXmls) {
        File canonicalServerFile;
        Set<String> result = origResult;
        ArrayList<File> updatedParsedXmls = parsedXmls != null ? parsedXmls : new ArrayList<File>();
        try {
            canonicalServerFile = serverFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " cannot be accessed. Skipping its features.");
            this.debug("Exception received: " + e.getMessage(), e);
            return result;
        }
        this.info("Parsing the server file " + canonicalServerFile + " for features and includes.");
        updatedParsedXmls.add(canonicalServerFile);
        if (!canonicalServerFile.exists()) {
            this.warn("The server file " + canonicalServerFile + " does not exist. Skipping its features.");
        } else if (canonicalServerFile.length() == 0L) {
            this.debug("The server file " + canonicalServerFile + " is empty.");
        } else {
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                db.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException e) throws SAXException {
                        ServerFeatureUtil.this.debug("Exception received: " + e.getMessage(), e);
                    }

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    @Override
                    public void error(SAXParseException e) throws SAXException {
                        throw e;
                    }
                });
                Document doc = db.parse(canonicalServerFile);
                Element root = doc.getDocumentElement();
                NodeList nodes = root.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (!(nodes.item(i) instanceof Element)) continue;
                    Element child = (Element)nodes.item(i);
                    if ("featureManager".equals(child.getNodeName())) {
                        if (result == null) {
                            result = new HashSet<String>();
                        }
                        result.addAll(this.parseFeatureManagerNode(child));
                        continue;
                    }
                    if (!"include".equals(child.getNodeName())) continue;
                    result = this.parseIncludeNode(result, canonicalServerFile, bootstrapProperties, child, updatedParsedXmls);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.warn("The server file " + canonicalServerFile + " cannot be parsed. Skipping its features.");
                this.debug("Exception received: " + e.getMessage(), e);
                return result;
            }
        }
        return result;
    }

    private Set<String> parseFeatureManagerNode(Element node) {
        HashSet<String> result = new HashSet<String>();
        NodeList features = node.getElementsByTagName("feature");
        if (features != null) {
            for (int j = 0; j < features.getLength(); ++j) {
                String content = features.item(j).getTextContent();
                if (content == null) continue;
                if ((content = content.trim()).contains(":")) {
                    String[] contentsplit = content.split(":");
                    if (contentsplit.length > 2) {
                        this.debug("The format of feature " + content + " in the server.xml is not valid and its installation will be skipped.");
                        continue;
                    }
                    result.add(contentsplit[0] + ":" + contentsplit[1].trim().toLowerCase());
                    continue;
                }
                result.add(content.trim().toLowerCase());
            }
        }
        return result;
    }

    private Set<String> parseIncludeNode(Set<String> origResult, File serverFile, Properties bootstrapProperties, Element node, List<File> updatedParsedXmls) {
        Set<String> result = origResult;
        String includeFileName = this.evaluateExpression(bootstrapProperties, node.getAttribute("location"));
        if (includeFileName == null || includeFileName.trim().isEmpty()) {
            this.warn("Unable to parse include file " + node.getAttribute("location") + ". Skipping the included features.");
            return result;
        }
        File includeFile = null;
        if (ServerFeatureUtil.isURL(includeFileName)) {
            try {
                File tempFile = File.createTempFile("serverFromURL", ".xml");
                FileUtils.copyURLToFile((URL)new URL(includeFileName), (File)tempFile, (int)300000, (int)300000);
                includeFile = tempFile;
            }
            catch (IOException e) {
                this.warn("The server file " + serverFile + " includes a URL " + includeFileName + " that cannot be accessed. Skipping the included features.");
                this.debug("Exception received: " + e.getMessage(), e);
                return result;
            }
        } else {
            includeFile = new File(includeFileName);
        }
        try {
            includeFile = !includeFile.isAbsolute() ? new File(serverFile.getParentFile().getAbsolutePath(), includeFileName).getCanonicalFile() : includeFile.getCanonicalFile();
        }
        catch (IOException e) {
            this.warn("The server file " + serverFile + " includes a file " + includeFileName + " that cannot be accessed. Skipping the included features.");
            this.debug("Exception received: " + e.getMessage(), e);
            return result;
        }
        if (!updatedParsedXmls.contains(includeFile)) {
            String onConflict = node.getAttribute("onConflict");
            Set<String> features = this.getServerXmlFeatures(null, includeFile, bootstrapProperties, updatedParsedXmls);
            if (features != null && !features.isEmpty()) {
                this.info("Features were included for file " + includeFileName);
            }
            result = this.handleOnConflict(result, onConflict, features);
        }
        return result;
    }

    private static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    private Set<String> handleOnConflict(Set<String> origResult, String onConflict, Set<String> features) {
        Set<String> result = origResult;
        if ("replace".equalsIgnoreCase(onConflict)) {
            if (features != null && !features.isEmpty()) {
                result = features;
            }
        } else if ("ignore".equalsIgnoreCase(onConflict)) {
            if (result == null) {
                result = features;
            }
        } else if (features != null) {
            if (result == null) {
                result = features;
            } else {
                result.addAll(features);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBootstrapProperties(File bootstrapProperties) {
        Properties prop = new Properties();
        if (bootstrapProperties != null && bootstrapProperties.exists()) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(bootstrapProperties);
                prop.load(stream);
            }
            catch (IOException e) {
                this.warn("The bootstrap.properties file " + bootstrapProperties.getAbsolutePath() + " could not be loaded. Skipping the bootstrap.properties file.");
                this.debug("Exception received: " + e.getMessage(), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        this.debug("Could not close input stream for file " + bootstrapProperties.getAbsolutePath(), e);
                    }
                }
            }
        }
        return prop;
    }

    private String evaluateExpression(Properties properties, String expression) {
        String value = expression;
        if (expression != null) {
            Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher m = p.matcher(expression);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String variable = m.group(1);
                String propertyValue = properties.getProperty(variable, "${" + variable + "}");
                if ((propertyValue = this.removeEncapsulatingEnvVarSyntax(propertyValue, properties)) == null) {
                    return null;
                }
                m.appendReplacement(sb, propertyValue);
            }
            m.appendTail(sb);
            value = sb.toString();
        }
        value = value.replace("\\", "/");
        this.debug("Include location attribute " + expression + " evaluated and replaced with " + value);
        return value;
    }

    private String removeEncapsulatingEnvVarSyntax(String propertyValue, Properties properties) {
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = p.matcher(propertyValue);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String envDirectoryProperty = m.group(1);
            if (!this.libertyDirectoryPropertyToFile.containsKey(envDirectoryProperty)) {
                String bootStrapValue = properties.getProperty(envDirectoryProperty);
                if (bootStrapValue != null) {
                    bootStrapValue = bootStrapValue.replace("\\", "/");
                    m.appendReplacement(sb, this.removeEncapsulatingEnvVarSyntax(bootStrapValue, properties));
                    continue;
                }
                this.warn("The referenced property " + envDirectoryProperty + " is not a predefined Liberty directory property or a configured bootstrap property.");
                return null;
            }
            File envDirectory = this.libertyDirectoryPropertyToFile.get(envDirectoryProperty);
            String path = envDirectory.toString();
            path = path.replace("\\", "/");
            m.appendReplacement(sb, path);
        }
        m.appendTail(sb);
        String returnValue = sb.toString();
        if (sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"') {
            returnValue = sb.length() > 2 ? sb.substring(1, sb.length() - 1) : "";
        }
        returnValue = returnValue.replace("\\", "/");
        this.debug("Include location attribute property value " + propertyValue + " replaced with " + returnValue);
        return returnValue;
    }
}

