/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.plugins.config.XmlDocument;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ServerConfigXmlDocument
extends XmlDocument {
    public static String DEFAULT_INDENTATION = "  ";
    private Element featureManager = null;

    private ServerConfigXmlDocument() {
    }

    public static ServerConfigXmlDocument newInstance() throws ParserConfigurationException {
        ServerConfigXmlDocument configDocument = new ServerConfigXmlDocument();
        configDocument.createDocument("server");
        return configDocument;
    }

    public static ServerConfigXmlDocument newInstance(File f) throws ParserConfigurationException, SAXException, IOException {
        if (f == null || !f.exists()) {
            return null;
        }
        ServerConfigXmlDocument configDocument = new ServerConfigXmlDocument();
        configDocument.createDocument(f);
        configDocument.featureManager = configDocument.findFeatureManager();
        return configDocument;
    }

    public void createComment(String comment) {
        this.createComment(this.findServerElement(), comment);
    }

    public void createComment(Element elem, String comment) {
        Comment commentElement = this.doc.createComment(comment);
        this.appendBeforeBlanks(elem, commentElement);
    }

    private void appendBeforeBlanks(Element elem, Node childElement) {
        Node lastchild = elem.getLastChild();
        if (this.isWhitespace(lastchild)) {
            elem.insertBefore(childElement, lastchild);
        } else {
            elem.appendChild(childElement);
        }
    }

    public boolean createFMComment(String comment) {
        if (this.featureManager == null) {
            this.featureManager = this.findFeatureManager();
        }
        if (!this.hasFirstLevelComment(comment)) {
            Node insertionPoint = null;
            if (this.featureManager == null) {
                insertionPoint = this.findServerElement().getFirstChild();
            } else {
                insertionPoint = this.featureManager;
                if (this.isWhitespace(insertionPoint.getPreviousSibling())) {
                    insertionPoint = insertionPoint.getPreviousSibling();
                }
            }
            this.createFMComment(insertionPoint, comment);
            return true;
        }
        return false;
    }

    public void createFMComment(Node insertionPoint, String comment) {
        Comment commentElement = this.doc.createComment(comment);
        if (insertionPoint == null) {
            Text padding = this.doc.createTextNode(DEFAULT_INDENTATION);
            this.findServerElement().appendChild(padding);
            this.findServerElement().appendChild(commentElement);
        } else {
            this.findServerElement().insertBefore(commentElement, insertionPoint);
            if (this.isWhitespace(insertionPoint)) {
                Node padding = insertionPoint.cloneNode(true);
                this.findServerElement().insertBefore(padding, commentElement);
            }
        }
    }

    public boolean removeFMComment(String comment) {
        Node commentNode = this.findFirstLevelComment(comment);
        if (commentNode != null) {
            Node parent = commentNode.getParentNode();
            Node sibling = commentNode.getPreviousSibling();
            if (this.isWhitespace(sibling)) {
                parent.removeChild(sibling);
            }
            parent.removeChild(commentNode);
            return true;
        }
        return false;
    }

    public void createVariableWithValue(String varName, String varValue, boolean isDefaultValue) {
        this.createVariableWithValue(this.doc.getDocumentElement(), varName, varValue, isDefaultValue);
    }

    public void createVariableWithValue(Element elem, String varName, String varValue, boolean isDefaultValue) {
        if (varValue == null) {
            return;
        }
        Element child = this.doc.createElement("variable");
        child.setAttribute("name", varName);
        String valueAttr = isDefaultValue ? "defaultValue" : "value";
        child.setAttribute(valueAttr, varValue);
        elem.appendChild(child);
    }

    public void createFeature(String name) {
        this.createFeatureManager();
        Element child = this.doc.createElement("feature");
        Text text = this.doc.createTextNode(name);
        child.appendChild(text);
        this.featureManager.appendChild(child);
    }

    public Element createFeatureManager() {
        if (this.featureManager == null) {
            this.featureManager = this.doc.createElement("featureManager");
            this.doc.getDocumentElement().appendChild(this.featureManager);
        }
        return this.featureManager;
    }

    public Element findFeatureManager() {
        Element serverElement = this.findServerElement();
        if (serverElement == null) {
            return null;
        }
        Node fmNode = serverElement.getElementsByTagName("featureManager").item(0);
        if (fmNode instanceof Element) {
            return (Element)fmNode;
        }
        return null;
    }

    public boolean hasFirstLevelComment(String comment) {
        return this.findFirstLevelComment(comment) != null;
    }

    public Node findFirstLevelComment(String comment) {
        NodeList list = this.findServerElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 8 || !(item instanceof Comment) || !((Comment)item).getData().contains(comment)) continue;
            return item;
        }
        return null;
    }

    public Element findServerElement() {
        return this.doc.getDocumentElement();
    }
}

