/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.OSUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.common.plugins.util.VersionUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public abstract class InstallFeatureUtil
extends ServerFeatureUtil {
    public static final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    public static final String REPOSITORY_RESOLVER_ARTIFACT_ID = "repository-resolver";
    public static final String INSTALL_MAP_ARTIFACT_ID = "install-map";
    public static final String CONFLICT = "CWWKF0033E.*";
    public static final String INCOMPATIBLE_SINGLETON = "CWWKF1405E.*";
    public static final String MISSING_MULTIPLE_DEPENDENT = "CWWKF1385E.*";
    public static final String SAME_MODEL_CONFLICT = "CWWKF0043E.*";
    public static final String DIFF_MODEL_CONFLICT = "CWWKF0044E.*";
    public static final String SAME_INDIRECT_MODEL_CONFLICT = "CWWKF0047E.*";
    public static final String EE_CONFLICT = "CWWKF0043E.*|CWWKF0044E.*|CWWKF0047E.*";
    public static final String ANY_CONFLICT = "CWWKF0033E.*|CWWKF1385E.*|CWWKF1405E.*|CWWKF0043E.*|CWWKF0044E.*|CWWKF0047E.*";
    public static final Pattern conflictPattern = Pattern.compile("CWWKF0033E.*|CWWKF1385E.*|CWWKF1405E.*|CWWKF0043E.*|CWWKF0044E.*|CWWKF0047E.*");
    public static final String CONFLICT_MESSAGE = "A feature conflict error occurred while installing features: ";
    private final File installDirectory;
    private final File buildDirectory;
    private File installJarFile;
    private final List<ProductProperties> propertiesList;
    private final String to;
    private Set<File> downloadedJsons;
    private final List<String> additionalJsons;
    private final Set<String> pluginListedEsas;
    private Map<String, String> manuallyInstalledUsrFeatureMap;
    private static final String INSTALL_MAP_PREFIX = "com.ibm.ws.install.map";
    private static final String INSTALL_MAP_SUFFIX = ".jar";
    private static final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    private static final String CLOSED_LIBERTY_PRODUCT_ID = "com.ibm.websphere.appserver";
    private static final String FEATURES_BOM_ARTIFACT_ID = "features-bom";
    private static final String FEATURES_JSON_ARTIFACT_ID = "features";
    private static final String TO_USER = "usr";
    private static final String MIN_USER_FEATURE_VERSION = "21.0.0.11";
    private String openLibertyVersion;
    private static Boolean saveURLCacheStatus = null;
    private final String containerName;

    public InstallFeatureUtil(File installDirectory, File buildDirectory, String from, String to, Set<String> pluginListedEsas, List<ProductProperties> propertiesList, String openLibertyVersion, String containerName, List<String> additionalJsons) throws PluginScenarioException, PluginExecutionException {
        this.installDirectory = installDirectory;
        this.buildDirectory = buildDirectory;
        this.to = to;
        this.propertiesList = propertiesList;
        this.openLibertyVersion = openLibertyVersion;
        this.containerName = containerName;
        this.additionalJsons = additionalJsons;
        this.pluginListedEsas = pluginListedEsas;
        this.manuallyInstalledUsrFeatureMap = new HashMap<String, String>();
        if (containerName == null) {
            Set<File> groupIDJsons;
            this.installJarFile = this.loadInstallJarFile(installDirectory);
            if (this.installJarFile == null) {
                throw new PluginScenarioException("Install map jar not found.");
            }
            this.downloadedJsons = this.downloadProductJsons();
            if (additionalJsons != null && !additionalJsons.isEmpty() && openLibertyVersion != null && VersionUtility.compareArtifactVersion(openLibertyVersion, MIN_USER_FEATURE_VERSION, true) >= 0 && (groupIDJsons = this.getAdditionalJsons()) != null) {
                this.downloadedJsons.addAll(groupIDJsons);
            }
            if (this.downloadedJsons.isEmpty()) {
                throw new PluginScenarioException("Cannot find JSONs for to the installed runtime from the Maven repository.");
            }
            if (from != null) {
                this.debug("has from: " + from);
                throw new PluginScenarioException("Cannot install features from a Maven repository when using 'from' parameter.");
            }
        }
    }

    private void copyZipEntry(ZipFile zip, ZipEntry entry, File targetFile) throws IOException, FileNotFoundException {
        try (InputStream is = zip.getInputStream(entry);
             FileOutputStream fos = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
    }

    private Set<File> getAdditionalJsons() {
        HashSet<File> Jsons = new HashSet<File>();
        for (String mavenCoord : this.additionalJsons) {
            String[] coord = mavenCoord.split(":");
            String groupId = coord[0];
            String artifactId = coord[1];
            String version = coord[2];
            try {
                File additionalJson = this.downloadArtifact(groupId, artifactId, "json", version);
                Jsons.add(additionalJson);
            }
            catch (PluginExecutionException e) {
                this.warn("Unable to find the following additional features JSON in the connected repositories: " + mavenCoord + ". Please ignore this warning if this is not a user feature.");
                this.debug("Unable to find additional features JSON: ", e);
            }
        }
        return Jsons;
    }

    private File loadInstallJarFile(File installDirectory) {
        File installJarOverride;
        if (this.openLibertyVersion != null && (installJarOverride = this.downloadOverrideJar(OPEN_LIBERTY_GROUP_ID, INSTALL_MAP_ARTIFACT_ID)) != null && installJarOverride.exists()) {
            return installJarOverride;
        }
        return InstallFeatureUtil.getMapBasedInstallKernelJar(new File(installDirectory, "lib"));
    }

    @Override
    public abstract void debug(String var1);

    @Override
    public abstract void debug(String var1, Throwable var2);

    @Override
    public abstract void debug(Throwable var1);

    @Override
    public abstract void warn(String var1);

    @Override
    public abstract void info(String var1);

    @Override
    public abstract void error(String var1);

    @Override
    public abstract void error(String var1, Throwable var2);

    @Override
    public abstract boolean isDebugEnabled();

    public abstract File downloadArtifact(String var1, String var2, String var3, String var4) throws PluginExecutionException;

    public Set<String> combineToSet(Collection<String> ... collections) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> lowercaseSet = new HashSet<String>();
        for (Collection<String> collection : collections) {
            if (collection == null) continue;
            for (String value : collection) {
                if (lowercaseSet.contains(value.toLowerCase())) continue;
                lowercaseSet.add(value.toLowerCase());
                if (value.isEmpty() || value.trim().isEmpty()) {
                    this.warn("An empty feature was specified in a server configuration file. Ensure that the features are valid.");
                    continue;
                }
                result.add(value);
            }
        }
        return result;
    }

    private Set<File> downloadProductJsons() throws PluginExecutionException {
        HashSet<File> downloadedJsons = new HashSet<File>();
        for (ProductProperties properties : this.propertiesList) {
            File json = this.downloadJsons(properties.getId(), properties.getVersion());
            if (json == null) continue;
            downloadedJsons.add(json);
        }
        return downloadedJsons;
    }

    private File downloadJsons(String productId, String productVersion) {
        String jsonGroupId = productId + ".features";
        try {
            return this.downloadArtifact(jsonGroupId, FEATURES_JSON_ARTIFACT_ID, "json", productVersion);
        }
        catch (PluginExecutionException e) {
            this.debug("Cannot find json for productId " + productId + ", productVersion " + productVersion, e);
            return null;
        }
    }

    public static List<ProductProperties> loadProperties(File installDir) throws PluginExecutionException {
        ArrayList<ProductProperties> list = new ArrayList<ProductProperties>();
        File dir = new File(installDir, "lib/versions");
        File[] propertiesFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        if (propertiesFiles != null) {
            for (File propertiesFile : propertiesFiles) {
                Properties properties = new Properties();
                FileInputStream input = null;
                try {
                    input = new FileInputStream(propertiesFile);
                    properties.load(input);
                    String productId = properties.getProperty("com.ibm.websphere.productId");
                    String productVersion = properties.getProperty("com.ibm.websphere.productVersion");
                    if (productId == null) {
                        throw new PluginExecutionException("Cannot find the \"com.ibm.websphere.productId\" property in the file " + propertiesFile.getAbsolutePath() + ". Ensure the file is valid properties file for the Liberty product or extension.");
                    }
                    if (productVersion == null) {
                        throw new PluginExecutionException("Cannot find the \"com.ibm.websphere.productVersion\" property in the file " + propertiesFile.getAbsolutePath() + ". Ensure the file is valid properties file for the Liberty product or extension.");
                    }
                    list.add(new ProductProperties(productId, productVersion));
                }
                catch (IOException e) {
                    throw new PluginExecutionException("Cannot read the product properties file " + propertiesFile.getAbsolutePath(), e);
                }
                finally {
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (list.isEmpty()) {
            throw new PluginExecutionException("Could not find any properties file in the " + dir + " directory. Ensure the directory " + installDir + " contains a Liberty installation.");
        }
        return list;
    }

    public static String getOpenLibertyVersion(List<ProductProperties> propList) {
        for (ProductProperties properties : propList) {
            if (!properties.getId().equals(OPEN_LIBERTY_PRODUCT_ID)) continue;
            return properties.getVersion();
        }
        return null;
    }

    public static boolean isClosedLiberty(List<ProductProperties> propList) {
        for (ProductProperties properties : propList) {
            if (!properties.getId().equals(CLOSED_LIBERTY_PRODUCT_ID)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOpenLibertyBetaVersion(String olVersion) {
        return olVersion != null && olVersion.endsWith("-beta");
    }

    private File downloadEsaArtifact(String mavenCoordinates) throws PluginExecutionException {
        String[] mavenCoordinateArray = mavenCoordinates.split(":");
        String groupId = mavenCoordinateArray[0];
        String artifactId = mavenCoordinateArray[1];
        String version = mavenCoordinateArray[2];
        return this.downloadArtifact(groupId, artifactId, "esa", version);
    }

    private Map<File, String> downloadEsas(Collection<?> mavenCoordsList, Map<String, String> artifactIdToExt) throws PluginExecutionException {
        HashMap<File, String> featurepathToExt = new HashMap<File, String>();
        for (Object coordinate : mavenCoordsList) {
            String[] coordinateArray = ((String)coordinate).split(":");
            String artifactId = coordinateArray[1];
            featurepathToExt.put(this.downloadEsaArtifact((String)coordinate), artifactIdToExt.get(artifactId));
        }
        return featurepathToExt;
    }

    public static Set<String> getOpenLibertyFeatureSet(Set<File> jsons) throws PluginExecutionException {
        HashSet<String> libertyFeatures = new HashSet<String>();
        for (File file : jsons) {
            Scanner s = null;
            try {
                s = new Scanner(file);
                while (s.findWithinHorizon("io.openliberty.features:([^:]*):", 0) != null) {
                    MatchResult match = s.match();
                    if (match.groupCount() < 1) continue;
                    libertyFeatures.add(match.group(1));
                }
            }
            catch (FileNotFoundException e) {
                throw new PluginExecutionException("The JSON file is not found at " + file.getAbsolutePath(), e);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
        return libertyFeatures;
    }

    private boolean isOnlyOpenLibertyFeatures(List<String> featuresToInstall) throws PluginExecutionException {
        boolean result = InstallFeatureUtil.containsIgnoreCase(InstallFeatureUtil.getOpenLibertyFeatureSet(this.downloadedJsons), featuresToInstall);
        this.debug("Is installing only Open Liberty features? " + result);
        return result;
    }

    public static boolean containsIgnoreCase(Collection<String> reference, Collection<String> target) {
        return InstallFeatureUtil.toLowerCase(reference).containsAll(InstallFeatureUtil.toLowerCase(target));
    }

    private static Set<String> toLowerCase(Collection<String> strings) {
        HashSet<String> result = new HashSet<String>(strings.size());
        for (String s : strings) {
            result.add(s.toLowerCase());
        }
        return result;
    }

    public void copyUserFeature(Set<String> pluginListedEsas, File installDirectory) throws PluginExecutionException {
        File userExtDirectory = this.getUserExtensionPath() != null ? this.getUserExtensionPath() : new File(installDirectory, "usr/extension");
        File libDirectory = new File(userExtDirectory, "lib");
        File featuresDirectory = new File(libDirectory, FEATURES_JSON_ARTIFACT_ID);
        libDirectory.mkdirs();
        featuresDirectory.mkdirs();
        block7: for (String esa : pluginListedEsas) {
            this.debug("Copying " + esa + " to Liberty image.");
            try (ZipFile zip = new ZipFile(esa);){
                Enumeration<? extends ZipEntry> zipEntries = zip.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry entry = zipEntries.nextElement();
                    String fileName = entry.getName();
                    if (fileName.toLowerCase().endsWith("subsystem.mf")) {
                        Manifest m = new Manifest(zip.getInputStream(entry));
                        String symbolicName = m.getMainAttributes().getValue("Subsystem-SymbolicName").split(";")[0];
                        String shortName = m.getMainAttributes().getValue("IBM-ShortName");
                        if (shortName != null) {
                            this.manuallyInstalledUsrFeatureMap.put(symbolicName.toLowerCase(), shortName.toLowerCase());
                        } else {
                            this.manuallyInstalledUsrFeatureMap.put(symbolicName.toLowerCase(), "");
                        }
                        File targetFile = new File(featuresDirectory, symbolicName + ".mf");
                        if (targetFile.exists()) {
                            this.info("The feature " + esa + " is already installed.");
                            continue block7;
                        }
                        this.copyZipEntry(zip, entry, targetFile);
                        continue;
                    }
                    if (!fileName.toLowerCase().endsWith(INSTALL_MAP_SUFFIX)) continue;
                    File targetFile = new File(libDirectory, fileName);
                    this.copyZipEntry(zip, entry, targetFile);
                }
            }
            catch (IOException e) {
                throw new PluginExecutionException(e);
            }
        }
    }

    public void installFeatures(boolean isAcceptLicense, List<String> featuresList) throws PluginExecutionException {
        HashMap<String, String> featureToExtMap = new HashMap<String, String>();
        ArrayList<String> featuresToInstall = new ArrayList<String>();
        if (this.openLibertyVersion != null) {
            this.info("plugin listed esa: " + this.pluginListedEsas.toString());
            if (VersionUtility.compareArtifactVersion(this.openLibertyVersion, MIN_USER_FEATURE_VERSION, true) < 0 && !this.pluginListedEsas.isEmpty()) {
                this.info("Neither InstallUtility nor FeatureUtility is available to install user feature esa.");
                this.info("Attempting to manually install the user feature esa without resolving its dependencies.");
                this.info("Recommended user action: upgrade to OpenLiberty version 21.0.0.11 or higher and provide features-bom file for the user feature esa.");
                this.info("To directly install the esa file without providing features-bom file, upgrade to OpenLiberty version 23.0.0.2 or later.");
                this.copyUserFeature(this.pluginListedEsas, this.installDirectory);
            }
        }
        for (String feature : featuresList) {
            if (feature.contains(":")) {
                String[] userFeatureSplit = feature.split(":");
                String userFeatureName = userFeatureSplit[1].toLowerCase();
                featureToExtMap.put(userFeatureName, userFeatureSplit[0]);
                if (this.manuallyInstalledUsrFeatureMap.containsValue(userFeatureName) || this.manuallyInstalledUsrFeatureMap.containsKey(userFeatureName)) continue;
                featuresToInstall.add(userFeatureName);
                continue;
            }
            featureToExtMap.put(feature, "");
            featuresToInstall.add(feature);
        }
        if (featuresToInstall.isEmpty()) {
            return;
        }
        if (this.containerName != null) {
            this.installFeaturesOnContainer(featuresToInstall, isAcceptLicense);
            return;
        }
        this.info("Installing features: " + featuresToInstall);
        ArrayList<File> jsonRepos = new ArrayList<File>(this.downloadedJsons);
        this.debug("JSON repos: " + jsonRepos);
        boolean acceptLicenseMapValue = this.isOnlyOpenLibertyFeatures(featuresToInstall) ? true : isAcceptLicense;
        URL installJarURL = null;
        try {
            installJarURL = this.installJarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginExecutionException("Could not resolve URL from file " + this.installJarFile, e);
        }
        Map<String, Object> mapBasedInstallKernel = null;
        this.disableCacheInURLClassLoader();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{installJarURL}, this.getClass().getClassLoader());){
            Collection resolvedFeatures;
            mapBasedInstallKernel = this.createMapBasedInstallKernelInstance(loader, this.installDirectory);
            mapBasedInstallKernel.put("install.local.esa", true);
            mapBasedInstallKernel.put("single.json.file", jsonRepos);
            mapBasedInstallKernel.put("features.to.resolve", featuresToInstall);
            mapBasedInstallKernel.put("license.accept", acceptLicenseMapValue);
            mapBasedInstallKernel.put("is.install.server.feature", true);
            if (this.isDebugEnabled()) {
                mapBasedInstallKernel.put("debug", Level.FINEST);
            }
            if ((resolvedFeatures = (Collection)mapBasedInstallKernel.get("action.result")) == null) {
                this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                throw new PluginExecutionException(exceptionMessage);
            }
            if (resolvedFeatures.isEmpty()) {
                this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                if (exceptionMessage == null) {
                    this.debug("resolvedFeatures was empty but the install kernel did not issue any messages");
                    this.info("The features are already installed, so no action is needed.");
                    return;
                }
                if (exceptionMessage.contains("CWWKF1250I")) {
                    this.info(exceptionMessage);
                    this.info("The features are already installed, so no action is needed.");
                    return;
                }
                if (this.isFeatureConflict(exceptionMessage)) {
                    throw new PluginExecutionException(CONFLICT_MESSAGE + featuresToInstall + ": " + exceptionMessage);
                }
                throw new PluginExecutionException(exceptionMessage);
            }
            Map<File, String> artifactsToExt = this.downloadEsas(resolvedFeatures, featureToExtMap);
            Set<File> artifacts = artifactsToExt.keySet();
            StringBuilder installedFeaturesBuilder = new StringBuilder();
            ArrayList actionReturnResult = new ArrayList();
            for (File esaFile : artifacts) {
                mapBasedInstallKernel.put("license.accept", acceptLicenseMapValue);
                mapBasedInstallKernel.put("action.install", esaFile);
                String ext = artifactsToExt.get(esaFile);
                mapBasedInstallKernel.put("to.extension", TO_USER);
                if (ext != null && !ext.equals("") && this.to != null) {
                    this.warn("The product extension location \"" + ext + "\" specified in the server.xml file overrides the to extension \"" + this.to + "\" specified in the build file.");
                }
                if (ext != null && !ext.equals("")) {
                    mapBasedInstallKernel.put("to.extension", ext);
                    this.debug("Installing to extension from server.xml: " + ext);
                } else if (this.to != null) {
                    mapBasedInstallKernel.put("to.extension", this.to);
                    this.debug("Installing to extension: " + this.to);
                }
                Integer ac = (Integer)mapBasedInstallKernel.get("action.result");
                this.debug("action.result: " + ac);
                this.debug("action.error.message: " + mapBasedInstallKernel.get("action.error.message"));
                if (mapBasedInstallKernel.get("action.error.message") != null) {
                    this.debug("action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                    String exceptionMessage = (String)mapBasedInstallKernel.get("action.error.message");
                    this.debug(exceptionMessage);
                    throw new PluginExecutionException(exceptionMessage);
                }
                if (mapBasedInstallKernel.get("action.install.result") == null) continue;
                actionReturnResult.addAll((Collection)mapBasedInstallKernel.get("action.install.result"));
            }
            for (String installResult : actionReturnResult) {
                installedFeaturesBuilder.append(installResult).append(" ");
            }
            this.productInfoValidate();
            this.info("The following features have been installed: " + installedFeaturesBuilder.toString());
            File schemaGenDir = new File(this.buildDirectory, ".libertyls");
            if (schemaGenDir.exists() && schemaGenDir.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)schemaGenDir);
                    this.debug("Deleted .libertyls directory after installing features.");
                }
                catch (IOException e) {
                    this.debug("Could not delete .libertyls directory after installing features.");
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new PluginExecutionException("Could not load the jar " + this.installJarFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new PluginExecutionException("Could not close the jar " + this.installJarFile.getAbsolutePath() + " after installing features.", e);
        }
        finally {
            if (mapBasedInstallKernel != null) {
                try {
                    mapBasedInstallKernel.clear();
                }
                catch (UnsupportedOperationException e) {
                    this.debug("This version of the install map does not support the clear operation.", e);
                }
                catch (RuntimeException e) {
                    throw new PluginExecutionException("Could not close resources after installing features.", e);
                }
            }
            this.restoreCacheInURLClassLoader();
        }
    }

    private synchronized void disableCacheInURLClassLoader() {
        try {
            if (saveURLCacheStatus == null) {
                Method getDefaultCaching = URLConnection.class.getMethod("getDefaultUseCaches", String.class);
                saveURLCacheStatus = (boolean)((Boolean)getDefaultCaching.invoke(null, "jar"));
                Method disableCaching = URLConnection.class.getMethod("setDefaultUseCaches", String.class, Boolean.TYPE);
                disableCaching.invoke(null, "jar", false);
            }
        }
        catch (NoSuchMethodException e) {
            this.debug("NoSuchMethodException trying to invoke java.net.URLConnection.setDefaultUseCaches(S,b) in disable");
        }
        catch (Exception e) {
            this.warn("Could not disable caching for URLConnection: " + e.getMessage());
            this.debug("Exception trying to invoke java.net.URLConnection.setDefaultUseCaches(S,b) in disable", e);
        }
    }

    private synchronized void restoreCacheInURLClassLoader() {
        try {
            if (saveURLCacheStatus != null) {
                Method disableCaching = URLConnection.class.getMethod("setDefaultUseCaches", String.class, Boolean.TYPE);
                disableCaching.invoke(null, "jar", saveURLCacheStatus);
            }
        }
        catch (NoSuchMethodException e) {
            this.debug("NoSuchMethodException trying to invoke java.net.URLConnection.setDefaultUseCaches(S,b) in restore");
        }
        catch (Exception e) {
            this.warn("Could not enable caching for URLConnection: " + e.getMessage());
            this.debug("Exception trying to invoke java.net.URLConnection.setDefaultUseCaches(S,b) in restore", e);
        }
        finally {
            saveURLCacheStatus = null;
        }
    }

    private Map<String, Object> createMapBasedInstallKernelInstance(final ClassLoader loader, File installDirectory) throws PrivilegedActionException, PluginExecutionException {
        Map<String, Object> mapBasedInstallKernel = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

            @Override
            public Map<String, Object> run() throws Exception {
                Class<?> clazz = loader.loadClass("com.ibm.ws.install.map.InstallMap");
                return (Map)clazz.newInstance();
            }
        });
        if (mapBasedInstallKernel == null) {
            throw new PluginExecutionException("Cannot run install jar file " + this.installJarFile);
        }
        String bundle = this.getOverrideBundleDescriptor(OPEN_LIBERTY_GROUP_ID, REPOSITORY_RESOLVER_ARTIFACT_ID);
        if (bundle != null) {
            ArrayList<String> bundles = new ArrayList<String>();
            bundles.add(bundle);
            this.debug("Overriding jar using: " + bundle);
            mapBasedInstallKernel.put("override.jar.bundles", bundles);
        }
        mapBasedInstallKernel.put("runtime.install.dir", installDirectory);
        try {
            mapBasedInstallKernel.put("install.map.jar.file", this.installJarFile);
            this.debug("install.map.jar.file: " + this.installJarFile);
        }
        catch (RuntimeException e) {
            this.debug("This version of the install map does not support the key \"install.map.jar.file\"", e);
            String installJarFileSubpath = this.installJarFile.getParentFile().getName() + File.separator + this.installJarFile.getName();
            mapBasedInstallKernel.put("install.map.jar", installJarFileSubpath);
            this.debug("install.map.jar: " + installJarFileSubpath);
        }
        this.debug("install.kernel.init.code: " + mapBasedInstallKernel.get("install.kernel.init.code"));
        this.debug("install.kernel.init.error.message: " + mapBasedInstallKernel.get("install.kernel.init.error.message"));
        File usrDir = new File(installDirectory, TO_USER);
        mapBasedInstallKernel.put("target.user.directory", usrDir);
        return mapBasedInstallKernel;
    }

    public String getOverrideBundleDescriptor(String groupId, String artifactId) throws PluginExecutionException {
        String symbolicName;
        File overrideJar = this.downloadOverrideJar(groupId, artifactId);
        if (overrideJar != null && overrideJar.exists() && (symbolicName = InstallFeatureUtil.extractSymbolicName(overrideJar)) != null) {
            return overrideJar.getAbsolutePath() + ";" + symbolicName;
        }
        return null;
    }

    private File downloadOverrideJar(String groupId, String artifactId) {
        try {
            return this.downloadArtifact(groupId, artifactId, "jar", String.format("[%s)", this.openLibertyVersion + ", " + InstallFeatureUtil.getNextProductVersion(this.openLibertyVersion)));
        }
        catch (PluginExecutionException e) {
            this.debug("Using jar from Liberty directory for " + artifactId + " bundle.");
            return null;
        }
    }

    public static String getNextProductVersion(String version) throws PluginExecutionException {
        int nextQuarterSpecifier;
        String result = null;
        int versionSplittingIndex = version.lastIndexOf(".") + 1;
        if (versionSplittingIndex == 0) {
            throw new PluginExecutionException("Product version " + version + " is not in the expected format. It must have period separated version segments.");
        }
        String quarterVersion = version.substring(versionSplittingIndex);
        try {
            nextQuarterSpecifier = Integer.parseInt(quarterVersion) + 1;
        }
        catch (NumberFormatException e) {
            throw new PluginExecutionException("Product version " + version + " is not in the expected format. Its last segment is expected to be an integer.", e);
        }
        result = version.substring(0, versionSplittingIndex) + nextQuarterSpecifier;
        return result;
    }

    public static String extractSymbolicName(File jar) throws PluginExecutionException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            String string = jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            return string;
        }
        catch (IOException e) {
            throw new PluginExecutionException("Could not load the jar " + jar.getAbsolutePath(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getMapBasedInstallKernelJar(File dir) {
        File[] installMapJars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(InstallFeatureUtil.INSTALL_MAP_PREFIX) && name.endsWith(InstallFeatureUtil.INSTALL_MAP_SUFFIX);
            }
        });
        File result = null;
        if (installMapJars != null) {
            for (File jar : installMapJars) {
                if (!InstallFeatureUtil.isReplacementJar(result, jar)) continue;
                result = jar;
            }
        }
        return result;
    }

    private static boolean isReplacementJar(File file1, File file2) {
        String version2;
        if (file1 == null) {
            return true;
        }
        if (file2 == null) {
            return false;
        }
        String version1 = InstallFeatureUtil.extractVersion(file1.getName());
        return InstallFeatureUtil.compare(version1, version2 = InstallFeatureUtil.extractVersion(file2.getName())) < 0;
    }

    private static String extractVersion(String fileName) {
        int endIndex;
        int startIndex = INSTALL_MAP_PREFIX.length() + 1;
        if (startIndex < (endIndex = fileName.lastIndexOf(INSTALL_MAP_SUFFIX))) {
            return fileName.substring(startIndex, endIndex);
        }
        return null;
    }

    private static int compare(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        String[] components1 = version1.split("\\.");
        String[] components2 = version2.split("\\.");
        for (int i = 0; i < components1.length && i < components2.length; ++i) {
            int comparison;
            try {
                comparison = new Integer(components1[i]).compareTo(new Integer(components2[i]));
            }
            catch (NumberFormatException e) {
                comparison = components1[i].compareTo(components2[i]);
            }
            if (comparison == 0) continue;
            return comparison;
        }
        return components1.length - components2.length;
    }

    private void productInfoValidate() throws PluginExecutionException {
        String output = InstallFeatureUtil.productInfo(this.installDirectory, "validate");
        if (output == null) {
            throw new PluginExecutionException("Could not perform product validation. The productInfo command returned with no output");
        }
        if (output.contains("[ERROR]")) {
            throw new PluginExecutionException(output);
        }
        this.info("Product validation completed successfully.");
    }

    public static String productInfo(File installDirectory, String action) throws PluginExecutionException {
        Process pr = null;
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            String productInfoFile = OSUtil.isWindows() ? "\"" + installDirectory + "\\bin\\productInfo.bat\"" : installDirectory + "/bin/productInfo";
            ProcessBuilder pb = new ProcessBuilder(productInfoFile, action);
            pr = pb.start();
            in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
            boolean exited = pr.waitFor(300L, TimeUnit.SECONDS);
            if (!exited) {
                throw new PluginExecutionException("productInfo command timed out");
            }
            int exitValue = pr.exitValue();
            if (exitValue != 0) {
                throw new PluginExecutionException("productInfo exited with return code " + exitValue + ". The productInfo command run was `" + productInfoFile + " " + action + "`");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new PluginExecutionException("productInfo error: " + ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PluginExecutionException("productInfo error: " + ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (pr != null) {
                pr.destroy();
            }
        }
    }

    private void installFeaturesOnContainer(List<String> features, boolean acceptLicense) throws PluginExecutionException {
        String cmdResult;
        if (features == null || features.isEmpty()) {
            this.debug("Skipping installing features on container " + this.containerName + " since no features were specified.");
            return;
        }
        this.info("Installing features " + features + " on container " + this.containerName);
        StringBuilder featureList = new StringBuilder();
        for (String feature : features) {
            featureList.append(feature).append(" ");
        }
        String featureUtilityCommand = this.getContainerCommandPrefix() + " exec -e FEATURE_LOCAL_REPO=/devmode-maven-cache " + this.containerName + " featureUtility installFeature " + featureList;
        if (acceptLicense) {
            featureUtilityCommand = featureUtilityCommand + "--acceptLicense";
        }
        if ((cmdResult = this.execContainerCmd(featureUtilityCommand, 600, false)).contains(" RC=")) {
            if (cmdResult.contains("CWWKF1250I")) {
                this.debug(cmdResult);
            } else if (this.isFeatureConflict(cmdResult)) {
                this.error(CONFLICT_MESSAGE + features + ": " + cmdResult);
            } else {
                this.error("An error occurred while installing features: " + cmdResult);
            }
        } else {
            this.debug(cmdResult);
        }
    }

    private boolean isFeatureConflict(String exceptionMessage) {
        Matcher m = conflictPattern.matcher(exceptionMessage);
        return m.find();
    }

    public static class ProductProperties {
        private String id;
        private String version;

        public ProductProperties(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

