/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.util.LibertyPropFilesUtility;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.VariableUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.comparator.NameFileComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfigDocument {
    private CommonLoggerI log;
    private File configDirectory;
    private File serverXMLFile;
    private File originalServerXMLFile;
    private Set<String> names;
    private Set<String> namelessLocations;
    private Set<String> locations;
    private HashMap<String, String> locationsAndNames;
    private Properties props;
    private Properties defaultProps;
    private Map<String, File> libertyDirectoryPropertyToFile = null;
    Optional<String> springBootAppNodeLocation = Optional.empty();
    Optional<String> springBootAppNodeDocumentURI = Optional.empty();
    private static final XPathExpression XPATH_SERVER_APPLICATION;
    private static final XPathExpression XPATH_SERVER_WEB_APPLICATION;
    private static final XPathExpression XPATH_SERVER_SPRINGBOOT_APPLICATION;
    private static final XPathExpression XPATH_SERVER_ENTERPRISE_APPLICATION;
    private static final XPathExpression XPATH_SERVER_INCLUDE;
    public static final XPathExpression XPATH_SERVER_VARIABLE;
    private static final XPathExpression XPATH_ALL_SERVER_APPLICATIONS;

    public Set<String> getLocations() {
        return this.locations;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Set<String> getNamelessLocations() {
        return this.namelessLocations;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Map<String, File> getLibertyDirPropertyFiles() {
        return this.libertyDirectoryPropertyToFile;
    }

    public Properties getDefaultProperties() {
        return this.defaultProps;
    }

    public File getServerXML() {
        return this.serverXMLFile;
    }

    public ServerConfigDocument(CommonLoggerI log, File originalServerXMLFile, Map<String, File> libertyDirPropertyFiles) throws PluginExecutionException {
        this.log = log;
        if (libertyDirPropertyFiles != null) {
            this.libertyDirectoryPropertyToFile = new HashMap<String, File>(libertyDirPropertyFiles);
            this.configDirectory = this.libertyDirectoryPropertyToFile.get("server.config.dir");
            this.serverXMLFile = this.getFileFromConfigDirectory("server.xml");
        } else {
            log.warn("The properties for directories are null and could lead to application locations not being resolved correctly.");
            this.libertyDirectoryPropertyToFile = new HashMap<String, File>();
        }
        this.locations = new HashSet<String>();
        this.names = new HashSet<String>();
        this.namelessLocations = new HashSet<String>();
        this.locationsAndNames = new HashMap();
        this.props = new Properties();
        this.defaultProps = new Properties();
        this.originalServerXMLFile = originalServerXMLFile;
        this.initializeAppsLocation();
    }

    public ServerConfigDocument(CommonLoggerI log, File originalServerXMLFile, File installDirectory, File userDirectory, File serverDirectory, File serverOutputDirectory) throws PluginExecutionException, IOException {
        this(log, originalServerXMLFile, LibertyPropFilesUtility.getLibertyDirectoryPropertyFiles(log, installDirectory, userDirectory, serverDirectory, serverOutputDirectory));
    }

    public ServerConfigDocument(CommonLoggerI log, File originalServerXMLFile, Map<String, File> libertyDirPropertyFiles, Properties initProperties) {
        this.log = log;
        this.libertyDirectoryPropertyToFile = new HashMap<String, File>(libertyDirPropertyFiles);
        this.configDirectory = this.libertyDirectoryPropertyToFile.get("server.config.dir");
        this.serverXMLFile = this.getFileFromConfigDirectory("server.xml");
        this.locations = new HashSet<String>();
        this.names = new HashSet<String>();
        this.namelessLocations = new HashSet<String>();
        this.locationsAndNames = new HashMap();
        this.props = new Properties();
        if (initProperties != null) {
            this.props.putAll((Map<?, ?>)initProperties);
        }
        this.defaultProps = new Properties();
        this.originalServerXMLFile = originalServerXMLFile;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setCoalescing(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        docBuilderFactory.setValidating(false);
        try {
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docBuilderFactory.setXIncludeAware(false);
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return docBuilder;
    }

    public void initializeAppsLocation() throws PluginExecutionException {
        try {
            Document doc = this.parseDocument(this.serverXMLFile);
            this.parseVariablesForDefaultValues(doc);
            this.processServerEnv();
            this.processBootstrapProperties();
            this.processSystemProperties();
            this.processVariablesDirectory();
            this.processServerXml(doc);
            this.processPredefinedVariables();
            this.parseApplication(doc, XPATH_SERVER_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_SPRINGBOOT_APPLICATION);
            this.parseNames(doc, XPATH_ALL_SERVER_APPLICATIONS);
            this.parseInclude(doc);
            this.parseConfigDropinsDir();
        }
        catch (Exception e) {
            if (e instanceof PluginExecutionException) {
                throw (PluginExecutionException)e;
            }
            e.printStackTrace();
        }
    }

    private void processPredefinedVariables() throws IOException {
        for (Map.Entry<String, File> stringFileEntry : this.getLibertyDirPropertyFiles().entrySet()) {
            this.props.put(stringFileEntry.getKey(), stringFileEntry.getValue().getCanonicalPath());
        }
    }

    public void processServerEnv() throws Exception, FileNotFoundException {
        String serverEnvString = "server.env";
        this.parsePropertiesFromFile(new File(this.libertyDirectoryPropertyToFile.get("wlp.install.dir"), "etc" + File.separator + "server.env"));
        this.parsePropertiesFromFile(new File(this.libertyDirectoryPropertyToFile.get("wlp.user.dir"), "shared" + File.separator + "server.env"));
        this.parsePropertiesFromFile(this.getFileFromConfigDirectory("server.env"));
    }

    public void processJvmOptions() throws FileNotFoundException, Exception {
        String jvmOptionsString = "jvm.options";
        this.parsePropertiesFromFile(new File(this.libertyDirectoryPropertyToFile.get("wlp.user.dir"), "shared" + File.separator + "jvm.options"));
        this.parsePropertiesFromFile(this.getFileFromConfigDirectory("configDropins/default/jvm.options"));
        this.parsePropertiesFromFile(this.getFileFromConfigDirectory("jvm.options"));
        this.parsePropertiesFromFile(this.getFileFromConfigDirectory("configDropins/overrides/jvm.options"));
    }

    public void processBootstrapProperties() throws Exception, FileNotFoundException {
        File bootstrapFile = this.getFileFromConfigDirectory("bootstrap.properties");
        if (bootstrapFile == null) {
            return;
        }
        this.parsePropertiesFromFile(bootstrapFile);
        if (this.props.containsKey("bootstrap.include")) {
            HashSet<String> visited = new HashSet<String>();
            visited.add(bootstrapFile.getAbsolutePath());
            this.processBootstrapInclude(visited);
        }
    }

    private void processBootstrapInclude(Set<String> processedBootstrapIncludes) throws FileNotFoundException, Exception {
        File bootstrapIncludeFile;
        String bootstrapIncludeLocationString = this.props.getProperty("bootstrap.include");
        Path bootstrapIncludePath = Paths.get(bootstrapIncludeLocationString, new String[0]);
        File file = bootstrapIncludeFile = bootstrapIncludePath.isAbsolute() ? new File(bootstrapIncludePath.toString()) : new File(this.configDirectory, bootstrapIncludePath.toString());
        if (processedBootstrapIncludes.contains(bootstrapIncludeFile.getAbsolutePath())) {
            return;
        }
        if (bootstrapIncludeFile.exists()) {
            this.parsePropertiesFromFile(bootstrapIncludeFile);
            processedBootstrapIncludes.add(bootstrapIncludeFile.getAbsolutePath());
            this.processBootstrapInclude(processedBootstrapIncludes);
        }
    }

    private void processSystemProperties() {
        this.props.putAll((Map<?, ?>)System.getProperties());
    }

    public void processVariablesDirectory() throws FileNotFoundException, Exception {
        String variableDirectoryProperty = "VARIABLE_SOURCE_DIRS";
        ArrayList<File> toProcess = new ArrayList<File>();
        if (!this.props.containsKey("VARIABLE_SOURCE_DIRS")) {
            toProcess.add(this.getFileFromConfigDirectory("variables"));
        } else {
            String[] directories;
            String delimiter = File.separator.equals("/") ? ":" : ";";
            for (String directory : directories = this.props.get("VARIABLE_SOURCE_DIRS").toString().split(delimiter)) {
                Path directoryPath = Paths.get(directory, new String[0]);
                File directoryFile = directoryPath.toFile();
                if (!directoryFile.exists()) continue;
                toProcess.add(directoryFile);
            }
        }
        for (File directory : toProcess) {
            if (directory == null || !directory.isDirectory()) continue;
            this.processVariablesDirectory(directory, "");
        }
    }

    private void processVariablesDirectory(File directory, String propertyPrefix) throws FileNotFoundException, Exception {
        for (File child : directory.listFiles()) {
            if (child.isDirectory()) {
                this.processVariablesDirectory(child, child.getName() + File.separator);
                continue;
            }
            if (child.getName().endsWith(".properties")) {
                this.parsePropertiesFromFile(child);
                continue;
            }
            String propertyName = propertyPrefix + child.getName();
            String propertyValue = new String(Files.readAllBytes(child.toPath()));
            this.props.setProperty(propertyName, propertyValue);
        }
    }

    public void processServerXml(Document doc) throws XPathExpressionException, IOException, SAXException {
        this.parseIncludeVariables(doc);
        this.parseConfigDropinsDirVariables("defaults");
        this.parseVariablesForValues(doc);
        this.parseConfigDropinsDirVariables("overrides");
    }

    private void parseNames(Document doc, XPathExpression expression) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getAttributes().getNamedItem("name") != null) {
                String nameValue = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String locationValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
                if (nameValue.isEmpty()) continue;
                String resolvedName = VariableUtility.resolveVariables(this.log, nameValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
                String resolvedLocation = VariableUtility.resolveVariables(this.log, locationValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
                if (resolvedName == null) {
                    if (!this.names.contains(nameValue)) {
                        this.names.add(nameValue);
                    }
                } else if (!this.names.contains(resolvedName)) {
                    this.names.add(resolvedName);
                }
                if (resolvedLocation == null) continue;
                if (resolvedName == null) {
                    this.locationsAndNames.put(resolvedLocation, nameValue);
                    continue;
                }
                this.locationsAndNames.put(resolvedLocation, resolvedName);
                continue;
            }
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            String resolved = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (resolved == null) {
                if (this.namelessLocations.contains(nodeValue)) continue;
                this.namelessLocations.add(nodeValue);
                continue;
            }
            if (this.namelessLocations.contains(resolved)) continue;
            this.namelessLocations.add(resolved);
        }
    }

    public String findNameForLocation(String location) {
        String appName = this.locationsAndNames.get(location);
        if (appName == null || appName.isEmpty()) {
            appName = location.substring(0, location.lastIndexOf(46));
        }
        return appName;
    }

    private void parseApplication(Document doc, XPathExpression expression) throws XPathExpressionException, PluginExecutionException {
        NodeList nodeList = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        if (expression.equals(XPATH_SERVER_SPRINGBOOT_APPLICATION) && nodeList.getLength() > 1) {
            throw new PluginExecutionException(String.format("Found multiple springBootApplication elements specified in the server configuration file %s. Only one springBootApplication can be configured per Liberty server.", doc.getDocumentURI()));
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            this.checkForSpringBootApplicationNode(doc, expression, nodeValue);
            String resolved = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (resolved == null) {
                this.log.info("The variables referenced by location " + nodeValue + " cannot be resolved.");
                if (this.locations.contains(nodeValue)) continue;
                this.locations.add(nodeValue);
                continue;
            }
            if (this.locations.contains(resolved)) continue;
            this.log.debug("Adding resolved app location: " + resolved + " for specified location: " + nodeValue);
            this.locations.add(resolved);
        }
    }

    private void checkForSpringBootApplicationNode(Document doc, XPathExpression expression, String nodeValue) throws PluginExecutionException {
        if (expression.equals(XPATH_SERVER_SPRINGBOOT_APPLICATION)) {
            if (this.springBootAppNodeLocation.isPresent() && this.springBootAppNodeDocumentURI.isPresent()) {
                throw new PluginExecutionException(String.format("Found multiple springBootApplication elements specified in the server configuration in files [%s, %s]. Only one springBootApplication can be configured per Liberty server.", this.springBootAppNodeDocumentURI.get(), doc.getDocumentURI()));
            }
            this.log.debug("Setting springBootApplication location as " + nodeValue);
            this.springBootAppNodeLocation = Optional.of(nodeValue);
            this.springBootAppNodeDocumentURI = Optional.of(doc.getDocumentURI());
        }
    }

    private void parseInclude(Document doc) throws XPathExpressionException, IOException, SAXException, PluginExecutionException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                this.log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                continue;
            }
            ArrayList<Document> inclDocs = this.getIncludeDocs(includeFileName);
            for (Document inclDoc : inclDocs) {
                this.parseApplication(inclDoc, XPATH_SERVER_APPLICATION);
                this.parseApplication(inclDoc, XPATH_SERVER_WEB_APPLICATION);
                this.parseApplication(inclDoc, XPATH_SERVER_SPRINGBOOT_APPLICATION);
                this.parseApplication(inclDoc, XPATH_SERVER_ENTERPRISE_APPLICATION);
                this.parseNames(inclDoc, XPATH_ALL_SERVER_APPLICATIONS);
                this.parseInclude(inclDoc);
            }
        }
    }

    private void parseConfigDropinsDir() throws XPathExpressionException, IOException, SAXException, PluginExecutionException {
        File defaults;
        File configDropins = this.getConfigDropinsDir();
        if (configDropins == null || !configDropins.exists()) {
            return;
        }
        File overrides = new File(configDropins, "overrides");
        if (overrides.exists()) {
            this.parseDropinsFiles(overrides.listFiles());
        }
        if ((defaults = new File(configDropins, "defaults")).exists()) {
            this.parseDropinsFiles(defaults.listFiles());
        }
    }

    private void parseDropinsFiles(File[] files) throws XPathExpressionException, IOException, SAXException, PluginExecutionException {
        Arrays.sort(files, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            this.parseDropinsFile(file);
        }
    }

    private void parseDropinsFile(File file) throws IOException, XPathExpressionException, SAXException, PluginExecutionException {
        Document doc = this.parseDocument(file);
        if (doc != null) {
            this.parseApplication(doc, XPATH_SERVER_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_SPRINGBOOT_APPLICATION);
            this.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            this.parseNames(doc, XPATH_ALL_SERVER_APPLICATIONS);
            this.parseInclude(doc);
        }
    }

    private ArrayList<Document> getIncludeDocs(String loc) throws IOException, SAXException {
        ArrayList<Document> docs = new ArrayList<Document>();
        Document doc = null;
        File locFile = null;
        if (loc.startsWith("http:") || loc.startsWith("https:")) {
            if (this.isValidURL(loc)) {
                URL url = new URL(loc);
                doc = this.parseDocument(url);
                docs.add(doc);
            }
        } else if (loc.startsWith("file:")) {
            if (this.isValidURL(loc)) {
                locFile = new File(loc);
                doc = this.parseDocument(locFile);
                docs.add(doc);
            }
        } else if (!loc.startsWith("ftp:")) {
            locFile = new File(loc);
            if (!locFile.isAbsolute()) {
                if (this.configDirectory != null && this.configDirectory.exists()) {
                    locFile = new File(this.configDirectory, loc);
                }
                if (locFile == null || !locFile.exists()) {
                    locFile = new File(this.getServerXML().getParentFile(), loc);
                }
            }
            this.parseDocumentFromFileOrDirectory(locFile, loc, docs);
        }
        if (docs.isEmpty()) {
            this.log.warn("Did not parse any file(s) from include location: " + loc);
        }
        return docs;
    }

    private void parseDocumentFromFileOrDirectory(File f, String locationString, ArrayList<Document> docs) throws FileNotFoundException, IOException, SAXException {
        Document doc = null;
        boolean isLibertyDirectory = locationString.endsWith("/");
        if (f == null || !f.exists()) {
            this.log.warn("Unable to parse from file: " + f.getCanonicalPath());
            return;
        }
        if (f.isFile() && isLibertyDirectory) {
            this.log.error("Path specified a directory, but resource exists as a file (path=" + locationString + ")");
            return;
        }
        if (f.isDirectory() && !isLibertyDirectory) {
            this.log.error("Path specified a file, but resource exists as a directory (path=" + locationString + ")");
            return;
        }
        if (f.isDirectory()) {
            this.parseDocumentsInDirectory(f, docs);
        } else {
            doc = this.parseDocument(f);
            docs.add(doc);
        }
    }

    private void parseDocumentsInDirectory(File directory, ArrayList<Document> docs) {
        File[] files = directory.listFiles();
        Arrays.sort(files, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : files) {
            try {
                docs.add(this.parseDocument(file));
            }
            catch (Exception e) {
                this.log.warn("Unable to parse from file " + file.getPath() + " from specified include directory: " + directory.getPath());
            }
        }
    }

    public Document parseDocument(File file) throws FileNotFoundException, IOException {
        Document document;
        FileInputStream is = new FileInputStream(file);
        try {
            Document document2 = this.parseDocument(is);
            document2.setDocumentURI(file.getCanonicalPath());
            document = document2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException ex) {
                this.log.info("Skipping parsing " + file.getAbsolutePath() + " because it was not recognized as XML.");
                return null;
            }
        }
        is.close();
        return document;
    }

    private Document parseDocument(URL url) throws IOException, SAXException {
        URLConnection connection = url.openConnection();
        try (InputStream is = connection.getInputStream();){
            Document document = this.parseDocument(is);
            return document;
        }
    }

    private Document parseDocument(InputStream in) throws SAXException, IOException {
        try (InputStream ins = in;){
            Document document = this.getDocumentBuilder().parse(ins);
            return document;
        }
    }

    public void parsePropertiesFromFile(File propertiesFile) throws Exception, FileNotFoundException {
        if (propertiesFile != null && propertiesFile.exists()) {
            this.parseProperties(new FileInputStream(propertiesFile));
            this.log.debug("Processed properties from file: " + propertiesFile.getAbsolutePath());
        }
    }

    private void parseProperties(InputStream ins) throws Exception {
        try {
            this.props.load(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
    }

    private boolean isValidURL(String url) {
        try {
            URL testURL = new URL(url);
            testURL.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void parseVariablesForDefaultValues(Document doc) throws XPathExpressionException {
        List<Properties> propsList = VariableUtility.parseVariables(doc, true, false, false);
        this.defaultProps.putAll((Map<?, ?>)propsList.get(1));
    }

    private void parseVariablesForValues(Document doc) throws XPathExpressionException {
        List<Properties> propsList = VariableUtility.parseVariables(doc, false, true, false);
        this.props.putAll((Map<?, ?>)propsList.get(0));
    }

    public void parseVariablesForBothValues(Document doc) throws XPathExpressionException {
        List<Properties> propsList = VariableUtility.parseVariables(doc, false, false, true);
        this.props.putAll((Map<?, ?>)propsList.get(0));
        this.defaultProps.putAll((Map<?, ?>)propsList.get(1));
    }

    public void parseIncludeVariables(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(this.log, nodeValue, null, this.getProperties(), this.getDefaultProperties(), this.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                this.log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                continue;
            }
            ArrayList<Document> inclDocs = this.getIncludeDocs(includeFileName);
            for (Document inclDoc : inclDocs) {
                this.parseVariablesForBothValues(inclDoc);
                this.parseIncludeVariables(inclDoc);
            }
        }
    }

    private File getConfigDropinsDir() {
        File configDropins = null;
        if (this.configDirectory != null && this.configDirectory.exists()) {
            configDropins = new File(this.configDirectory, "configDropins");
        }
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(this.getServerXML().getParent(), "configDropins");
        }
        return configDropins;
    }

    private void parseConfigDropinsDirVariables(String inDir) throws XPathExpressionException, SAXException, IOException {
        File configDropins = this.getConfigDropinsDir();
        if (configDropins == null || !configDropins.exists()) {
            return;
        }
        File dir = new File(configDropins, inDir);
        if (!dir.exists()) {
            return;
        }
        File[] cfgFiles = dir.listFiles();
        Arrays.sort(cfgFiles, NameFileComparator.NAME_INSENSITIVE_COMPARATOR);
        for (File file : cfgFiles) {
            if (!file.isFile()) continue;
            this.parseDropinsFilesVariables(file);
        }
    }

    private void parseDropinsFilesVariables(File file) throws SAXException, IOException, XPathExpressionException {
        Document doc = this.parseDocument(file);
        if (doc != null) {
            this.parseVariablesForBothValues(doc);
            this.parseIncludeVariables(doc);
        }
    }

    private File findConfigFile(String fileName, File specificFile, boolean giveConfigDirPrecedence) {
        File f = new File(this.configDirectory, fileName);
        if (giveConfigDirPrecedence) {
            if (this.configDirectory != null && f.exists()) {
                return f;
            }
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
        } else {
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
            if (this.configDirectory != null && f.exists()) {
                return f;
            }
        }
        return null;
    }

    private File getFileFromConfigDirectory(String filename) {
        File f = new File(this.configDirectory, filename);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        this.log.debug(filename + " was not found in: " + this.configDirectory.getAbsolutePath());
        return null;
    }

    public File getOriginalServerXMLFile() {
        return this.originalServerXMLFile;
    }

    public void setOriginalServerXMLFile(File originalServerXMLFile) {
        this.originalServerXMLFile = originalServerXMLFile;
    }

    public Optional<String> getSpringBootAppNodeLocation() {
        return this.springBootAppNodeLocation;
    }

    public void setSpringBootAppNodeLocation(Optional<String> springBootAppNodeLocation) {
        this.springBootAppNodeLocation = springBootAppNodeLocation;
    }

    static {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPATH_SERVER_APPLICATION = xPath.compile("/server/application");
            XPATH_SERVER_WEB_APPLICATION = xPath.compile("/server/webApplication");
            XPATH_SERVER_SPRINGBOOT_APPLICATION = xPath.compile("/server/springBootApplication");
            XPATH_SERVER_ENTERPRISE_APPLICATION = xPath.compile("/server/enterpriseApplication");
            XPATH_SERVER_INCLUDE = xPath.compile("/server/include");
            XPATH_SERVER_VARIABLE = xPath.compile("/server/variable");
            XPATH_ALL_SERVER_APPLICATIONS = xPath.compile("/server/application | /server/webApplication | /server/enterpriseApplication | /server/springBootApplication");
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

