/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.CommonLoggerI;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LibertyPropFilesUtility {
    public static Map<String, File> getLibertyDirectoryPropertyFiles(CommonLoggerI log, File installDir, File userDir, File serverDir, File serverOutputDirectory) {
        HashMap<String, File> libertyDirectoryPropertyToFile = new HashMap<String, File>();
        if (serverDir.exists()) {
            try {
                libertyDirectoryPropertyToFile.put("server.config.dir", serverDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("wlp.install.dir", installDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("wlp.user.dir", userDir.getCanonicalFile());
                File userExtDir = new File(userDir, "extension");
                libertyDirectoryPropertyToFile.put("usr.extension.dir", userExtDir.getCanonicalFile());
                File userSharedDir = new File(userDir, "shared");
                File userSharedAppDir = new File(userSharedDir, "app");
                File userSharedConfigDir = new File(userSharedDir, "config");
                File userSharedResourcesDir = new File(userSharedDir, "resources");
                File userSharedStackGroupsDir = new File(userSharedDir, "stackGroups");
                libertyDirectoryPropertyToFile.put("shared.app.dir", userSharedAppDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("shared.config.dir", userSharedConfigDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("shared.resource.dir", userSharedResourcesDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("shared.stackgroup.dir", userSharedStackGroupsDir.getCanonicalFile());
                libertyDirectoryPropertyToFile.put("server.output.dir", serverOutputDirectory.getCanonicalFile());
                return libertyDirectoryPropertyToFile;
            }
            catch (Exception e) {
                log.warn("The properties for directories could not be initialized because an error occurred when accessing the directories.");
                log.debug("Exception received: " + e.getMessage(), e);
            }
        } else {
            log.warn("The " + serverDir + " directory cannot be accessed. The properties for directories could not be initialized.");
        }
        return Collections.emptyMap();
    }
}

