/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class BinaryScannerUtil {
    public static final String BINARY_SCANNER_MAVEN_GROUP_ID = "com.ibm.websphere.appmod.tools";
    public static final String BINARY_SCANNER_MAVEN_ARTIFACT_ID = "binary-app-scanner";
    public static final String BINARY_SCANNER_MAVEN_TYPE = "jar";
    public static final String BINARY_SCANNER_MAVEN_VERSION = "[21.0.0.5-SNAPSHOT,)";
    public static final String GENERATED_FEATURES_FILE_NAME = "generated-features.xml";
    public static final String GENERATED_FEATURES_FILE_PATH = "configDropins/overrides/generated-features.xml";
    private static final String FEATURE_MODIFIED_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.RequiredFeatureModifiedException";
    private static final String FEATURE_CONFLICT_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.FeatureConflictException";
    private static final String PROVIDED_FEATURE_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.ProvidedFeatureConflictException";
    private static final String FEATURE_NOT_AVAILABLE_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.FeatureNotAvailableAtRequestedLevelException";
    private static final String ILLEGAL_TARGET_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetException";
    private static final String ILLEGAL_TARGET_COMBINATION_EXCEPTION = "com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetCombinationException";
    public static final String BINARY_SCANNER_CONFLICT_MESSAGE1 = "A working set of features could not be generated due to conflicts between configured features and the application's API usage: %s. Review and update your server configuration and application to ensure they are not using conflicting features and APIs from different levels of MicroProfile, Java EE, or Jakarta EE. Refer to the following set of suggested features for guidance: %s.";
    public static final String BINARY_SCANNER_CONFLICT_MESSAGE2 = "A working set of features could not be generated due to conflicts between configured features: %s. Review and update your server configuration to ensure it is not using conflicting features from different levels of MicroProfile, Java EE, or Jakarta EE. Refer to the following set of suggested features for guidance: %s.";
    public static final String BINARY_SCANNER_CONFLICT_MESSAGE3 = "A working set of features could not be generated due to conflicts in the application\u2019s API usage: %s. Review and update your application to ensure it is not using conflicting APIs from different levels of MicroProfile, Java EE, or Jakarta EE.";
    public static final String BINARY_SCANNER_CONFLICT_MESSAGE4 = "[None available]";
    public static final String BINARY_SCANNER_CONFLICT_MESSAGE5 = "A working set of features could not be generated due to conflicts in the required features: %s and required levels of MicroProfile: %s, Java EE or Jakarta EE: %s. Review and update your application to ensure it is using the correct levels of MicroProfile, Java EE, or Jakarta EE, or consider removing the following set of features: %s.";
    public static final String BINARY_SCANNER_INVALID_MP_MESSAGE = "The MicroProfile version number %s specified in the build file is not supported for feature generation.";
    public static final String BINARY_SCANNER_INVALID_EE_MESSAGE = "The Java EE or Jakarta EE version number %s specified in the build file is not supported for feature generation.";
    public static final String BINARY_SCANNER_INVALID_EEMPARG_MESSAGE = "Either the Java EE or Jakarta EE version number or the MicroProfile version number specified in the build file is not supported for feature generation.";
    public static final String BINARY_SCANNER_INVALID_COMBO_MESSAGE = "The Java EE or Jakarta EE version number %s specified in the build file in combination with the MicroProfile version number %s specified in the build file is not supported for feature generation.";
    public static final String BINARY_SCANNER_EE_PREFIX = "ee";
    public static final String BINARY_SCANNER_MP_PREFIX = "mp";
    private File binaryScanner;
    private URLClassLoader binaryScannerClassLoader = null;
    private Class binaryScannerClass = null;
    private Method binaryScannerMethod = null;

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract boolean isDebugEnabled();

    public BinaryScannerUtil(File binaryScanner) {
        this.binaryScanner = binaryScanner;
    }

    public Set<String> runBinaryScanner(Set<String> currentFeatureSet, List<String> classFiles, Set<String> allClassesDirectories, String logLocation, String targetJavaEE, String targetMicroProfile, boolean optimize) throws PluginExecutionException, NoRecommendationException, RecommendationSetException, FeatureModifiedException, FeatureUnavailableException, IllegalTargetException, IllegalTargetComboException {
        Set featureList = null;
        if (this.binaryScanner != null && this.binaryScanner.exists()) {
            boolean reRunIfFailed = !currentFeatureSet.isEmpty() || !optimize;
            try {
                String logLevel;
                Method generateFeatureSetMethod = this.getScannerMethod();
                Set<String> binaryInputs = BinaryScannerUtil.getBinaryInputs(classFiles, allClassesDirectories, optimize);
                if (this.isDebugEnabled()) {
                    logLevel = "*=FINE";
                } else {
                    logLevel = null;
                    logLocation = null;
                }
                this.debug("Calling " + this.binaryScanner.getName() + " with the following inputs...\n  binaryInputs: " + binaryInputs + "\n  targetJavaEE: " + targetJavaEE + "\n  targetMicroP: " + targetMicroProfile + "\n  currentFeatures: " + currentFeatureSet + "\n  logLocation: " + logLocation + "\n  logLevel: " + logLevel + "\n  locale: " + Locale.getDefault());
                featureList = (Set)generateFeatureSetMethod.invoke(null, binaryInputs, targetJavaEE, targetMicroProfile, currentFeatureSet, logLocation, logLevel, Locale.getDefault());
                for (String s : featureList) {
                    this.debug(s);
                }
            }
            catch (InvocationTargetException ite) {
                String msg;
                Throwable scannerException = ite.getCause();
                if (scannerException.getClass().getName().equals(PROVIDED_FEATURE_EXCEPTION)) {
                    Set<String> conflicts = this.getFeatures(scannerException);
                    Set<String> sampleFeatureList = this.reRunBinaryScanner(allClassesDirectories, logLocation, targetJavaEE, targetMicroProfile);
                    if (sampleFeatureList == null) {
                        throw new NoRecommendationException(conflicts);
                    }
                    throw new RecommendationSetException(true, conflicts, sampleFeatureList);
                }
                if (scannerException.getClass().getName().equals(FEATURE_CONFLICT_EXCEPTION)) {
                    Set<String> sampleFeatureList;
                    Set<String> conflicts = this.getFeatures(scannerException);
                    Set<String> set = sampleFeatureList = reRunIfFailed ? this.reRunBinaryScanner(allClassesDirectories, logLocation, targetJavaEE, targetMicroProfile) : null;
                    if (sampleFeatureList == null) {
                        throw new NoRecommendationException(conflicts);
                    }
                    throw new RecommendationSetException(false, conflicts, sampleFeatureList);
                }
                if (scannerException.getClass().getName().equals(FEATURE_MODIFIED_EXCEPTION)) {
                    Set<String> modifications = this.getFeatures(scannerException);
                    Set<String> sampleFeatureList = reRunIfFailed ? this.reRunBinaryScanner(allClassesDirectories, logLocation, targetJavaEE, targetMicroProfile) : null;
                    throw new FeatureModifiedException(modifications, sampleFeatureList == null ? this.getNoSampleFeatureList() : sampleFeatureList, scannerException.getLocalizedMessage());
                }
                if (scannerException.getClass().getName().equals(FEATURE_NOT_AVAILABLE_EXCEPTION)) {
                    Set<String> conflicts = this.getFeatures(scannerException);
                    Set<String> unavailableFeatures = this.getUnavailableEEFeatures(scannerException);
                    unavailableFeatures.addAll(this.getUnavailableMPFeatures(scannerException));
                    throw new FeatureUnavailableException(conflicts, unavailableFeatures, targetMicroProfile, targetJavaEE);
                }
                if (scannerException.getClass().getName().equals(ILLEGAL_TARGET_EXCEPTION)) {
                    throw new IllegalTargetException(this.getInvalidEETarget(scannerException), this.getInvalidMPTarget(scannerException));
                }
                if (scannerException.getClass().getName().equals(ILLEGAL_TARGET_COMBINATION_EXCEPTION)) {
                    throw new IllegalTargetComboException(this.getInvalidEETarget(scannerException), this.getInvalidMPTarget(scannerException));
                }
                if (scannerException.getClass().getName().contains("java.lang.IllegalArgumentException") && (msg = scannerException.getMessage()).contains("CWMIG12056E")) {
                    if (msg.contains("targetJavaEE")) {
                        throw new PluginExecutionException(BINARY_SCANNER_INVALID_EE_MESSAGE);
                    }
                    if (msg.contains("targetMicroProfile")) {
                        throw new PluginExecutionException(BINARY_SCANNER_INVALID_MP_MESSAGE);
                    }
                }
                this.debug("Exception from binary scanner.", scannerException);
                throw new PluginExecutionException("Error scanning the application for Liberty features: " + scannerException.toString());
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | MalformedURLException loadingException) {
                Throwable o = loadingException.getCause();
                if (o != null) {
                    this.debug("Caused by exception:" + loadingException.getCause().getClass().getName());
                    this.debug("Caused by exception message:" + loadingException.getCause().getMessage());
                }
                throw new PluginExecutionException("An error occurred when trying to call the binary scanner jar: " + loadingException.toString());
            }
        } else {
            if (this.binaryScanner == null) {
                throw new PluginExecutionException("The binary scanner jar location is not defined.");
            }
            throw new PluginExecutionException("Could not find the binary scanner jar at " + this.binaryScanner.getAbsolutePath());
        }
        return featureList;
    }

    public Set<String> reRunBinaryScanner(Set<String> allClassesDirectories, String logLocation, String targetJavaEE, String targetMicroProfile) throws PluginExecutionException {
        Set featureList = null;
        try {
            String logLevel;
            Method generateFeatureSetMethod = this.getScannerMethod();
            Set<String> binaryInputs = allClassesDirectories;
            HashSet currentFeaturesSet = new HashSet();
            if (this.isDebugEnabled()) {
                logLevel = "*=FINE";
            } else {
                logLevel = null;
                logLocation = null;
            }
            this.debug("Recalling binary scanner with the following inputs...\n  binaryInputs: " + binaryInputs + "\n  targetJavaEE: " + targetJavaEE + "\n  targetMicroP: " + targetMicroProfile + "\n  currentFeatures: " + currentFeaturesSet + "\n  logLocation: " + logLocation + "\n  logLevel: " + logLevel + "\n  locale: " + Locale.getDefault());
            featureList = (Set)generateFeatureSetMethod.invoke(null, binaryInputs, targetJavaEE, targetMicroProfile, currentFeaturesSet, logLocation, logLevel, Locale.getDefault());
            for (String s : featureList) {
                this.debug(s);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable scannerException = ite.getCause();
            if (scannerException.getClass().getName().equals(PROVIDED_FEATURE_EXCEPTION)) {
                this.debug("RuntimeException from re-run of binary scanner", scannerException);
                featureList = null;
            }
            if (scannerException.getClass().getName().equals(FEATURE_CONFLICT_EXCEPTION)) {
                featureList = this.getNoSampleFeatureList();
            }
            if (scannerException.getClass().getName().equals(FEATURE_MODIFIED_EXCEPTION)) {
                featureList = this.getNoSampleFeatureList();
            }
            this.debug("Exception from rerunning binary scanner.", scannerException);
            throw new PluginExecutionException("Error scanning the application for Liberty feature recommendations: " + scannerException.toString());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | MalformedURLException loadingException) {
            Throwable o = loadingException.getCause();
            if (o != null) {
                this.debug("Caused by exception2:" + loadingException.getCause().getClass().getName());
                this.debug("Caused by exception message2:" + loadingException.getCause().getMessage());
            }
            throw new PluginExecutionException("An error occurred when trying to call the binary scanner jar for recommendations: " + loadingException.toString());
        }
        return featureList;
    }

    private Set<String> getNoSampleFeatureList() {
        HashSet<String> sampleFeatureList = new HashSet<String>();
        sampleFeatureList.add(BINARY_SCANNER_CONFLICT_MESSAGE4);
        return sampleFeatureList;
    }

    private ClassLoader getScannerClassLoader() throws MalformedURLException {
        if (this.binaryScannerClassLoader == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.binaryScannerClassLoader = new URLClassLoader(new URL[]{this.binaryScanner.toURI().toURL()}, cl);
        }
        return this.binaryScannerClassLoader;
    }

    private Class getScannerClass() throws MalformedURLException, ClassNotFoundException {
        if (this.binaryScannerClass == null) {
            ClassLoader cl = this.getScannerClassLoader();
            this.binaryScannerClass = cl.loadClass("com.ibm.websphere.binary.cmdline.BinaryScanner");
        }
        return this.binaryScannerClass;
    }

    private Method getScannerMethod() throws MalformedURLException, ClassNotFoundException, NoSuchMethodException, PluginExecutionException, SecurityException {
        if (this.binaryScannerMethod == null) {
            Class driveScan = this.getScannerClass();
            this.binaryScannerMethod = driveScan.getMethod("generateFeatureList", Set.class, String.class, String.class, Set.class, String.class, String.class, Locale.class);
            if (this.binaryScannerMethod == null) {
                throw new PluginExecutionException("Error finding binary scanner method using reflection");
            }
        }
        return this.binaryScannerMethod;
    }

    private static Set<String> getBinaryInputs(List<String> classFiles, Set<String> classDirectories, boolean optimize) throws PluginExecutionException {
        Set<String> resultSet;
        if (optimize) {
            if (classDirectories == null || classDirectories.isEmpty()) {
                return new HashSet<String>();
            }
            resultSet = classDirectories;
        } else if (classFiles != null && !classFiles.isEmpty()) {
            resultSet = new HashSet<String>(classFiles);
        } else {
            return new HashSet<String>();
        }
        return resultSet;
    }

    private Set<String> getFeatures(Throwable scannerResponse) {
        return (Set)this.getMethodResult(scannerResponse, "getFeatures");
    }

    private Set<String> getUnavailableMPFeatures(Throwable scannerResponse) {
        return (Set)this.getMethodResult(scannerResponse, "getUnavailableMPFeatures");
    }

    private Set<String> getUnavailableEEFeatures(Throwable scannerResponse) {
        return (Set)this.getMethodResult(scannerResponse, "getUnavailableEEFeatures");
    }

    private String getInvalidMPTarget(Throwable scannerResponse) {
        return (String)this.getMethodResult(scannerResponse, "getIllegalMPTarget");
    }

    private String getInvalidEETarget(Throwable scannerResponse) {
        return (String)this.getMethodResult(scannerResponse, "getIllegalEETarget");
    }

    private Object getMethodResult(Throwable scannerResponse, String method) {
        try {
            ClassLoader cl = this.getScannerClassLoader();
            Class<?> featureConflictException = cl.loadClass(scannerResponse.getClass().getName());
            Method featureMethod = featureConflictException.getMethod(method, new Class[0]);
            if (featureMethod == null) {
                this.debug("Error finding " + scannerResponse.getClass().getName() + " method " + method + " using reflection");
                return null;
            }
            return featureMethod.invoke((Object)scannerResponse, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException x) {
            this.debug("An error occurred when trying to call the binary scanner jar " + method + ":" + x.getClass().getName(), x);
            Throwable cause = x.getCause();
            if (cause != null) {
                this.debug("Caused by exception:" + cause.getClass().getName());
                this.debug("Caused by exception message:" + cause.getMessage());
            }
            return null;
        }
    }

    public static String composeEEVersion(String ver) {
        if (ver == null) {
            return null;
        }
        int offset = ver.indexOf(".");
        String majorVersion = offset == -1 ? ver : ver.substring(0, offset);
        return BINARY_SCANNER_EE_PREFIX + majorVersion;
    }

    public static String composeMPVersion(String ver) {
        String[] parts;
        if (ver == null) {
            return null;
        }
        int offset = ver.indexOf("-RC");
        if (offset > 0) {
            ver = ver.substring(0, offset);
        }
        if ((parts = ver.split("\\.", 3)).length > 1 && parts[0] != null && !parts[0].isEmpty() && parts[1] != null && !parts[1].isEmpty()) {
            return BINARY_SCANNER_MP_PREFIX + parts[0] + "." + parts[1];
        }
        return null;
    }

    public static String buildInvalidArgExceptionMessage(String invalidEEArg, String invalidMPArg, String eeVersion, String mpVersion) {
        String messages = null;
        if (invalidEEArg != null) {
            messages = String.format(BINARY_SCANNER_INVALID_EE_MESSAGE, eeVersion);
        }
        if (invalidMPArg != null) {
            if (messages != null) {
                messages = messages + "\n";
                messages = messages + String.format(BINARY_SCANNER_INVALID_MP_MESSAGE, mpVersion);
            } else {
                messages = String.format(BINARY_SCANNER_INVALID_MP_MESSAGE, mpVersion);
            }
        }
        if (messages == null) {
            messages = BINARY_SCANNER_INVALID_EEMPARG_MESSAGE;
        }
        return messages;
    }

    public class NoRecommendationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Set<String> conflicts;

        NoRecommendationException(Set<String> conflictSet) {
            this.conflicts = conflictSet;
        }

        public Set<String> getConflicts() {
            return this.conflicts;
        }
    }

    public class RecommendationSetException
    extends Exception {
        private static final long serialVersionUID = 1L;
        boolean existingFeaturesConflict;
        Set<String> conflicts;
        Set<String> suggestions;

        RecommendationSetException(boolean existing, Set<String> conflictSet, Set<String> suggestionSet) {
            this.existingFeaturesConflict = existing;
            this.conflicts = conflictSet;
            this.suggestions = suggestionSet;
        }

        public boolean isExistingFeaturesConflict() {
            return this.existingFeaturesConflict;
        }

        public Set<String> getConflicts() {
            return this.conflicts;
        }

        public Set<String> getSuggestions() {
            return this.suggestions;
        }
    }

    public class FeatureModifiedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Set<String> features;
        Set<String> suggestions;
        String message;

        FeatureModifiedException(Set<String> featureSet, Set<String> suggestionSet, String message) {
            this.features = featureSet;
            this.suggestions = suggestionSet;
            this.message = message;
        }

        public Set<String> getFeatures() {
            return this.features;
        }

        public Set<String> getSuggestions() {
            return this.suggestions;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public class FeatureUnavailableException
    extends Exception {
        private static final long serialVersionUID = 1L;
        Set<String> conflicts;
        Set<String> unavailableFeatures;
        String mpLevel;
        String eeLevel;

        FeatureUnavailableException(Set<String> conflictsSet, Set<String> unavailableFeaturesSet, String mpLevel, String eeLevel) {
            this.conflicts = conflictsSet;
            this.unavailableFeatures = unavailableFeaturesSet;
            this.mpLevel = mpLevel;
            this.eeLevel = eeLevel;
        }

        public Set<String> getConflicts() {
            return this.conflicts;
        }

        public Set<String> getUnavailableFeatures() {
            return this.unavailableFeatures;
        }

        public String getEELevel() {
            return this.eeLevel;
        }

        public String getMPLevel() {
            return this.mpLevel;
        }
    }

    public class IllegalTargetException
    extends AbstractIllegalTargetException {
        private static final long serialVersionUID = 1L;

        IllegalTargetException(String eeLevel, String mpLevel) {
            super(eeLevel, mpLevel);
        }
    }

    public class IllegalTargetComboException
    extends AbstractIllegalTargetException {
        private static final long serialVersionUID = 1L;

        IllegalTargetComboException(String eeLevel, String mpLevel) {
            super(eeLevel, mpLevel);
        }
    }

    public abstract class AbstractIllegalTargetException
    extends Exception {
        private static final long serialVersionUID = 1L;
        String eeLevel;
        String mpLevel;

        AbstractIllegalTargetException(String eeLevel, String mpLevel) {
            this.eeLevel = eeLevel;
            this.mpLevel = mpLevel;
        }

        public String getEELevel() {
            return this.eeLevel;
        }

        public String getMPLevel() {
            return this.mpLevel;
        }
    }
}

