/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.config.ServerConfigDocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VariableUtility {
    private static final String VARIABLE_NAME_PATTERN = "\\$\\{(.*?)\\}";
    private static final Pattern varNamePattern = Pattern.compile("\\$\\{(.*?)\\}");

    public static String resolveVariables(CommonLoggerI log, String nodeValue, Collection<String> variableChain, Properties props, Properties defaultProps, Map<String, File> libDirPropFiles) {
        String resolved = nodeValue.replace("\\", "/");
        Matcher varNameMatcher = varNamePattern.matcher(nodeValue);
        HashSet<String> variablesToResolve = new HashSet<String>();
        while (varNameMatcher.find()) {
            String varName = varNameMatcher.group(1);
            if (variableChain != null && variableChain.contains(varName)) {
                log.debug("Found a recursive variable reference when resolving ${" + varName + "}");
                return null;
            }
            variablesToResolve.add(varName);
        }
        for (String nextVariable : variablesToResolve) {
            String resolvedValue;
            String value = VariableUtility.getPropertyValue(nextVariable, props, defaultProps, libDirPropFiles);
            if (value == null) {
                log.debug("Variable " + nextVariable + " cannot be resolved.");
                return null;
            }
            HashSet<String> thisVariableChain = new HashSet<String>();
            thisVariableChain.add(nextVariable);
            if (variableChain != null && !variableChain.isEmpty()) {
                thisVariableChain.addAll(variableChain);
            }
            if ((resolvedValue = VariableUtility.resolveVariables(log, value, thisVariableChain, props, defaultProps, libDirPropFiles)) != null) {
                String escapedVariable = Matcher.quoteReplacement(nextVariable);
                resolvedValue = resolvedValue.replace("\\", "/");
                resolved = resolved.replaceAll("\\$\\{" + escapedVariable + "\\}", resolvedValue);
                continue;
            }
            log.debug("Variable " + nextVariable + " cannot be resolved.");
            return null;
        }
        log.debug("Expression " + nodeValue + " evaluated and replaced with " + resolved);
        return resolved;
    }

    public static String getPropertyValue(String propertyName, Properties prop, Properties defaultProps, Map<String, File> libertyDirPropFiles) {
        String value = null;
        if (libertyDirPropFiles.containsKey(propertyName)) {
            return VariableUtility.stripQuotes(libertyDirPropFiles.get(propertyName).toString());
        }
        value = VariableUtility.lookupProperty(prop, defaultProps, propertyName);
        if (value != null) {
            return value;
        }
        String propertyNameVariation = propertyName.replaceAll("\\W", "_");
        value = VariableUtility.lookupProperty(prop, defaultProps, propertyNameVariation);
        if (value != null) {
            return value;
        }
        value = VariableUtility.lookupProperty(prop, defaultProps, propertyNameVariation = propertyNameVariation.toUpperCase());
        if (value != null) {
            return value;
        }
        if (propertyName != null && propertyName.startsWith("env.") && propertyName.length() > 4 && (value = VariableUtility.lookupProperty(prop, defaultProps, propertyName.substring(4))) != null) {
            return value;
        }
        return value;
    }

    private static String stripQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String lookupProperty(Properties prop, Properties defaultProps, String propertyName) {
        if (prop.containsKey(propertyName)) {
            return VariableUtility.stripQuotes(prop.getProperty(propertyName));
        }
        if (defaultProps.containsKey(propertyName)) {
            return VariableUtility.stripQuotes(defaultProps.getProperty(propertyName));
        }
        return null;
    }

    public static List<Properties> parseVariables(Document doc, boolean defaultValues, boolean values, boolean both) throws XPathExpressionException {
        NodeList nodeList = (NodeList)ServerConfigDocument.XPATH_SERVER_VARIABLE.evaluate(doc, XPathConstants.NODESET);
        Properties props = new Properties();
        Properties defaultProps = new Properties();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap attr = nodeList.item(i).getAttributes();
            String varName = attr.getNamedItem("name").getNodeValue();
            if (varName.isEmpty()) continue;
            String varValue = VariableUtility.getValue(attr, "value");
            String varDefaultValue = VariableUtility.getValue(attr, "defaultValue");
            if ((values || both) && varValue != null) {
                props.setProperty(varName, varValue);
            }
            if (!defaultValues && !both || varDefaultValue == null) continue;
            defaultProps.setProperty(varName, varDefaultValue);
        }
        ArrayList<Properties> result = new ArrayList<Properties>();
        result.add(props);
        result.add(defaultProps);
        return result;
    }

    private static String getValue(NamedNodeMap attr, String nodeName) {
        String value = null;
        Node valueNode = attr.getNamedItem(nodeName);
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        return value;
    }
}

