/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public abstract class DevUtil {
    private static final String START_SERVER_MESSAGE_PREFIX = "CWWKF0011I:";
    private static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    private static final String UPDATED_APP_MESSAGE_REGEXP = "CWWKZ0003I.*";
    private static final String PORT_IN_USE_MESSAGE_PREFIX = "CWWKO0221E:";
    private static final String WEB_APP_AVAILABLE_MESSAGE_PREFIX = "CWWKT0016I:";
    private static final String LISTENING_ON_PORT_MESSAGE_PREFIX = "CWWKO0219I:";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String GENERATED_HEADER_REGEX = "# Generated by liberty-.*-plugin";
    private static final String[] IGNORE_DIRECTORY_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_POSTFIXES = new String[]{".dmp", "~", "___jb_tmp___", "___jb_old___"};
    private static final String[] DEFAULT_COMPILER_OPTIONS = new String[]{"-g", "-parameters"};
    private File serverDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File configDirectory;
    private List<File> resourceDirs;
    private boolean hotTests;
    private Path tempConfigPath;
    private boolean skipTests;
    private boolean skipUTs;
    private boolean skipITs;
    private String applicationId;
    private int appStartupTimeout;
    private int appUpdateTimeout;
    private Thread serverThread;
    private AtomicBoolean devStop;
    private String hostName;
    private String httpPort;
    private String httpsPort;
    private final long compileWaitMillis;
    private AtomicBoolean inputUnavailable;
    private int alternativeDebugPort = -1;
    private boolean libertyDebug;
    private int libertyDebugPort;
    private AtomicBoolean detectedAppStarted;
    private long serverStartTimeout;
    private boolean useBuildRecompile;
    private Map<File, Properties> propertyFilesMap;
    private final Set<FileAlterationObserver> fileObservers;
    private final Set<FileAlterationObserver> newFileObservers;
    private AtomicBoolean calledShutdownHook;
    private boolean gradle;
    private long pollingInterval;
    private FileTrackMode trackingMode;
    private HotkeyReader hotkeyReader = null;
    Collection<File> recompileJavaSources;
    Collection<File> recompileJavaTests;
    Collection<File> deleteJavaSources;
    Collection<File> deleteJavaTests;
    Collection<File> failedCompilationJavaSources;
    Collection<File> failedCompilationJavaTests;
    long lastJavaSourceChange;
    long lastJavaTestChange;
    boolean triggerJavaSourceRecompile;
    boolean triggerJavaTestRecompile;
    File outputDirectory;
    File serverXmlFile;
    File serverXmlFileParent;
    File bootstrapPropertiesFile;
    File bootstrapPropertiesFileParent;
    File jvmOptionsFile;
    File jvmOptionsFileParent;
    File buildFile;
    List<String> artifactPaths;
    WatchService watcher;

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract List<String> getArtifacts();

    public abstract boolean recompileBuildFile(File var1, List<String> var2, ThreadPoolExecutor var3) throws PluginExecutionException;

    public abstract void runUnitTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void runIntegrationTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void checkConfigFile(File var1, File var2);

    public abstract boolean compile(File var1);

    public abstract void stopServer();

    public abstract ServerTask getServerTask() throws Exception;

    public abstract void redeployApp() throws PluginExecutionException;

    public abstract String getServerStartTimeoutExample();

    public DevUtil(File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, List<File> resourceDirs, boolean hotTests, boolean skipTests, boolean skipUTs, boolean skipITs, String applicationId, long serverStartTimeout, int appStartupTimeout, int appUpdateTimeout, long compileWaitMillis, boolean libertyDebug, boolean useBuildRecompile, boolean gradle, boolean pollingTest) {
        this.serverDirectory = serverDirectory;
        this.sourceDirectory = sourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.configDirectory = configDirectory;
        this.resourceDirs = resourceDirs;
        this.hotTests = hotTests;
        this.skipTests = skipTests;
        this.skipUTs = skipUTs;
        this.skipITs = skipITs;
        this.applicationId = applicationId;
        this.serverStartTimeout = serverStartTimeout;
        this.appStartupTimeout = appStartupTimeout;
        this.appUpdateTimeout = appUpdateTimeout;
        this.devStop = new AtomicBoolean(false);
        this.compileWaitMillis = compileWaitMillis;
        this.inputUnavailable = new AtomicBoolean(false);
        this.libertyDebug = libertyDebug;
        this.detectedAppStarted = new AtomicBoolean(false);
        this.useBuildRecompile = useBuildRecompile;
        this.calledShutdownHook = new AtomicBoolean(false);
        this.gradle = gradle;
        this.fileObservers = new HashSet<FileAlterationObserver>();
        this.newFileObservers = new HashSet<FileAlterationObserver>();
        this.pollingInterval = 100L;
        this.trackingMode = pollingTest ? FileTrackMode.POLLING : FileTrackMode.NOT_SET;
    }

    public void runTests(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs) {
        if (!this.skipTests) {
            ServerTask serverTask = null;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                this.error("Could not get the server task for running tests.", e);
            }
            File logFile = serverTask.getLogFile();
            String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.debug("Thread interrupted while waiting to start tests.", e);
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.debug("Tests were re-invoked before previous tests began. Cancelling previous tests and resubmitting them.");
                } else {
                    this.debug("Changes were detected before tests began. Cancelling tests and resubmitting them.");
                }
                return;
            }
            if (!(this.gradle || this.skipUTs || forceSkipUTs)) {
                this.info("Running unit tests...");
                try {
                    this.runUnitTests();
                    this.info("Unit tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.info("Tests were invoked while previous tests were running. Restarting tests.");
                } else {
                    this.info("Changes were detected while tests were running. Restarting tests.");
                }
                return;
            }
            if (!this.skipITs) {
                if (!this.detectedAppStarted.get()) {
                    if (this.appStartupTimeout < 0) {
                        this.warn("The verifyTimeout (verifyAppStartTimeout) value needs to be an integer greater than or equal to 0.  The default value of 30 seconds will be used.");
                        this.appStartupTimeout = 30;
                    }
                    long timeout = this.appStartupTimeout * 1000;
                    this.info("Waiting up to " + this.appStartupTimeout + " seconds to find the application start up or update message...");
                    String startMessage = serverTask.waitForStringInLog("(CWWKZ0001I.*|CWWKZ0003I.*" + this.applicationId + ")", timeout, logFile);
                    if (startMessage == null) {
                        this.error("Unable to verify if the application was started after " + this.appStartupTimeout + " seconds.  Consider increasing the verifyTimeout value if this continues to occur.");
                    } else {
                        this.detectedAppStarted.set(true);
                    }
                } else if (waitForApplicationUpdate) {
                    if (this.appUpdateTimeout < 0) {
                        this.appUpdateTimeout = 5;
                    }
                    long timeout = this.appUpdateTimeout * 1000;
                    serverTask.waitForUpdatedStringInLog(regexp, timeout, logFile, messageOccurrences);
                }
                if (this.gradle) {
                    this.info("Running tests...");
                } else {
                    this.info("Running integration tests...");
                }
                try {
                    this.runIntegrationTests();
                    if (this.gradle) {
                        this.info("Tests finished.");
                    } else {
                        this.info("Integration tests finished.");
                    }
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    public int countApplicationUpdatedMessages() {
        int messageOccurrences = -1;
        if (!this.skipTests && !this.skipITs) {
            try {
                ServerTask serverTask = this.getServerTask();
                File logFile = serverTask.getLogFile();
                String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
                messageOccurrences = serverTask.countStringOccurrencesInFile(regexp, logFile);
                this.debug("Message occurrences before compile: " + messageOccurrences);
            }
            catch (Exception e) {
                this.debug("Failed to get message occurrences before compile", e);
            }
        }
        return messageOccurrences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() throws PluginExecutionException {
        try {
            long serverStartTimeoutMillis;
            String startMessage;
            ServerTask serverTask;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
            }
            this.enableServerDebug();
            String logsDirectory = this.serverDirectory.getCanonicalPath() + "/logs";
            final File messagesLogFile = new File(logsDirectory + "/messages.log");
            boolean logsExist = new File(logsDirectory).isDirectory();
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            serverTask.execute();
                        }
                        catch (RuntimeException e) {
                            if (DevUtil.this.devStop.get()) break block2;
                            DevUtil.this.error("An error occurred while starting the server: " + e.getMessage(), e);
                            throw e;
                        }
                    }
                }
            });
            this.serverThread.start();
            this.setDevStop(false);
            if (logsExist) {
                final AtomicBoolean messagesModified = new AtomicBoolean(false);
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(messagesLogFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(messagesLogFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                FileAlterationObserver observer = new FileAlterationObserver(logsDirectory, singleFileFilter);
                observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

                    public void onFileCreate(File file) {
                        messagesModified.set(true);
                    }

                    public void onFileChange(File file) {
                        messagesModified.set(true);
                    }
                });
                try {
                    observer.initialize();
                    while (!messagesModified.get()) {
                        observer.checkAndNotify();
                        Thread.sleep(500L);
                    }
                    this.debug("messages.log has been changed");
                }
                catch (Exception e) {
                    this.error("An error occured while waiting for the server to update messages.log: " + e.getMessage(), e);
                }
                finally {
                    try {
                        observer.destroy();
                    }
                    catch (Exception e) {
                        this.debug("Could not destroy FileAlterationObserver for logs directory " + logsDirectory, e);
                    }
                }
            }
            if (this.serverStartTimeout < 0L) {
                this.warn("The serverStartTimeout value needs to be an integer greater than or equal to 0.  The default value of 90 seconds will be used.");
                this.serverStartTimeout = 90L;
            }
            if ((startMessage = serverTask.waitForStringInLog(START_SERVER_MESSAGE_PREFIX, serverStartTimeoutMillis = this.serverStartTimeout * 1000L, messagesLogFile)) == null) {
                this.setDevStop(true);
                this.stopServer();
                throw new PluginExecutionException("The server has not started within " + this.serverStartTimeout + " seconds. Consider increasing the server start timeout if this continues to occur. For example, " + this.getServerStartTimeoutExample());
            }
            String portError = serverTask.findStringInFile(PORT_IN_USE_MESSAGE_PREFIX, messagesLogFile);
            if (portError != null) {
                this.error(portError.split(PORT_IN_USE_MESSAGE_PREFIX)[1]);
            }
            this.parseHostNameAndPorts(serverTask, messagesLogFile);
        }
        catch (IOException e) {
            throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
        }
    }

    public abstract void libertyCreate() throws PluginExecutionException;

    public abstract void libertyDeploy() throws PluginExecutionException;

    public abstract void libertyInstallFeature() throws PluginExecutionException;

    public void restartServer() throws PluginExecutionException {
        this.info("Restarting server...");
        this.setDevStop(true);
        this.stopServer();
        if (this.serverThread != null) {
            long threadShutdownTimeoutSeconds = 30L;
            try {
                this.serverThread.join(30000L);
                if (this.serverThread.isAlive()) {
                    throw new PluginExecutionException("Could not stop the server after 30 seconds.  Ensure that the server has been stopped, then start dev mode again.");
                }
            }
            catch (InterruptedException e) {
                if (this.serverThread.isAlive()) {
                    throw new PluginExecutionException("Could not stop the server.  Ensure that the server has been stopped, then start dev mode again.", e);
                }
                this.debug(e);
            }
        }
        this.libertyCreate();
        this.libertyInstallFeature();
        this.libertyDeploy();
        this.startServer();
        this.setDevStop(false);
        this.info("The server has been restarted.");
    }

    private void parseHostNameAndPorts(ServerTask serverTask, File messagesLogFile) throws PluginExecutionException {
        List listeningOnPortMessages;
        String webAppMessage = serverTask.findStringInFile(WEB_APP_AVAILABLE_MESSAGE_PREFIX, messagesLogFile);
        this.debug("Web app available message: " + webAppMessage);
        if (webAppMessage != null) {
            int portPrefixIndex = this.parseHostName(webAppMessage);
            this.parseHttpPort(webAppMessage, portPrefixIndex);
        }
        if ((listeningOnPortMessages = serverTask.findStringsInFile(LISTENING_ON_PORT_MESSAGE_PREFIX, messagesLogFile)) != null) {
            this.parseHttpsPort(listeningOnPortMessages);
        }
    }

    protected int parseHostName(String webAppMessage) throws PluginExecutionException {
        int portPrefixIndex;
        int protocolIndex = webAppMessage.indexOf(HTTP_PREFIX);
        int hostNameIndex = protocolIndex + HTTP_PREFIX.length();
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTPS_PREFIX);
            hostNameIndex = protocolIndex + HTTPS_PREFIX.length();
            if (protocolIndex < 0) {
                throw new PluginExecutionException("Could not parse the host name from the log message: " + webAppMessage);
            }
        }
        if ((portPrefixIndex = webAppMessage.indexOf(":", hostNameIndex)) < 0) {
            throw new PluginExecutionException("Could not parse the port number from the log message: " + webAppMessage);
        }
        this.hostName = webAppMessage.substring(hostNameIndex, portPrefixIndex);
        this.debug("Parsed host name: " + this.hostName);
        return portPrefixIndex;
    }

    protected void parseHttpPort(String webAppMessage, int portPrefixIndex) {
        if (!webAppMessage.contains(HTTP_PREFIX)) {
            return;
        }
        int portIndex = portPrefixIndex + 1;
        int portEndIndex = webAppMessage.indexOf("/", portIndex);
        if (portEndIndex < 0) {
            portEndIndex = webAppMessage.length();
        }
        this.httpPort = webAppMessage.substring(portIndex, portEndIndex);
        this.debug("Parsed http port: " + this.httpPort);
    }

    protected void parseHttpsPort(List<String> messages) throws PluginExecutionException {
        for (String message : messages) {
            String[] messageTokens;
            this.debug("Looking for https port in message: " + message);
            String httpsMessageContents = message.split(LISTENING_ON_PORT_MESSAGE_PREFIX)[1];
            for (String token : messageTokens = httpsMessageContents.split(" ")) {
                if (!token.contains("-ssl")) continue;
                String parsedHttpsPort = this.getPortFromMessageTokens(messageTokens);
                if (parsedHttpsPort != null) {
                    this.debug("Parsed https port: " + parsedHttpsPort);
                    this.httpsPort = parsedHttpsPort;
                    return;
                }
                throw new PluginExecutionException("Could not parse the https port number from the log message: " + message);
            }
        }
        this.debug("Could not find https port. The server might not be configured for https.");
    }

    private String getPortFromMessageTokens(String[] messageTokens) throws PluginExecutionException {
        for (int i = messageTokens.length - 1; i >= 0; --i) {
            String numericToken = messageTokens[i].replaceAll("[^\\d]", "");
            if (numericToken.length() <= 0) continue;
            try {
                int parsedPort = Integer.parseInt(numericToken);
                if (parsedPort > 65535) continue;
                return numericToken;
            }
            catch (NumberFormatException e) {
                this.debug("Could not parse integer from numeric token " + numericToken + " from message token " + messageTokens[i], e);
            }
        }
        return null;
    }

    public void cleanUpServerEnv() {
        block5: {
            try {
                File serverEnvBackup = new File(this.serverDirectory.getCanonicalPath() + "/server.env.bak");
                File serverEnvFile = new File(this.serverDirectory.getCanonicalPath() + "/server.env");
                if (serverEnvBackup.exists()) {
                    try {
                        Files.copy(serverEnvBackup.toPath(), serverEnvFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.error("Could not restore server.env: " + e.getMessage());
                    }
                    serverEnvBackup.delete();
                    break block5;
                }
                serverEnvFile.delete();
            }
            catch (IOException e) {
                this.error("Could not retrieve server.env: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempConfig() {
        File tempConfig;
        if (this.tempConfigPath != null && (tempConfig = this.tempConfigPath.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)tempConfig);
                this.debug("Sucessfully deleted liberty:dev temporary configuration folder");
            }
            catch (IOException e) {
                this.error("Could not delete liberty:dev temporary configuration folder");
            }
        }
    }

    public void setDevStop(boolean devStop) {
        this.devStop.set(devStop);
    }

    public void addShutdownHook(final ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DevUtil.this.runShutdownHook(executor);
            }
        });
    }

    private void runShutdownHook(ThreadPoolExecutor executor) {
        if (!this.calledShutdownHook.getAndSet(true)) {
            this.debug("Inside Shutdown Hook, shutting down server");
            if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
                this.disablePolling();
            }
            this.setDevStop(true);
            this.cleanUpTempConfig();
            this.cleanUpServerEnv();
            if (this.hotkeyReader != null) {
                this.hotkeyReader.shutdown();
            }
            executor.shutdown();
            this.stopServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePolling() {
        Set<FileAlterationObserver> set = this.newFileObservers;
        synchronized (set) {
            this.consolidateFileObservers();
            for (FileAlterationObserver observer : this.fileObservers) {
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    this.debug("Could not destroy file observer", e);
                }
            }
        }
    }

    public Map<String, String> getDebugEnvironmentVariables() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("WLP_DEBUG_SUSPEND", "n");
        map.put("WLP_DEBUG_ADDRESS", String.valueOf(this.findAvailablePort(this.libertyDebugPort)));
        return map;
    }

    public void enableServerDebug() throws IOException {
        this.enableServerDebug(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableServerDebug(boolean findAvailablePort) throws IOException {
        if (!this.libertyDebug) {
            return;
        }
        String serverEnvPath = this.serverDirectory.getCanonicalPath() + "/server.env";
        File serverEnvFile = new File(serverEnvPath);
        StringBuilder sb = new StringBuilder();
        File serverEnvBackup = new File(serverEnvPath + ".bak");
        if (serverEnvFile.exists()) {
            this.debug("server.env already exists");
            Files.copy(serverEnvFile.toPath(), serverEnvBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean deleted = serverEnvFile.delete();
            if (!deleted) {
                this.error("Could not move existing server.env file");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(serverEnvBackup));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
        } else {
            serverEnvBackup.delete();
        }
        this.debug("Creating server.env file: " + serverEnvFile.getCanonicalPath());
        sb.append("WLP_DEBUG_SUSPEND=n\n");
        sb.append("WLP_DEBUG_ADDRESS=");
        if (findAvailablePort) {
            sb.append(this.findAvailablePort(this.libertyDebugPort));
        } else {
            sb.append(this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort);
        }
        sb.append("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(serverEnvFile));){
            writer.write(sb.toString());
        }
        if (serverEnvFile.exists()) {
            this.debug("Successfully created liberty:dev server.env file");
        }
    }

    public int findAvailablePort(int preferredPort) throws IOException {
        int portToTry = preferredPort;
        if (this.alternativeDebugPort != -1) {
            portToTry = this.alternativeDebugPort;
        }
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(null), portToTry), 1);
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotkeyReaderThread(ThreadPoolExecutor executor) {
        if (this.inputUnavailable.get()) {
            return;
        }
        boolean startedNewHotkeyReader = false;
        if (this.hotkeyReader == null) {
            this.hotkeyReader = new HotkeyReader(executor);
            new Thread(this.hotkeyReader).start();
            this.debug("Started hotkey reader.");
            startedNewHotkeyReader = true;
        }
        if (!this.skipTests) {
            AtomicBoolean atomicBoolean = this.inputUnavailable;
            synchronized (atomicBoolean) {
                try {
                    if (startedNewHotkeyReader) {
                        this.inputUnavailable.wait(500L);
                    }
                    if (!this.inputUnavailable.get()) {
                        if (this.hotTests) {
                            this.info("Tests will run automatically when changes are detected. You can also press the Enter key to run tests on demand.");
                        } else {
                            this.info("Press the Enter key to run tests on demand. To stop the server and quit dev mode, use Ctrl-C or type 'q' and press the Enter key.");
                        }
                    } else {
                        this.debug("Cannot read user input, setting hotTests to true.");
                        this.info("Tests will run automatically when changes are detected.");
                        this.hotTests = true;
                    }
                }
                catch (InterruptedException e) {
                    this.debug("Interrupted while waiting to determine whether input can be read", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchFiles(File buildFile, File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths, File serverXmlFile, File bootstrapPropertiesFile, File jvmOptionsFile) throws Exception {
        this.buildFile = buildFile;
        this.outputDirectory = outputDirectory;
        this.serverXmlFile = serverXmlFile;
        this.bootstrapPropertiesFile = bootstrapPropertiesFile;
        this.jvmOptionsFile = jvmOptionsFile;
        this.artifactPaths = artifactPaths;
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.serverXmlFileParent = null;
            if (serverXmlFile != null && serverXmlFile.exists()) {
                this.serverXmlFileParent = serverXmlFile.getParentFile();
            }
            this.bootstrapPropertiesFileParent = null;
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                this.bootstrapPropertiesFileParent = bootstrapPropertiesFile.getParentFile();
            }
            this.jvmOptionsFileParent = null;
            if (jvmOptionsFile != null && jvmOptionsFile.exists()) {
                this.jvmOptionsFileParent = jvmOptionsFile.getParentFile();
            }
            Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
            Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
            Path configPath = this.configDirectory.getCanonicalFile().toPath();
            boolean sourceDirRegistered = false;
            boolean testSourceDirRegistered = false;
            boolean configDirRegistered = false;
            boolean serverXmlFileRegistered = false;
            boolean bootstrapPropertiesFileRegistered = false;
            boolean jvmOptionsFileRegistered = false;
            if (this.sourceDirectory.exists()) {
                this.registerAll(srcPath, executor);
                sourceDirRegistered = true;
            }
            if (this.testSourceDirectory.exists()) {
                this.registerAll(testSrcPath, executor);
                testSourceDirRegistered = true;
            }
            if (this.configDirectory.exists()) {
                this.registerAll(configPath, executor);
                configDirRegistered = true;
            }
            if (serverXmlFile != null && serverXmlFile.exists() && this.serverXmlFileParent.exists()) {
                Path serverXmlFilePath = this.serverXmlFileParent.getCanonicalFile().toPath();
                this.registerAll(serverXmlFilePath, executor);
                serverXmlFileRegistered = true;
            }
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists() && this.bootstrapPropertiesFileParent.exists()) {
                Path bootstrapPropertiesFilePath = this.bootstrapPropertiesFileParent.getCanonicalFile().toPath();
                this.registerAll(bootstrapPropertiesFilePath, executor);
                bootstrapPropertiesFileRegistered = true;
            }
            if (jvmOptionsFile != null && jvmOptionsFile.exists() && this.jvmOptionsFileParent.exists()) {
                Path jvmOptionsFilePath = this.jvmOptionsFileParent.getCanonicalFile().toPath();
                this.registerAll(jvmOptionsFilePath, executor);
                jvmOptionsFileRegistered = true;
            }
            HashMap<File, Boolean> resourceMap = new HashMap<File, Boolean>();
            for (File resourceDir : this.resourceDirs) {
                resourceMap.put(resourceDir, false);
                if (!resourceDir.exists()) continue;
                this.registerAll(resourceDir.getCanonicalFile().toPath(), executor);
                resourceMap.put(resourceDir, true);
            }
            this.registerSingleFile(buildFile, executor);
            if (this.propertyFilesMap != null) {
                for (File f : this.propertyFilesMap.keySet()) {
                    this.registerSingleFile(f, executor);
                }
            }
            this.initWatchLoop();
            while (true) {
                this.checkServerStopped();
                this.processJavaCompilation(outputDirectory, testOutputDirectory, executor, artifactPaths);
                if (!sourceDirRegistered && this.sourceDirectory.exists() && this.sourceDirectory.listFiles().length > 0) {
                    this.compile(this.sourceDirectory);
                    this.registerAll(srcPath, executor);
                    this.debug("Registering Java source directory: " + this.sourceDirectory);
                    sourceDirRegistered = true;
                } else if (sourceDirRegistered && !this.sourceDirectory.exists()) {
                    this.cleanTargetDir(outputDirectory);
                    sourceDirRegistered = false;
                }
                if (!testSourceDirRegistered && this.testSourceDirectory.exists() && this.testSourceDirectory.listFiles().length > 0) {
                    this.compile(this.testSourceDirectory);
                    this.registerAll(testSrcPath, executor);
                    this.debug("Registering Java test directory: " + this.testSourceDirectory);
                    this.runTestThread(false, executor, -1, false, false);
                    testSourceDirRegistered = true;
                } else if (testSourceDirRegistered && !this.testSourceDirectory.exists()) {
                    this.cleanTargetDir(testOutputDirectory);
                    testSourceDirRegistered = false;
                }
                if (!configDirRegistered && this.configDirectory.exists()) {
                    configDirRegistered = true;
                    if (serverXmlFile != null && !serverXmlFile.exists()) {
                        this.registerAll(configPath, executor);
                        this.debug("Registering configuration directory: " + this.configDirectory);
                    } else {
                        this.warn("The server configuration directory " + this.configDirectory + " has been added. Restart dev mode for it to take effect.");
                    }
                }
                if (!serverXmlFileRegistered && serverXmlFile != null && serverXmlFile.exists()) {
                    serverXmlFileRegistered = true;
                    this.debug("Server configuration file has been added: " + serverXmlFile);
                    this.warn("The server configuration file " + serverXmlFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!bootstrapPropertiesFileRegistered && bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                    bootstrapPropertiesFileRegistered = true;
                    this.debug("Bootstrap properties file has been added: " + bootstrapPropertiesFile);
                    this.warn("The bootstrap properties file " + bootstrapPropertiesFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!jvmOptionsFileRegistered && jvmOptionsFile != null && jvmOptionsFile.exists()) {
                    jvmOptionsFileRegistered = true;
                    this.debug("JVM Options file has been added: " + jvmOptionsFile);
                    this.warn("The JVM Options file " + jvmOptionsFile + " has been added. Restart dev mode for it to take effect.");
                }
                for (File resourceDir : this.resourceDirs) {
                    if (!((Boolean)resourceMap.get(resourceDir)).booleanValue() && resourceDir.exists()) {
                        this.registerAll(resourceDir.getCanonicalFile().toPath(), executor);
                        resourceMap.put(resourceDir, true);
                        continue;
                    }
                    if (!((Boolean)resourceMap.get(resourceDir)).booleanValue() || resourceDir.exists()) continue;
                    this.warn("The resource directory " + resourceDir + " was deleted.  Restart liberty:dev mode for it to take effect.");
                    resourceMap.put(resourceDir, false);
                }
                if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey wk = this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                        Watchable watchable = wk.watchable();
                        Path directory = (Path)watchable;
                        List<WatchEvent<?>> events = wk.pollEvents();
                        for (WatchEvent<?> event : events) {
                            if (this.trackingMode == FileTrackMode.NOT_SET) {
                                this.trackingMode = FileTrackMode.FILE_WATCHER;
                                this.disablePolling();
                            }
                            Path changed = (Path)event.context();
                            this.debug("Processing events for watched directory: " + directory);
                            File fileChanged = new File(directory.toString(), changed.toString());
                            if (this.ignoreFileOrDir(fileChanged)) continue;
                            this.debug("Changed: " + changed + "; " + event.kind());
                            ChangeType changeType = null;
                            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                                changeType = ChangeType.CREATE;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                                changeType = ChangeType.MODIFY;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                                changeType = ChangeType.DELETE;
                            }
                            this.processFileChanges(executor, fileChanged, outputDirectory, false, changeType);
                        }
                        boolean valid = wk.reset();
                        if (!valid) {
                            this.debug("WatchService key has been unregistered for " + directory);
                        }
                    }
                    catch (InterruptedException | NullPointerException exception) {
                        // empty catch block
                    }
                }
                if (this.trackingMode != FileTrackMode.POLLING && this.trackingMode != FileTrackMode.NOT_SET) continue;
                Iterator<FileAlterationObserver> iterator = this.newFileObservers;
                synchronized (iterator) {
                    this.consolidateFileObservers();
                }
                for (FileAlterationObserver observer : this.fileObservers) {
                    observer.checkAndNotify();
                }
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (Throwable throwable) {
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                }
                catch (IOException e) {
                    this.error("An error occurred attempting to close the file watcher. " + e.getMessage(), e);
                }
            }
            throw throwable;
        }
    }

    private void consolidateFileObservers() {
        this.fileObservers.addAll(this.newFileObservers);
        this.newFileObservers.removeAll(this.newFileObservers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSingleFile(final File registerFile, ThreadPoolExecutor executor) throws IOException {
        if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
            String parentPath = registerFile.getParentFile().getCanonicalPath();
            this.debug("Registering single file polling for " + registerFile.toString());
            Set<FileAlterationObserver> set = this.newFileObservers;
            synchronized (set) {
                HashSet<FileAlterationObserver> tempCombinedObservers = new HashSet<FileAlterationObserver>();
                tempCombinedObservers.addAll(this.fileObservers);
                tempCombinedObservers.addAll(this.newFileObservers);
                for (FileAlterationObserver observer : tempCombinedObservers) {
                    if (!parentPath.equals(observer.getDirectory().getCanonicalPath())) continue;
                    this.debug("Skipping single file polling for " + registerFile.toString() + " since its parent directory is already being observed");
                    return;
                }
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(registerFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(registerFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                try {
                    this.debug("Adding single file observer for: " + registerFile.toString());
                    this.addFileAlterationObserver(executor, parentPath, singleFileFilter);
                }
                catch (Exception e) {
                    this.error("Could not observe single file " + registerFile.toString(), e);
                }
            }
        }
        if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
            this.debug("Adding directory to WatchService " + registerFile.getParentFile().toPath() + " for single file " + registerFile.getName());
            registerFile.getParentFile().toPath().register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
        }
    }

    private void addFileAlterationObserver(ThreadPoolExecutor executor, String parentPath, FileFilter filter) throws Exception {
        FileAlterationObserver observer = this.getFileAlterationObserver(executor, parentPath, filter);
        observer.initialize();
        this.newFileObservers.add(observer);
    }

    private FileAlterationObserver getFileAlterationObserver(final ThreadPoolExecutor executor, final String parentPath, FileFilter filter) {
        FileAlterationObserver observer = new FileAlterationObserver(parentPath, filter);
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onDirectoryCreate(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.CREATE);
            }

            public void onDirectoryDelete(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.DELETE);
            }

            public void onDirectoryChange(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.MODIFY);
            }

            public void onFileCreate(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.CREATE);
            }

            public void onFileDelete(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.DELETE);
            }

            public void onFileChange(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.MODIFY);
            }

            private void onAlteration(ThreadPoolExecutor executor2, String parentPath2, File file, boolean isDirectory, ChangeType changeType) {
                if (DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey wk = null;
                        if (DevUtil.this.watcher != null) {
                            wk = DevUtil.this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                        }
                        List<WatchEvent<?>> events = null;
                        if (wk != null) {
                            events = wk.pollEvents();
                        }
                        if (events == null || events.isEmpty()) {
                            DevUtil.this.trackingMode = FileTrackMode.POLLING;
                            if (DevUtil.this.watcher != null) {
                                DevUtil.this.watcher.close();
                            }
                        } else {
                            DevUtil.this.trackingMode = FileTrackMode.FILE_WATCHER;
                            DevUtil.this.disablePolling();
                        }
                    }
                    catch (Exception e) {
                        DevUtil.this.error("An error occured attempting to retrieve the watch key or close the file watcher. " + e.getMessage(), e);
                    }
                }
                try {
                    DevUtil.this.processFileChanges(executor2, file, DevUtil.this.outputDirectory, isDirectory, changeType);
                }
                catch (Exception e) {
                    DevUtil.this.debug(e);
                    DevUtil.this.error("Could not file process changes for " + file.getAbsolutePath() + ": " + e.getMessage());
                }
            }
        });
        return observer;
    }

    private void processJavaCompilation(File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths) throws IOException, PluginExecutionException {
        boolean processTests;
        boolean processSources = System.currentTimeMillis() > this.lastJavaSourceChange + this.compileWaitMillis;
        boolean bl = processTests = System.currentTimeMillis() > this.lastJavaTestChange + this.compileWaitMillis;
        if (processSources) {
            if (!this.deleteJavaSources.isEmpty()) {
                this.debug("Deleting Java source files: " + this.deleteJavaSources);
                for (File file : this.deleteJavaSources) {
                    this.deleteJavaFile(file, outputDirectory, this.sourceDirectory);
                }
            }
            if (!this.recompileJavaSources.isEmpty() || this.triggerJavaSourceRecompile) {
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.recompileJavaSources.addAll(this.failedCompilationJavaSources);
                }
                if (this.recompileJavaSource(this.recompileJavaSources, artifactPaths, executor, outputDirectory, testOutputDirectory)) {
                    this.failedCompilationJavaSources.clear();
                } else {
                    this.failedCompilationJavaSources.addAll(this.recompileJavaSources);
                }
            }
            if (processTests) {
                if (!this.deleteJavaTests.isEmpty()) {
                    this.debug("Deleting Java test files: " + this.deleteJavaTests);
                    for (File file : this.deleteJavaTests) {
                        this.deleteJavaFile(file, testOutputDirectory, this.testSourceDirectory);
                    }
                }
                if (!this.recompileJavaTests.isEmpty() || this.triggerJavaTestRecompile) {
                    this.debug("Recompiling Java test files: " + this.recompileJavaTests);
                    if (!this.failedCompilationJavaTests.isEmpty()) {
                        this.recompileJavaTests.addAll(this.failedCompilationJavaTests);
                    }
                    if (this.recompileJavaTest(this.recompileJavaTests, artifactPaths, executor, outputDirectory, testOutputDirectory)) {
                        this.failedCompilationJavaTests.clear();
                    } else {
                        this.failedCompilationJavaTests.addAll(this.recompileJavaTests);
                    }
                }
            }
            if (!this.deleteJavaSources.isEmpty() && this.recompileJavaSources.isEmpty()) {
                int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            } else if (processTests && !this.deleteJavaTests.isEmpty() && this.recompileJavaTests.isEmpty()) {
                this.runTestThread(false, executor, -1, false, false);
            }
            this.deleteJavaSources.clear();
            this.recompileJavaSources.clear();
            this.triggerJavaTestRecompile = false;
            this.triggerJavaSourceRecompile = false;
            if (processTests) {
                this.deleteJavaTests.clear();
                this.recompileJavaTests.clear();
            }
        }
    }

    private void checkServerStopped() throws PluginScenarioException {
        if (this.serverThread.getState().equals((Object)Thread.State.TERMINATED)) {
            if (!this.devStop.get()) {
                throw new PluginScenarioException("The server has stopped. Exiting dev mode.");
            }
            throw new PluginScenarioException();
        }
    }

    private void initWatchLoop() throws IOException {
        this.recompileJavaSources = new HashSet<File>();
        this.recompileJavaTests = new HashSet<File>();
        this.deleteJavaSources = new HashSet<File>();
        this.deleteJavaTests = new HashSet<File>();
        this.failedCompilationJavaSources = new HashSet<File>();
        this.failedCompilationJavaTests = new HashSet<File>();
        this.lastJavaSourceChange = System.currentTimeMillis();
        this.lastJavaTestChange = System.currentTimeMillis();
        this.triggerJavaSourceRecompile = false;
        this.triggerJavaTestRecompile = false;
        if (this.sourceDirectory.exists()) {
            Collection allJavaSources = FileUtils.listFiles((File)this.sourceDirectory.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.recompileJavaSources.addAll(allJavaSources);
        }
        if (this.testSourceDirectory.exists()) {
            Collection allJavaTestSources = FileUtils.listFiles((File)this.testSourceDirectory.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.recompileJavaTests.addAll(allJavaTestSources);
        }
    }

    private void processFileChanges(ThreadPoolExecutor executor, File fileChanged, File outputDirectory, boolean isDirectory, ChangeType changeType) throws IOException, PluginExecutionException {
        boolean reloadedPropertyFile;
        ArrayList<File> javaFilesChanged;
        if (this.ignoreFileOrDir(fileChanged)) {
            return;
        }
        this.debug("Processing file changes for " + fileChanged + ", change type " + (Object)((Object)changeType));
        Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
        Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
        Path configPath = this.configDirectory.getCanonicalFile().toPath();
        Path directory = fileChanged.getParentFile().toPath();
        File resourceParent = null;
        for (File resourceDir : this.resourceDirs) {
            if (!directory.startsWith(resourceDir.getCanonicalFile().toPath())) continue;
            resourceParent = resourceDir;
            break;
        }
        if (fileChanged.isDirectory()) {
            if (changeType == ChangeType.CREATE) {
                this.registerAll(fileChanged.toPath(), executor);
            }
            return;
        }
        int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
        if (directory.startsWith(srcPath)) {
            javaFilesChanged = new ArrayList<File>();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java source file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                this.recompileJavaSources.add(fileChanged);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                this.deleteJavaSources.add(fileChanged);
            }
        } else if (directory.startsWith(testSrcPath)) {
            javaFilesChanged = new ArrayList();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java test file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                this.recompileJavaTests.add(fileChanged);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java test file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                this.deleteJavaTests.add(fileChanged);
            }
        } else if (directory.startsWith(configPath) && !this.isGeneratedConfigFile(fileChanged, this.configDirectory, this.serverDirectory)) {
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.copyConfigFolder(fileChanged, this.configDirectory, null);
                this.copyFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                if (changeType == ChangeType.CREATE) {
                    this.redeployApp();
                }
                if (fileChanged.getName().equals("server.env")) {
                    this.enableServerDebug(false);
                }
                if (fileChanged.getName().equals("bootstrap.properties") && this.bootstrapPropertiesFileParent == null || fileChanged.getName().equals("jvm.options") && this.jvmOptionsFileParent == null) {
                    this.restartServer();
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            } else if (changeType == ChangeType.DELETE) {
                this.info("Config file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                if (fileChanged.getName().equals("server.env")) {
                    this.enableServerDebug(false);
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            }
        } else if (this.serverXmlFileParent != null && directory.equals(this.serverXmlFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.serverXmlFile.getName())) {
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.copyConfigFolder(fileChanged, this.serverXmlFileParent, "server.xml");
                this.copyFile(fileChanged, this.serverXmlFileParent, this.serverDirectory, "server.xml");
                if (changeType == ChangeType.CREATE) {
                    this.redeployApp();
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            } else if (changeType == ChangeType.DELETE) {
                this.info("Config file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, "server.xml");
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            }
        } else if (this.bootstrapPropertiesFileParent != null && directory.equals(this.bootstrapPropertiesFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.bootstrapPropertiesFile.getName())) {
            this.restartServer();
        } else if (this.jvmOptionsFileParent != null && directory.equals(this.jvmOptionsFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.jvmOptionsFile.getName())) {
            this.restartServer();
        } else if (resourceParent != null && directory.startsWith(resourceParent.getCanonicalFile().toPath())) {
            this.debug("Resource dir: " + resourceParent.toString());
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.copyFile(fileChanged, resourceParent, outputDirectory, null);
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Resource file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, resourceParent, outputDirectory, null);
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            }
        } else if (fileChanged.equals(this.buildFile) && directory.startsWith(this.buildFile.getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
            boolean recompiledBuild = this.recompileBuildFile(this.buildFile, this.artifactPaths, executor);
            if (recompiledBuild) {
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.triggerJavaSourceRecompile = true;
                }
                if (!this.failedCompilationJavaTests.isEmpty()) {
                    this.triggerJavaTestRecompile = true;
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            }
        } else if (this.propertyFilesMap != null && this.propertyFilesMap.keySet().contains(fileChanged) && (reloadedPropertyFile = this.reloadPropertyFile(fileChanged))) {
            this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
        }
    }

    protected boolean isGeneratedConfigFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        return (fileChanged.getName().equals("bootstrap.properties") || fileChanged.getName().equals("jvm.options")) && this.isGeneratedTargetFile(fileChanged, srcDir, targetDir);
    }

    /*
     * Exception decompiling
     */
    private boolean isGeneratedTargetFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void copyConfigFolder(File fileChanged, File srcDir, String targetFileName) throws IOException {
        this.tempConfigPath = Files.createTempDirectory("tempConfig", new FileAttribute[0]);
        File tempConfig = this.tempConfigPath.toFile();
        this.debug("Temporary configuration folder created: " + tempConfig);
        FileUtils.copyDirectory((File)this.serverDirectory, (File)tempConfig, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                boolean skip = DevUtil.this.ignoreFileOrDir(pathname) || pathname.isDirectory() && (name.equals("workarea") || name.equals("logs"));
                return !skip;
            }
        }, (boolean)true);
        this.copyFile(fileChanged, srcDir, tempConfig, targetFileName);
        this.checkConfigFile(fileChanged, tempConfig);
        this.cleanUpTempConfig();
    }

    private boolean ignoreFileOrDir(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            for (String prefix : IGNORE_DIRECTORY_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        } else {
            for (String prefix : IGNORE_FILE_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
            for (String postfix : IGNORE_FILE_POSTFIXES) {
                if (!name.endsWith(postfix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        }
        return false;
    }

    public void copyFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        File targetResource = this.getTargetFile(fileChanged, srcDir, targetDir, targetFileName);
        try {
            FileUtils.copyFile((File)fileChanged, (File)targetResource);
            this.info("Copied file: " + fileChanged.getCanonicalPath() + " to: " + targetResource.getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            this.debug("Failed to copy file: " + fileChanged.getCanonicalPath());
        }
        catch (Exception ex) {
            this.debug(ex);
        }
    }

    private File getTargetFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        String relPath = fileChanged.getCanonicalPath().substring(fileChanged.getCanonicalPath().indexOf(srcDir.getCanonicalPath()) + srcDir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(fileChanged.getName())) + targetFileName;
        }
        File targetResource = new File(targetDir.getCanonicalPath() + relPath);
        return targetResource;
    }

    protected void deleteFile(File deletedFile, File dir, File targetDir, String targetFileName) throws IOException {
        File targetFile = this.getTargetFile(deletedFile, dir, targetDir, targetFileName);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("An error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The file " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ".");
            }
        }
    }

    protected void cleanTargetDir(File outputDirectory) {
        File[] fList = outputDirectory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                    file.delete();
                    this.info("Deleted Java class file: " + file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanTargetDir(file);
            }
        }
        if (outputDirectory.listFiles().length == 0) {
            outputDirectory.delete();
        }
    }

    protected void registerAll(Path start, final ThreadPoolExecutor executor) throws IOException {
        this.debug("Registering all files in directory: " + start.toString());
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult preVisitDirectory(final Path dir, BasicFileAttributes attrs) throws IOException {
                if (DevUtil.this.trackingMode == FileTrackMode.POLLING || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    Set set = DevUtil.this.newFileObservers;
                    synchronized (set) {
                        HashSet tempCombinedObservers = new HashSet();
                        tempCombinedObservers.addAll(DevUtil.this.fileObservers);
                        tempCombinedObservers.addAll(DevUtil.this.newFileObservers);
                        for (FileAlterationObserver observer : tempCombinedObservers) {
                            if (!dir.equals(observer.getDirectory().getCanonicalFile().toPath())) continue;
                            DevUtil.this.debug("Skipping subdirectory " + dir.toString() + " since it already being observed");
                            return FileVisitResult.CONTINUE;
                        }
                        FileFilter singleDirectoryFilter = new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                try {
                                    if (dir.equals(file.getParentFile().getCanonicalFile().toPath())) {
                                        return true;
                                    }
                                }
                                catch (IOException e) {
                                    return false;
                                }
                                return false;
                            }
                        };
                        try {
                            DevUtil.this.debug("Adding subdirectory to file observers: " + dir.toString());
                            DevUtil.this.addFileAlterationObserver(executor, dir.toString(), singleDirectoryFilter);
                        }
                        catch (Exception e) {
                            DevUtil.this.error("Could not observe directory " + dir.toString(), e);
                        }
                    }
                }
                if (DevUtil.this.trackingMode == FileTrackMode.FILE_WATCHER || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    DevUtil.this.debug("Adding subdirectory to WatchService: " + dir.toString());
                    dir.register(DevUtil.this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected void deleteJavaFile(File fileChanged, File classesDir, File compileSourceRoot) throws IOException {
        String relPath;
        String fileName = fileChanged.getName();
        File parentFile = fileChanged.getParentFile();
        boolean javaFile = fileName.endsWith(".java");
        if (javaFile) {
            fileName = fileName.substring(0, fileChanged.getName().indexOf(".java"));
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName + ".class";
        } else {
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName;
        }
        File targetFile = new File(classesDir.getCanonicalPath() + relPath);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The target directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("There was an error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The java class " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ". ");
            }
        } else {
            this.warn("File deleted but could not find corresponding file or folder in the target directory: " + fileChanged.getCanonicalPath() + ".");
        }
    }

    protected boolean recompileJavaSource(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, false, outputDirectory, testOutputDirectory);
    }

    protected boolean recompileJavaTest(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, true, outputDirectory, testOutputDirectory);
    }

    protected boolean recompileJava(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, boolean tests, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        try {
            boolean compileResult;
            int messageOccurrences = this.countApplicationUpdatedMessages();
            if (this.useBuildRecompile) {
                compileResult = this.compile(tests ? this.testSourceDirectory : this.sourceDirectory);
            } else {
                File classesDir;
                File file = classesDir = tests ? testOutputDirectory : outputDirectory;
                if (!classesDir.exists()) {
                    if (!classesDir.mkdirs()) {
                        throw new PluginExecutionException("The classes output directory " + classesDir.getAbsolutePath() + " does not exist and cannot be created.");
                    }
                    if (classesDir.exists() && Objects.equals(classesDir.getCanonicalFile(), outputDirectory.getCanonicalFile())) {
                        this.redeployApp();
                    }
                }
                ArrayList<String> optionList = new ArrayList<String>(Arrays.asList(DEFAULT_COMPILER_OPTIONS));
                ArrayList<File> outputDirs = new ArrayList<File>();
                if (tests) {
                    outputDirs.add(outputDirectory);
                    outputDirs.add(testOutputDirectory);
                } else {
                    outputDirs.add(outputDirectory);
                }
                Set<File> classPathElems = this.getClassPath(artifactPaths, outputDirs);
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                fileManager.setLocation(StandardLocation.CLASS_PATH, classPathElems);
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesDir));
                HashSet<JavaFileObject> compilationUnits = new HashSet<JavaFileObject>();
                for (File file2 : javaFilesChanged) {
                    if (file2.exists() && file2.isFile()) {
                        for (JavaFileObject javaFileObject : fileManager.getJavaFileObjects(file2)) {
                            compilationUnits.add(javaFileObject);
                        }
                        continue;
                    }
                    this.debug("The Java file " + file2 + " does not exist and will not be compiled.");
                }
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, optionList, null, compilationUnits);
                compileResult = task.call();
            }
            if (compileResult) {
                if (tests) {
                    this.info("Tests compilation was successful.");
                } else {
                    this.info("Source compilation was successful.");
                }
                if (tests) {
                    this.runTestThread(false, executor, -1, false, false);
                } else {
                    this.runTestThread(true, executor, messageOccurrences, false, false);
                }
                return true;
            }
            if (tests) {
                this.info("Tests compilation had errors.");
            } else {
                this.info("Source compilation had errors.");
            }
            return false;
        }
        catch (Exception e) {
            this.debug("Error compiling java files", e);
            return false;
        }
    }

    protected Set<File> getClassPath(List<String> artifactPaths, List<File> outputDirs) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader c = Thread.currentThread().getContextClassLoader(); c != null; c = c.getParent()) {
            if (!(c instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)c).getURLs()));
        }
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (URL url : urls) {
            toParse.add(new File(url.getPath()).getCanonicalPath());
        }
        for (String artifactPath : artifactPaths) {
            toParse.add(new File(artifactPath).getCanonicalPath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.addAll(outputDirs);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory()) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getCanonicalPath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        return classPathElements;
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean forceSkipUTs, boolean manualInvocation) {
        try {
            if (manualInvocation || this.hotTests) {
                executor.execute(new TestJob(waitForApplicationUpdate, messageOccurrences, executor, forceSkipUTs, manualInvocation));
            }
        }
        catch (RejectedExecutionException e) {
            this.debug("Cannot add thread since max threads reached", e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setLibertyDebugPort(int libertyDebugPort) {
        this.libertyDebugPort = libertyDebugPort;
    }

    private boolean reloadPropertyFile(File propertyFile) throws PluginExecutionException {
        Properties properties = this.readPropertiesFromFile(propertyFile);
        if (!Objects.equals(properties, this.propertyFilesMap.get(propertyFile))) {
            this.debug("Properties file " + propertyFile.getAbsolutePath() + " has changed. Restarting server...");
            this.propertyFilesMap.put(propertyFile, properties);
            this.restartServer();
            return true;
        }
        this.debug("No changes detected in properties file " + propertyFile.getAbsolutePath());
        return false;
    }

    public void setPropertyFiles(List<File> propertyFiles) {
        if (propertyFiles == null) {
            return;
        }
        if (this.propertyFilesMap == null) {
            this.propertyFilesMap = new HashMap<File, Properties>(propertyFiles.size());
        }
        for (File propertyFile : propertyFiles) {
            Properties properties = this.readPropertiesFromFile(propertyFile);
            this.propertyFilesMap.put(propertyFile, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesFromFile(File propertyFile) {
        Properties properties = null;
        if (propertyFile.exists()) {
            InputStream inputStream = null;
            try {
                this.debug("Loading properties from file: " + propertyFile);
                inputStream = new FileInputStream(propertyFile);
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (IOException e) {
                this.error("Could not read properties file " + propertyFile.getAbsolutePath(), e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public class TestJob
    implements Runnable {
        private boolean waitForApplicationUpdate;
        private int messageOccurrences;
        private ThreadPoolExecutor executor;
        private boolean forceSkipUTs;
        private boolean manualInvocation;

        public TestJob(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs, boolean manualInvocation) {
            this.waitForApplicationUpdate = waitForApplicationUpdate;
            this.messageOccurrences = messageOccurrences;
            this.executor = executor;
            this.forceSkipUTs = forceSkipUTs;
            this.manualInvocation = manualInvocation;
        }

        @Override
        public void run() {
            try {
                DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, this.forceSkipUTs);
            }
            finally {
                DevUtil.this.runHotkeyReaderThread(this.executor);
            }
        }

        public boolean isManualInvocation() {
            return this.manualInvocation;
        }
    }

    private static enum ChangeType {
        CREATE,
        DELETE,
        MODIFY;

    }

    private class HotkeyReader
    implements Runnable {
        private Scanner scanner;
        private ThreadPoolExecutor executor;
        private boolean shutdown = false;

        public HotkeyReader(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void run() {
            DevUtil.this.debug("Running hotkey reader thread");
            this.scanner = new Scanner(System.in);
            try {
                this.readInput();
            }
            finally {
                this.scanner.close();
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readInput() {
            if (this.scanner.hasNextLine()) {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.notify();
                }
                while (!this.shutdown) {
                    DevUtil.this.debug("Waiting for Enter key to run tests");
                    if (this.scanner.hasNextLine()) {
                        String line = this.scanner.nextLine();
                        if (line != null && (line.trim().equalsIgnoreCase("q") || line.trim().equalsIgnoreCase("quit") || line.trim().equalsIgnoreCase("exit"))) {
                            DevUtil.this.debug("Detected exit command");
                            DevUtil.this.runShutdownHook(this.executor);
                            continue;
                        }
                        DevUtil.this.debug("Detected Enter key. Running tests...");
                        DevUtil.this.runTestThread(false, this.executor, -1, false, true);
                        continue;
                    }
                    break;
                }
            } else {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.set(true);
                    DevUtil.this.inputUnavailable.notify();
                }
            }
            DevUtil.this.debug("Hotkey reader thread was shut down");
        }
    }

    private static enum FileTrackMode {
        NOT_SET,
        FILE_WATCHER,
        POLLING;

    }
}

