/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.codeactions.AddAttribute;
import io.openliberty.tools.langserver.lemminx.codeactions.CreateFile;
import io.openliberty.tools.langserver.lemminx.codeactions.EditAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class LibertyCodeActionParticipant
implements ICodeActionParticipant {
    private final Map<String, ICodeActionParticipant> codeActionParticipants = new HashMap<String, ICodeActionParticipant>();

    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        if (diagnostic == null || diagnostic.getCode() == null || !diagnostic.getCode().isLeft()) {
            return;
        }
        this.registerCodeActions();
        ICodeActionParticipant participant = this.codeActionParticipants.get(diagnostic.getCode().getLeft());
        if (participant != null) {
            participant.doCodeAction(request, codeActions, cancelChecker);
        }
    }

    private void registerCodeActions() {
        if (this.codeActionParticipants.isEmpty()) {
            this.codeActionParticipants.put("missing_file", new CreateFile());
            this.codeActionParticipants.put("not_optional", new EditAttribute());
            this.codeActionParticipants.put("implicit_not_optional", new AddAttribute());
        }
    }
}

