/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Range;

public class LibertyDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private static final Logger LOGGER = Logger.getLogger(LibertyDocumentLinkParticipant.class.getName());

    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        if (!LibertyUtils.isConfigXMLFile(document)) {
            return;
        }
        List nodes = document.getDocumentElement().getChildren();
        List includeDomNodes = nodes.stream().filter(n -> n.getNodeName().equals("include")).collect(Collectors.toList());
        for (DOMNode includeNode : includeDomNodes) {
            DOMAttr includeAttr = includeNode.getAttributeNode("location");
            String locAttr = includeAttr.getValue();
            if (!locAttr.endsWith(".xml") || locAttr.startsWith("http") || locAttr.contains("$")) continue;
            Range linkRange = XMLPositionUtility.selectAttributeValue((DOMAttr)includeAttr);
            try {
                String location = LibertyDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), includeAttr.getValue());
                DocumentLink link = new DocumentLink(linkRange, location);
                links.add(link);
            }
            catch (URI.MalformedURIException e) {
                LOGGER.log(Level.SEVERE, "Creation of document link failed", e);
            }
        }
    }

    private static String getResolvedLocation(String documentURI, String location) throws URI.MalformedURIException {
        if (location == null) {
            return null;
        }
        return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
    }
}

