/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.LibertyCodeActionParticipant;
import io.openliberty.tools.langserver.lemminx.LibertyCompletionParticipant;
import io.openliberty.tools.langserver.lemminx.LibertyDiagnosticParticipant;
import io.openliberty.tools.langserver.lemminx.LibertyDocumentLinkParticipant;
import io.openliberty.tools.langserver.lemminx.LibertyHoverParticipant;
import io.openliberty.tools.langserver.lemminx.LibertyXSDURIResolver;
import io.openliberty.tools.langserver.lemminx.services.LibertyProjectsManager;
import io.openliberty.tools.langserver.lemminx.services.SettingsService;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;
import org.eclipse.lsp4j.InitializeParams;

public class LibertyExtension
implements IXMLExtension {
    private static final Logger LOGGER = Logger.getLogger(LibertyExtension.class.getName());
    private URIResolverExtension xsdResolver;
    private ICompletionParticipant completionParticipant;
    private IHoverParticipant hoverParticipant;
    private IDiagnosticsParticipant diagnosticsParticipant;
    private ICodeActionParticipant codeActionsParticipant;
    private IDocumentLinkParticipant documentLinkParticipant;

    public void start(InitializeParams initializeParams, XMLExtensionsRegistry xmlExtensionsRegistry) {
        try {
            List folders = initializeParams.getWorkspaceFolders();
            if (folders != null) {
                LibertyProjectsManager.getInstance().setWorkspaceFolders(folders);
            }
        }
        catch (NullPointerException e) {
            LOGGER.warning("Could not get workspace folders: " + e.toString());
        }
        this.xsdResolver = new LibertyXSDURIResolver();
        xmlExtensionsRegistry.getResolverExtensionManager().registerResolver(this.xsdResolver);
        this.completionParticipant = new LibertyCompletionParticipant();
        xmlExtensionsRegistry.registerCompletionParticipant(this.completionParticipant);
        this.hoverParticipant = new LibertyHoverParticipant();
        xmlExtensionsRegistry.registerHoverParticipant(this.hoverParticipant);
        this.diagnosticsParticipant = new LibertyDiagnosticParticipant();
        xmlExtensionsRegistry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
        this.codeActionsParticipant = new LibertyCodeActionParticipant();
        xmlExtensionsRegistry.registerCodeActionParticipant(this.codeActionsParticipant);
        this.documentLinkParticipant = new LibertyDocumentLinkParticipant();
        xmlExtensionsRegistry.registerDocumentLinkParticipant(this.documentLinkParticipant);
    }

    public void stop(XMLExtensionsRegistry xmlExtensionsRegistry) {
        LibertyProjectsManager.getInstance().cleanUpTempDirs();
        LibertyProjectsManager.getInstance().cleanInstance();
        xmlExtensionsRegistry.getResolverExtensionManager().unregisterResolver(this.xsdResolver);
        xmlExtensionsRegistry.unregisterCompletionParticipant(this.completionParticipant);
        xmlExtensionsRegistry.unregisterHoverParticipant(this.hoverParticipant);
        xmlExtensionsRegistry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
        xmlExtensionsRegistry.unregisterCodeActionParticipant(this.codeActionsParticipant);
    }

    public void doSave(ISaveContext saveContext) {
        if (saveContext.getType() == ISaveContext.SaveContextType.SETTINGS) {
            Object xmlSettings = saveContext.getSettings();
            SettingsService.getInstance().updateLibertySettings(xmlSettings);
            LOGGER.fine("Liberty XML settings updated");
        }
    }
}

