/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.models.feature.Feature;
import io.openliberty.tools.langserver.lemminx.services.FeatureService;
import io.openliberty.tools.langserver.lemminx.services.SettingsService;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.util.Optional;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.IHoverRequest;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;

public class LibertyHoverParticipant
implements IHoverParticipant {
    public Hover onAttributeName(IHoverRequest request) {
        return null;
    }

    public Hover onAttributeValue(IHoverRequest request) {
        return null;
    }

    public Hover onTag(IHoverRequest request) {
        return null;
    }

    public Hover onText(IHoverRequest request) {
        if (!LibertyUtils.isConfigXMLFile(request.getXMLDocument())) {
            return null;
        }
        DOMElement parentElement = request.getParentElement();
        if (parentElement == null || parentElement.getTagName() == null) {
            return null;
        }
        if ("feature".equals(parentElement.getTagName())) {
            String featureName = request.getNode().getTextContent().trim();
            return this.getHoverFeatureDescription(featureName, request.getXMLDocument());
        }
        return null;
    }

    private Hover getHoverFeatureDescription(String featureName, DOMDocument domDocument) {
        String libertyRuntimeVersionInfo = LibertyUtils.getRuntimeAndVersionInfo(domDocument);
        String libertyVersion = LibertyUtils.getVersionFromInfo(libertyRuntimeVersionInfo);
        String libertyRuntime = LibertyUtils.getRuntimeFromInfo(libertyRuntimeVersionInfo);
        int requestDelay = SettingsService.getInstance().getRequestDelay();
        Optional<Feature> feature = FeatureService.getInstance().getFeature(featureName, libertyVersion, libertyRuntime, requestDelay, domDocument.getDocumentURI());
        if (feature.isPresent()) {
            return new Hover(new MarkupContent("plaintext", feature.get().getShortDescription()));
        }
        return null;
    }
}

