/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.services.DockerService;
import io.openliberty.tools.langserver.lemminx.services.LibertyProjectsManager;
import io.openliberty.tools.langserver.lemminx.services.LibertyWorkspace;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.IExternalGrammarLocationProvider;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class LibertyXSDURIResolver
implements URIResolverExtension,
IExternalGrammarLocationProvider {
    private static final Logger LOGGER = Logger.getLogger(LibertyXSDURIResolver.class.getName());
    private static final String XSD_RESOURCE_URL = "https://github.com/OpenLiberty/liberty-language-server/blob/master/lemminx-liberty/src/main/resources/schema/xsd/liberty/server.xsd";
    private static final String XSD_CLASSPATH_LOCATION = "/schema/xsd/liberty/server.xsd";
    public static final CacheResourcesManager.ResourceToDeploy SERVER_XSD_RESOURCE = new CacheResourcesManager.ResourceToDeploy("https://github.com/OpenLiberty/liberty-language-server/blob/master/lemminx-liberty/src/main/resources/schema/xsd/liberty/server.xsd", "/schema/xsd/liberty/server.xsd");

    public String resolve(String baseLocation, String publicId, String systemId) {
        if (LibertyUtils.isConfigXMLFile(baseLocation)) {
            try {
                String serverXMLUri = URI.create(baseLocation).toString();
                LibertyWorkspace libertyWorkspace = LibertyProjectsManager.getInstance().getWorkspaceFolder(serverXMLUri);
                if (libertyWorkspace != null) {
                    LibertyUtils.getVersion(serverXMLUri);
                    LibertyUtils.getRuntimeInfo(serverXMLUri);
                    String serverSchemaUri = null;
                    if (libertyWorkspace.isLibertyInstalled()) {
                        Path schemaGenJarPath = LibertyUtils.findFileInWorkspace(libertyWorkspace, Paths.get("bin", "tools", "ws-schemagen.jar"));
                        if (schemaGenJarPath != null) {
                            serverSchemaUri = this.generateServerSchemaXsd(libertyWorkspace, schemaGenJarPath);
                        }
                    } else if (libertyWorkspace.isContainerAlive()) {
                        DockerService docker = DockerService.getInstance();
                        serverSchemaUri = docker.generateServerSchemaXsdFromContainer(libertyWorkspace);
                    }
                    if (serverSchemaUri != null && !serverSchemaUri.isEmpty()) {
                        return serverSchemaUri;
                    }
                }
                Path serverXSDFile = CacheResourcesManager.getResourceCachePath((CacheResourcesManager.ResourceToDeploy)SERVER_XSD_RESOURCE);
                LOGGER.info("Using cached Liberty schema file located at: " + serverXSDFile.toString());
                return serverXSDFile.toUri().toString();
            }
            catch (Exception e) {
                LOGGER.severe("Error: Unable to deploy server.xsd to lemminx cache.");
                e.printStackTrace();
            }
        }
        return null;
    }

    public Map<String, String> getExternalGrammarLocation(URI fileURI) {
        String xsdFile = this.resolve(fileURI.toString(), null, null);
        if (xsdFile == null) {
            return null;
        }
        HashMap<String, String> externalGrammar = new HashMap<String, String>();
        externalGrammar.put("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", xsdFile);
        return externalGrammar;
    }

    private String generateServerSchemaXsd(LibertyWorkspace libertyWorkspace, Path schemaGenJarPath) {
        File tempDir = LibertyUtils.getTempDir(libertyWorkspace);
        if (tempDir == null) {
            LOGGER.warning("Could not create a temporary directory for generating the schema file. The cached schema file will be used for the current workspace: " + libertyWorkspace.getWorkspaceString());
            return null;
        }
        File xsdDestFile = new File(tempDir, "server.xsd");
        if (libertyWorkspace.getLibertyVersion() != null && !libertyWorkspace.getLibertyVersion().isEmpty() && libertyWorkspace.getLibertyRuntime() != null && !libertyWorkspace.getLibertyRuntime().isEmpty()) {
            xsdDestFile = new File(tempDir, libertyWorkspace.getLibertyRuntime() + "-" + libertyWorkspace.getLibertyVersion() + ".xsd");
        }
        if (!xsdDestFile.exists()) {
            try {
                LOGGER.info("Generating schema file from: " + schemaGenJarPath.toString());
                String xsdDestPath = xsdDestFile.getCanonicalPath();
                LOGGER.info("Generating schema file at: " + xsdDestPath);
                ProcessBuilder pb = new ProcessBuilder("java", "-jar", schemaGenJarPath.toAbsolutePath().toString(), xsdDestPath);
                pb.directory(tempDir);
                pb.redirectErrorStream(true);
                pb.redirectOutput(new File(tempDir, "schemagen.log"));
                Process proc = pb.start();
                if (!proc.waitFor(30L, TimeUnit.SECONDS)) {
                    proc.destroy();
                    LOGGER.warning("Exceeded 30 second timeout during schema file generation. Using cached schema.xsd file.");
                    return null;
                }
                LOGGER.info("Caching schema file with URI: " + xsdDestFile.toURI().toString());
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                LOGGER.warning("Due to an exception during schema file generation, a cached schema file will be used.");
                return null;
            }
        }
        LOGGER.info("Using schema file at: " + xsdDestFile.toURI().toString());
        return xsdDestFile.toURI().toString();
    }
}

