/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.codeactions;

import io.openliberty.tools.langserver.lemminx.LibertyExtension;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class CreateFile
implements ICodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(LibertyExtension.class.getName());
    private static final String EMPTY_SERVER_CONFIG = "<server>" + System.lineSeparator() + "</server>";

    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        try {
            File parentFile = LibertyUtils.getDocumentAsFile(document).getParentFile();
            String locationValue = document.findNodeAt(document.offsetAt(diagnostic.getRange().getEnd())).getAttribute("location");
            codeActions.add(CodeActionFactory.createFile((String)"Create the missing server config file relative from this file.", (String)new File(parentFile, locationValue).getCanonicalPath(), (String)EMPTY_SERVER_CONFIG, (Diagnostic)diagnostic));
        }
        catch (Exception e) {
            LOGGER.warning("Could not generate code action for create file: " + e);
        }
    }
}

