/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.services;

import io.openliberty.tools.langserver.lemminx.services.LibertyWorkspace;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.WorkspaceFolder;

public class LibertyProjectsManager {
    private static final Logger LOGGER = Logger.getLogger(LibertyProjectsManager.class.getName());
    private static final LibertyProjectsManager INSTANCE = new LibertyProjectsManager();
    private static final String URI_SEPARATOR = "/";
    private Map<String, LibertyWorkspace> libertyWorkspaceFolders = new HashMap<String, LibertyWorkspace>();

    public static LibertyProjectsManager getInstance() {
        return INSTANCE;
    }

    private LibertyProjectsManager() {
    }

    public void setWorkspaceFolders(List<WorkspaceFolder> workspaceFolders) {
        for (WorkspaceFolder folder : workspaceFolders) {
            String workspaceUriString = folder.getUri();
            String normalizedUriString = workspaceUriString.replace("///", URI_SEPARATOR);
            if (this.libertyWorkspaceFolders.containsKey(normalizedUriString)) {
                LOGGER.info("Skipping already added Liberty workspace: " + normalizedUriString);
                continue;
            }
            URI workspaceUri = URI.create(normalizedUriString);
            Path workspacePath = Paths.get(workspaceUri);
            Path serverXmlPath = Paths.get("src", "main", "liberty", "config", "server.xml");
            List<Path> serverXmlFiles = null;
            try {
                serverXmlFiles = LibertyUtils.findFilesInDirectory(workspacePath, serverXmlPath);
            }
            catch (IOException e) {
                LOGGER.warning("Received exception while searching for server.xml files in: " + workspacePath + " exception: " + e.getMessage());
            }
            if (serverXmlFiles == null || serverXmlFiles.isEmpty() || serverXmlFiles.size() == 1) {
                LOGGER.info("Adding Liberty workspace: " + normalizedUriString);
                LibertyWorkspace libertyWorkspace = new LibertyWorkspace(normalizedUriString);
                this.libertyWorkspaceFolders.put(normalizedUriString, libertyWorkspace);
                continue;
            }
            boolean addedSubModule = false;
            List childrenDirs = null;
            String lastChildDirPath = null;
            try {
                childrenDirs = Files.walk(workspacePath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path nextChildDir : childrenDirs) {
                    lastChildDirPath = nextChildDir.toUri().toString().replace("///", URI_SEPARATOR);
                    if (nextChildDir.equals(workspacePath)) continue;
                    if (this.libertyWorkspaceFolders.containsKey(lastChildDirPath)) {
                        addedSubModule = true;
                        continue;
                    }
                    List<Path> serverXmlFile = LibertyUtils.findFilesInDirectory(nextChildDir, serverXmlPath);
                    if (serverXmlFile.isEmpty()) continue;
                    LibertyWorkspace libertyWorkspace = new LibertyWorkspace(lastChildDirPath);
                    this.libertyWorkspaceFolders.put(lastChildDirPath, libertyWorkspace);
                    addedSubModule = true;
                    LOGGER.info("Adding Liberty workspace for sub-module: " + lastChildDirPath);
                }
            }
            catch (IOException e) {
                LOGGER.warning("Received exception while processing workspace folder: " + lastChildDirPath);
            }
            if (addedSubModule) continue;
            LibertyWorkspace libertyWorkspace = new LibertyWorkspace(normalizedUriString);
            this.libertyWorkspaceFolders.put(normalizedUriString, libertyWorkspace);
            LOGGER.info("Adding Liberty workspace by default: " + normalizedUriString);
        }
    }

    public Collection<LibertyWorkspace> getLibertyWorkspaceFolders() {
        return this.libertyWorkspaceFolders.values();
    }

    public String getLibertyVersion(LibertyWorkspace libertyWorkspace) {
        return libertyWorkspace.getLibertyVersion();
    }

    public LibertyWorkspace getWorkspaceFolder(String serverXMLUri) {
        String normalizeUri = serverXMLUri.replace("///", URI_SEPARATOR);
        for (LibertyWorkspace folder : LibertyProjectsManager.getInstance().getLibertyWorkspaceFolders()) {
            Object workspaceDirUri = folder.getWorkspaceString();
            if (workspaceDirUri != null && !((String)workspaceDirUri).endsWith(URI_SEPARATOR)) {
                workspaceDirUri = (String)workspaceDirUri + URI_SEPARATOR;
            }
            if (!normalizeUri.contains((CharSequence)workspaceDirUri)) continue;
            return folder;
        }
        LOGGER.warning("Could not find LibertyWorkspace for file: " + serverXMLUri);
        return null;
    }

    public void cleanUpTempDirs() {
        for (LibertyWorkspace folder : LibertyProjectsManager.getInstance().getLibertyWorkspaceFolders()) {
            URI workspaceFolderURI = folder.getWorkspaceURI();
            try {
                if (workspaceFolderURI == null) continue;
                Path rootPath = Paths.get(workspaceFolderURI);
                List matchingFiles = Files.walk(rootPath, new FileVisitOption[0]).filter(p -> Files.isDirectory(p, new LinkOption[0]) && p.getFileName().endsWith(".libertyls")).collect(Collectors.toList());
                for (Path libertylsDir : matchingFiles) {
                    if (libertylsDir.toFile().delete()) continue;
                    LOGGER.warning("Could not delete " + libertylsDir);
                }
            }
            catch (IOException e) {
                LOGGER.warning("Could not clean up /.libertyls directory: " + e.getMessage());
            }
        }
    }

    public void cleanInstance() {
        this.libertyWorkspaceFolders = new HashMap<String, LibertyWorkspace>();
    }
}

