/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.services;

import io.openliberty.tools.langserver.lemminx.models.feature.Feature;
import io.openliberty.tools.langserver.lemminx.models.settings.DevcMetadata;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class LibertyWorkspace {
    private static final Logger LOGGER = Logger.getLogger(LibertyWorkspace.class.getName());
    private String workspaceFolderURI;
    private String libertyVersion;
    private String libertyRuntime;
    private boolean isLibertyInstalled;
    private List<Feature> installedFeatureList;
    private Set<String> configFiles;
    private String containerName;
    private boolean containerAlive;

    public LibertyWorkspace(String workspaceFolderURI) {
        this.workspaceFolderURI = workspaceFolderURI;
        this.libertyVersion = null;
        this.libertyRuntime = null;
        this.isLibertyInstalled = false;
        this.installedFeatureList = new ArrayList<Feature>();
        this.containerName = null;
        this.containerAlive = false;
        this.configFiles = new HashSet<String>();
        this.initConfigFileList();
    }

    public String getWorkspaceString() {
        return this.workspaceFolderURI;
    }

    public URI getWorkspaceURI() {
        return URI.create(this.workspaceFolderURI);
    }

    public File getDir() {
        return new File(URI.create(this.getWorkspaceString()).getPath());
    }

    public void setLibertyVersion(String libertyVersion) {
        this.libertyVersion = libertyVersion;
    }

    public String getLibertyVersion() {
        return this.libertyVersion;
    }

    public void setLibertyRuntime(String libertyRuntime) {
        this.libertyRuntime = libertyRuntime;
    }

    public String getLibertyRuntime() {
        return this.libertyRuntime;
    }

    public void setLibertyInstalled(boolean isLibertyInstalled) {
        this.isLibertyInstalled = isLibertyInstalled;
    }

    public boolean isLibertyInstalled() {
        return this.isLibertyInstalled;
    }

    public List<Feature> getInstalledFeatureList() {
        return this.installedFeatureList;
    }

    public void setInstalledFeatureList(List<Feature> installedFeatureList) {
        this.installedFeatureList = installedFeatureList;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public boolean isContainerAlive() {
        return this.containerAlive;
    }

    public void setContainerAlive(boolean containerAlive) {
        this.containerAlive = containerAlive;
    }

    public Path findDevcMetadata() {
        try {
            List metaDataList = Files.find(Paths.get(this.getWorkspaceURI()), Integer.MAX_VALUE, (filePath, fileAttributes) -> filePath.toString().endsWith("-liberty-devc-metadata.xml"), new FileVisitOption[0]).collect(Collectors.toList());
            for (Path metaDataFile : metaDataList) {
                DevcMetadata devcMetadata = LibertyWorkspace.unmarshalDevcMetadataFile(metaDataFile);
                if (!devcMetadata.isContainerAlive()) continue;
                this.setContainerName(devcMetadata.getContainerName());
                this.setContainerAlive(true);
                return metaDataFile;
            }
            this.setContainerAlive(false);
            return null;
        }
        catch (IOException e) {
            LOGGER.warning("Workspace URI does not exist: " + e.getMessage());
            return null;
        }
    }

    public static DevcMetadata unmarshalDevcMetadataFile(Path devcMetadataFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(DevcMetadata.class);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (DevcMetadata)jaxbUnmarshaller.unmarshal(devcMetadataFile.toFile());
        }
        catch (JAXBException e) {
            return null;
        }
    }

    private void initConfigFileList() {
        try {
            List serverXmlList = Files.find(Paths.get(this.getWorkspaceURI()), Integer.MAX_VALUE, (filePath, fileAttributes) -> LibertyUtils.isServerXMLFile(filePath.toString()), new FileVisitOption[0]).collect(Collectors.toList());
            for (Path serverXml : serverXmlList) {
                this.scanForConfigLocations(serverXml);
            }
        }
        catch (IOException e) {
            LOGGER.warning("Workspace URI does not exist: " + e.getMessage());
        }
    }

    private void scanForConfigLocations(Path filePath) {
        try {
            String workspacePath = this.getDir().getCanonicalPath();
            String content = new String(Files.readAllBytes(filePath));
            String regex = "<include[^<]+location=[\"'](.+)[\"'][\\s\\S]+?/>";
            Matcher m = Pattern.compile(regex).matcher(content);
            while (m.find()) {
                String locationFilePath = new File(filePath.getParent().toFile(), m.group(1)).getCanonicalPath();
                if (!locationFilePath.startsWith(workspacePath)) continue;
                this.configFiles.add(locationFilePath);
            }
        }
        catch (IOException workspacePath) {
        }
        catch (Exception e) {
            LOGGER.warning("Exception received when scanning for config files: " + e.getMessage());
        }
    }

    public void addConfigFile(String fileString) {
        this.configFiles.add(fileString);
    }

    public boolean hasConfigFile(String fileString) {
        try {
            fileString = fileString.startsWith("file:") ? new File(URI.create(fileString)).getCanonicalPath() : new File(fileString).getCanonicalPath();
            return this.configFiles.contains(fileString);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.workspaceFolderURI;
    }
}

