/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.util;

import io.openliberty.tools.langserver.lemminx.models.feature.Feature;
import io.openliberty.tools.langserver.lemminx.models.settings.DevcMetadata;
import io.openliberty.tools.langserver.lemminx.services.DockerService;
import io.openliberty.tools.langserver.lemminx.services.LibertyProjectsManager;
import io.openliberty.tools.langserver.lemminx.services.LibertyWorkspace;
import io.openliberty.tools.langserver.lemminx.services.SettingsService;
import io.openliberty.tools.langserver.lemminx.util.LibertyConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.dom.DOMDocument;

public class LibertyUtils {
    private static final Logger LOGGER = Logger.getLogger(LibertyUtils.class.getName());
    private static Thread thread;

    private LibertyUtils() {
    }

    public static boolean isServerXMLFile(String filePath) {
        return filePath.endsWith("/server.xml");
    }

    public static boolean isServerXMLFile(DOMDocument file) {
        return file.getDocumentURI().endsWith("/server.xml");
    }

    public static boolean isConfigDirFile(String filePath) {
        return filePath.contains(LibertyConstants.WLP_USER_CONFIG_DIR) || filePath.contains(LibertyConstants.SERVER_CONFIG_DROPINS_DEFAULTS) || filePath.contains(LibertyConstants.SERVER_CONFIG_DROPINS_OVERRIDES);
    }

    public static boolean isConfigXMLFile(String filePath) {
        return LibertyUtils.isServerXMLFile(filePath) || LibertyUtils.isConfigDirFile(filePath) || LibertyProjectsManager.getInstance().getWorkspaceFolder(filePath).hasConfigFile(filePath);
    }

    public static boolean isConfigXMLFile(DOMDocument file) {
        return LibertyUtils.isConfigXMLFile(file.getDocumentURI());
    }

    public static File getDocumentAsFile(DOMDocument document) {
        return new File(LibertyUtils.getDocumentAsUri(document));
    }

    public static URI getDocumentAsUri(DOMDocument document) {
        return URI.create(document.getDocumentURI());
    }

    public static List<Path> findFilesInDirectory(Path dir, Path filePath) throws IOException {
        List<Path> matchingFiles = Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.endsWith(filePath)).collect(Collectors.toList());
        return matchingFiles;
    }

    public static Path findFileInWorkspace(String serverXmlURI, Path filePath) {
        LibertyWorkspace libertyWorkspace = LibertyProjectsManager.getInstance().getWorkspaceFolder(serverXmlURI);
        return LibertyUtils.findFileInWorkspace(libertyWorkspace, filePath);
    }

    public static Path findFileInWorkspace(LibertyWorkspace libertyWorkspace, Path filePath) {
        if (libertyWorkspace.getWorkspaceURI() == null) {
            return null;
        }
        try {
            Path rootPath = Paths.get(libertyWorkspace.getWorkspaceURI());
            List<Path> matchingFiles = LibertyUtils.findFilesInDirectory(rootPath, filePath);
            if (matchingFiles.isEmpty()) {
                return null;
            }
            if (matchingFiles.size() == 1) {
                return matchingFiles.get(0);
            }
            Path lastModified = matchingFiles.get(0);
            for (Path p : matchingFiles) {
                if (lastModified.toFile().lastModified() >= p.toFile().lastModified()) continue;
                lastModified = p;
            }
            return lastModified;
        }
        catch (IOException e) {
            LOGGER.warning("Could not find: " + filePath.toString() + ": " + e.getMessage());
            return null;
        }
    }

    public static String getRuntimeAndVersionInfo(DOMDocument serverXML) {
        String serverXMLUri = serverXML.getDocumentURI();
        String runtime = LibertyUtils.getRuntimeInfo(serverXMLUri);
        String version = LibertyUtils.getVersion(serverXMLUri);
        if (runtime == null) {
            runtime = "";
        }
        if (version == null) {
            version = "";
        }
        return runtime + "-" + version;
    }

    public static String getVersionFromInfo(String runtimeAndVersionInfo) {
        int index = runtimeAndVersionInfo.indexOf("-");
        if (runtimeAndVersionInfo.length() > index + 1) {
            return runtimeAndVersionInfo.substring(index + 1);
        }
        return null;
    }

    public static String getRuntimeFromInfo(String runtimeAndVersionInfo) {
        int index = runtimeAndVersionInfo.indexOf("-");
        if (index > 0) {
            return runtimeAndVersionInfo.substring(0, index);
        }
        return null;
    }

    public static String getRuntimeInfo(String serverXMLUri) {
        String libertyRuntime = SettingsService.getInstance().getLibertyRuntime();
        if (libertyRuntime != null) {
            return libertyRuntime;
        }
        LibertyWorkspace libertyWorkspace = LibertyProjectsManager.getInstance().getWorkspaceFolder(serverXMLUri);
        if (libertyWorkspace == null || libertyWorkspace.getWorkspaceURI() == null) {
            return null;
        }
        String runtime = libertyWorkspace.getLibertyRuntime();
        if (runtime != null && (libertyWorkspace.isLibertyInstalled() || libertyWorkspace.isContainerAlive())) {
            return runtime;
        }
        if (LibertyUtils.findFileInWorkspace(serverXMLUri, Paths.get("WebSphereApplicationServer.properties", new String[0])) != null) {
            runtime = "wlp";
        } else if (LibertyUtils.findFileInWorkspace(serverXMLUri, Paths.get("openliberty.properties", new String[0])) != null) {
            runtime = "ol";
        }
        libertyWorkspace.setLibertyRuntime(runtime);
        return runtime;
    }

    public static String getVersion(DOMDocument serverXML) {
        return LibertyUtils.getVersion(serverXML.getDocumentURI());
    }

    public static String getVersion(String serverXMLUri) {
        boolean devcOn;
        String libertyVersion = SettingsService.getInstance().getLibertyVersion();
        if (libertyVersion != null) {
            return libertyVersion;
        }
        LibertyWorkspace libertyWorkspace = LibertyProjectsManager.getInstance().getWorkspaceFolder(serverXMLUri);
        if (libertyWorkspace == null || libertyWorkspace.getWorkspaceString() == null) {
            return null;
        }
        String version = libertyWorkspace.getLibertyVersion();
        if (version != null && (libertyWorkspace.isLibertyInstalled() || libertyWorkspace.isContainerAlive())) {
            return version;
        }
        Path devcMetadataFile = libertyWorkspace.findDevcMetadata();
        Path propertiesFile = LibertyUtils.findFileInWorkspace(serverXMLUri, Paths.get("openliberty.properties", new String[0]));
        boolean bl = devcOn = devcMetadataFile != null;
        if (devcOn || propertiesFile != null && propertiesFile.toFile().exists()) {
            libertyWorkspace.setInstalledFeatureList(new ArrayList<Feature>());
            Properties prop = new Properties();
            try {
                FileInputStream fis;
                if (!libertyWorkspace.isLibertyInstalled()) {
                    LibertyUtils.watchFiles(devcOn ? devcMetadataFile : propertiesFile, libertyWorkspace);
                }
                if (devcOn) {
                    DockerService docker = DockerService.getInstance();
                    File containerPropertiesFile = new File(LibertyUtils.getTempDir(libertyWorkspace), "container.properties");
                    docker.dockerCp(libertyWorkspace.getContainerName(), DockerService.DEFAULT_CONTAINER_OL_PROPERTIES_PATH.toString(), containerPropertiesFile.toString());
                    fis = new FileInputStream(containerPropertiesFile);
                } else {
                    fis = new FileInputStream(propertiesFile.toFile());
                }
                prop.load(fis);
                version = prop.getProperty("com.ibm.websphere.productVersion");
                libertyWorkspace.setLibertyVersion(version);
                libertyWorkspace.setLibertyInstalled(!devcOn);
                if (devcOn) {
                    libertyWorkspace.setLibertyRuntime(prop.getProperty("com.ibm.websphere.productId").equals("io.openliberty") ? "ol" : "wlp");
                }
                return version;
            }
            catch (IOException e) {
                LOGGER.warning(devcOn ? "Failed to get version from running container specified by devc metadata file: " + devcMetadataFile.toString() : "Unable to get version from properties file: " + propertiesFile.toString() + ": " + e.getMessage());
                return null;
            }
        }
        return version;
    }

    public static File getTempDir(LibertyWorkspace libertyWorkspace) {
        if (libertyWorkspace == null) {
            return null;
        }
        try {
            File libertyLSFolder = new File(libertyWorkspace.getDir(), ".libertyls");
            Path pluginConfigFilePath = LibertyUtils.findFileInWorkspace(libertyWorkspace, Paths.get("liberty-plugin-config.xml", new String[0]));
            if (pluginConfigFilePath != null) {
                libertyLSFolder = new File(pluginConfigFilePath.getParent().toFile(), ".libertyls");
            }
            if (libertyLSFolder != null && !libertyLSFolder.exists() && !libertyLSFolder.mkdir()) {
                return null;
            }
            return libertyLSFolder;
        }
        catch (Exception e) {
            LOGGER.warning("Unable to create temp dir: " + e.getMessage());
            return null;
        }
    }

    public static void watchFiles(Path watchFile, LibertyWorkspace libertyWorkspace) {
        boolean isProperties = watchFile.endsWith("openliberty.properties");
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            watchFile.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            thread = new Thread(() -> {
                WatchKey watchKey = null;
                try {
                    while (true) {
                        if ((watchKey = watcher.poll(5L, TimeUnit.SECONDS)) == null) {
                            continue;
                        }
                        watchKey.pollEvents().stream().forEach(event -> {
                            if (isProperties) {
                                LOGGER.fine("Liberty properties file (" + watchFile + ") has been modified: " + event.context());
                                libertyWorkspace.setLibertyInstalled(false);
                            } else if (((Path)event.context()).toString().endsWith("-liberty-devc-metadata.xml")) {
                                DevcMetadata devcMetadata = LibertyWorkspace.unmarshalDevcMetadataFile(watchFile);
                                libertyWorkspace.setContainerAlive(devcMetadata.isContainerAlive());
                            }
                        });
                        boolean valid = watchKey.reset();
                        if (valid) continue;
                        if (isProperties) {
                            LOGGER.fine("Liberty properties file (" + watchFile + ") has been deleted");
                            libertyWorkspace.setLibertyInstalled(false);
                            continue;
                        }
                        libertyWorkspace.setContainerAlive(false);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Unable to watch properties file(s): " + e.getMessage());
                    return;
                }
            });
            thread.start();
        }
        catch (IOException e) {
            LOGGER.warning("Unable to watch properties file(s): " + e.getMessage());
        }
    }
}

