/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.models.feature.Feature;
import io.openliberty.tools.langserver.lemminx.services.FeatureService;
import io.openliberty.tools.langserver.lemminx.services.SettingsService;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LibertyCompletionParticipant
extends CompletionParticipantAdapter {
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws IOException, BadLocationException {
        if (!LibertyUtils.isConfigXMLFile(request.getXMLDocument())) {
            return;
        }
        LibertyUtils.getVersion(request.getXMLDocument());
        DOMElement parentElement = request.getParentElement();
        if (parentElement == null || parentElement.getTagName() == null) {
            return;
        }
        if (parentElement.getTagName().equals("feature")) {
            List<String> existingFeatures = new ArrayList<String>();
            if (parentElement.getParentNode() != null && parentElement.getParentNode().getNodeName().equals("featureManager")) {
                existingFeatures = this.collectExistingFeatures(parentElement.getParentNode());
            }
            List<CompletionItem> featureCompletionItems = this.buildCompletionItems(parentElement, request.getXMLDocument(), existingFeatures);
            featureCompletionItems.stream().forEach(item -> response.addCompletionItem(item));
        }
    }

    private CompletionItem buildFeatureCompletionItem(Feature feature, DOMElement featureElement, DOMDocument document) {
        String featureName = feature.getWlpInformation().getShortName();
        Range range = XMLPositionUtility.createRange((int)(featureElement.getStartTagCloseOffset() + 1), (int)featureElement.getEndTagOpenOffset(), (DOMDocument)document);
        Either edit = Either.forLeft((Object)new TextEdit(range, featureName));
        CompletionItem item = new CompletionItem();
        item.setTextEdit(edit);
        item.setLabel(featureName);
        item.setDocumentation(Either.forLeft((Object)feature.getShortDescription()));
        return item;
    }

    private List<CompletionItem> buildCompletionItems(DOMElement featureElement, DOMDocument domDocument, List<String> existingFeatures) {
        String libertyRuntimeVersionInfo = LibertyUtils.getRuntimeAndVersionInfo(domDocument);
        String libertyVersion = LibertyUtils.getVersionFromInfo(libertyRuntimeVersionInfo);
        String libertyRuntime = LibertyUtils.getRuntimeFromInfo(libertyRuntimeVersionInfo);
        int requestDelay = SettingsService.getInstance().getRequestDelay();
        List<Feature> features = FeatureService.getInstance().getFeatures(libertyVersion, libertyRuntime, requestDelay, domDocument.getDocumentURI());
        List<CompletionItem> uniqueFeatureCompletionItems = features.stream().filter(feature -> !existingFeatures.contains(feature.getWlpInformation().getShortName())).map(feat -> this.buildFeatureCompletionItem((Feature)feat, featureElement, domDocument)).collect(Collectors.toList());
        return uniqueFeatureCompletionItems;
    }

    private List<String> collectExistingFeatures(DOMNode featureManager) {
        ArrayList<String> includedFeatures = new ArrayList<String>();
        List features = featureManager.getChildren();
        for (DOMNode featureNode : features) {
            DOMNode featureTextNode = (DOMNode)featureNode.getChildNodes().item(0);
            if (!featureNode.getNodeName().equals("feature") || featureTextNode == null) continue;
            String featureName = featureTextNode.getTextContent();
            includedFeatures.add(featureName);
        }
        return includedFeatures;
    }
}

