/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx;

import io.openliberty.tools.langserver.lemminx.services.FeatureService;
import io.openliberty.tools.langserver.lemminx.services.LibertyProjectsManager;
import io.openliberty.tools.langserver.lemminx.services.SettingsService;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class LibertyDiagnosticParticipant
implements IDiagnosticsParticipant {
    public static final String MISSING_FILE_MESSAGE = "The resource at the specified location could not be found.";
    public static final String MISSING_FILE_CODE = "missing_file";
    public static final String NOT_OPTIONAL_MESSAGE = "The specified resource cannot be skipped. Check location value or set optional to true.";
    public static final String NOT_OPTIONAL_CODE = "not_optional";
    public static final String IMPLICIT_NOT_OPTIONAL_MESSAGE = "The specified resource cannot be skipped. Check location value or add optional attribute.";
    public static final String IMPLICIT_NOT_OPTIONAL_CODE = "implicit_not_optional";

    public void doDiagnostics(DOMDocument domDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker cancelChecker) {
        if (!LibertyUtils.isConfigXMLFile(domDocument)) {
            return;
        }
        try {
            this.validateDom(domDocument, diagnostics);
        }
        catch (IOException e) {
            System.err.println("Error validating document " + domDocument.getDocumentURI());
            System.err.println(e.getMessage());
        }
    }

    private void validateDom(DOMDocument domDocument, List<Diagnostic> list) throws IOException {
        List nodes = domDocument.getDocumentElement().getChildren();
        for (DOMNode node : nodes) {
            if ("featureManager".equals(node.getNodeName())) {
                this.validateFeature(domDocument, list, node);
                continue;
            }
            if (!"include".equals(node.getNodeName())) continue;
            this.validateIncludeLocation(domDocument, list, node);
        }
    }

    private void validateFeature(DOMDocument domDocument, List<Diagnostic> list, DOMNode featureManager) {
        String libertyRuntimeVersionInfo = LibertyUtils.getRuntimeAndVersionInfo(domDocument);
        String libertyVersion = LibertyUtils.getVersionFromInfo(libertyRuntimeVersionInfo);
        String libertyRuntime = LibertyUtils.getRuntimeFromInfo(libertyRuntimeVersionInfo);
        int requestDelay = SettingsService.getInstance().getRequestDelay();
        HashSet<String> includedFeatures = new HashSet<String>();
        List features = featureManager.getChildren();
        for (DOMNode featureNode : features) {
            String message;
            Range range;
            DOMNode featureTextNode = (DOMNode)featureNode.getChildNodes().item(0);
            if (featureTextNode == null || featureTextNode.getTextContent() == null) continue;
            String featureName = featureTextNode.getTextContent().trim();
            if (!featureName.startsWith("usr:") && !FeatureService.getInstance().featureExists(featureName, libertyVersion, libertyRuntime, requestDelay, domDocument.getDocumentURI())) {
                range = XMLPositionUtility.createRange((int)featureTextNode.getStart(), (int)featureTextNode.getEnd(), (DOMDocument)domDocument);
                message = "ERROR: The feature \"" + featureName + "\" does not exist.";
                list.add(new Diagnostic(range, message, DiagnosticSeverity.Error, "liberty-lemminx"));
                continue;
            }
            if (includedFeatures.contains(featureName)) {
                range = XMLPositionUtility.createRange((int)featureTextNode.getStart(), (int)featureTextNode.getEnd(), (DOMDocument)domDocument);
                message = "ERROR: " + featureName + " is already included.";
                list.add(new Diagnostic(range, message, DiagnosticSeverity.Error, "liberty-lemminx"));
                continue;
            }
            includedFeatures.add(featureName);
        }
    }

    private void validateIncludeLocation(DOMDocument domDocument, List<Diagnostic> list, DOMNode node) {
        String locAttribute = node.getAttribute("location");
        if (locAttribute == null) {
            return;
        }
        if (locAttribute.startsWith("http") || locAttribute.contains("$")) {
            return;
        }
        DOMAttr locNode = node.getAttributeNode("location");
        Range range = XMLPositionUtility.createRange((int)locNode.getStart(), (int)locNode.getEnd(), (DOMDocument)domDocument);
        if (!locAttribute.endsWith(".xml")) {
            String message = "The specified resource is not an XML file.";
            list.add(new Diagnostic(range, message, DiagnosticSeverity.Warning, "liberty-lemminx"));
            return;
        }
        File docParentFile = LibertyUtils.getDocumentAsFile(domDocument).getParentFile();
        File configFile = new File(docParentFile, locAttribute);
        if (!configFile.exists()) {
            configFile = new File(locAttribute);
        }
        try {
            if (configFile.exists()) {
                LibertyProjectsManager.getInstance().getWorkspaceFolder(domDocument.getDocumentURI()).addConfigFile(configFile.getCanonicalPath());
            } else {
                DOMAttr optNode = node.getAttributeNode("optional");
                if (optNode == null) {
                    list.add(new Diagnostic(range, IMPLICIT_NOT_OPTIONAL_MESSAGE, DiagnosticSeverity.Error, "liberty-lemminx", IMPLICIT_NOT_OPTIONAL_CODE));
                } else if (optNode.getValue().equals("false")) {
                    Range optRange = XMLPositionUtility.createRange((int)optNode.getStart(), (int)optNode.getEnd(), (DOMDocument)domDocument);
                    list.add(new Diagnostic(optRange, NOT_OPTIONAL_MESSAGE, DiagnosticSeverity.Error, "liberty-lemminx", NOT_OPTIONAL_CODE));
                }
                list.add(new Diagnostic(range, MISSING_FILE_MESSAGE, DiagnosticSeverity.Warning, "liberty-lemminx", MISSING_FILE_CODE));
            }
        }
        catch (IOException | IllegalArgumentException e) {
            list.add(new Diagnostic(range, MISSING_FILE_MESSAGE, DiagnosticSeverity.Warning, "liberty-lemminx-exception", MISSING_FILE_CODE));
        }
    }
}

