/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.services;

import io.openliberty.tools.langserver.lemminx.services.LibertyWorkspace;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class DockerService {
    private static final Logger LOGGER = Logger.getLogger(DockerService.class.getName());
    private final int DOCKER_TIMEOUT = 20;
    private static DockerService instance;
    public static final Path DEFAULT_CONTAINER_WLP_DIR;
    public static final Path DEFAULT_CONTAINER_OL_PROPERTIES_PATH;
    public static final Path DEFAULT_CONTAINER_SCHEMAGEN_JAR_PATH;

    public static DockerService getInstance() {
        if (instance == null) {
            instance = new DockerService();
        }
        return instance;
    }

    public void dockerExec(String containerName, String cmd) {
        String dockerExec = MessageFormat.format("docker exec {0} {1}", containerName, cmd);
        this.execDockerCmd(dockerExec);
    }

    public void dockerCp(String containerName, String containerSrc, String localDest) {
        String dockerCp = MessageFormat.format("docker cp {0}:{1} {2}", containerName, containerSrc, localDest);
        this.execDockerCmd(dockerCp);
    }

    public String generateServerSchemaXsdFromContainer(LibertyWorkspace libertyWorkspace) throws IOException {
        File tempDir = LibertyUtils.getTempDir(libertyWorkspace);
        String libertyRuntime = libertyWorkspace.getLibertyRuntime();
        String libertyVersion = libertyWorkspace.getLibertyVersion();
        Object xsdFileName = libertyVersion != null && libertyRuntime != null && !libertyVersion.isEmpty() && !libertyRuntime.isEmpty() ? libertyRuntime + "-" + libertyVersion + ".xsd" : "server.xsd";
        File xsdFile = new File(tempDir, (String)xsdFileName);
        if (!xsdFile.exists()) {
            String containerOutputFileString = "/tmp/" + (String)xsdFileName;
            String cmd = MessageFormat.format("java -jar {0} {1}", DEFAULT_CONTAINER_SCHEMAGEN_JAR_PATH.toString(), containerOutputFileString);
            this.dockerExec(libertyWorkspace.getContainerName(), cmd);
            this.dockerCp(libertyWorkspace.getContainerName(), containerOutputFileString, tempDir.getCanonicalPath());
        }
        LOGGER.info("Using schema file at: " + xsdFile.toURI().toString());
        return xsdFile.toURI().toString();
    }

    protected String execDockerCmd(String command) {
        String result = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor(20L, TimeUnit.SECONDS);
            if (p.exitValue() != 0) {
                LOGGER.severe("Error running docker command, return value=" + p.exitValue());
                char[] d = new char[1023];
                new InputStreamReader(p.getErrorStream()).read(d);
                throw new RuntimeException(new String(d).trim() + " RC=" + p.exitValue());
            }
            result = this.readStdOut(p);
        }
        catch (IllegalThreadStateException e) {
            LOGGER.warning("IllegalThreadStateException, message=" + e.getMessage());
            throw new RuntimeException("The docker command did not complete within the timeout period: 20 seconds. ");
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    protected String readStdOut(Process p) throws IOException, InterruptedException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuffer allLines = new StringBuffer();
        while ((line = in.readLine()) != null) {
            allLines.append(line).append(" ");
        }
        return allLines.length() > 0 ? allLines.toString() : null;
    }

    static {
        DEFAULT_CONTAINER_WLP_DIR = Paths.get("opt", "ol", "wlp");
        DEFAULT_CONTAINER_OL_PROPERTIES_PATH = DEFAULT_CONTAINER_WLP_DIR.resolve(Paths.get("lib", "versions", "openliberty.properties"));
        DEFAULT_CONTAINER_SCHEMAGEN_JAR_PATH = DEFAULT_CONTAINER_WLP_DIR.resolve(Paths.get("bin", "tools", "ws-schemagen.jar"));
    }
}

