/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.services;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import io.openliberty.tools.langserver.lemminx.models.feature.Feature;
import io.openliberty.tools.langserver.lemminx.models.feature.FeatureInfo;
import io.openliberty.tools.langserver.lemminx.models.feature.WlpInformation;
import io.openliberty.tools.langserver.lemminx.services.LibertyProjectsManager;
import io.openliberty.tools.langserver.lemminx.services.LibertyWorkspace;
import io.openliberty.tools.langserver.lemminx.util.LibertyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class FeatureService {
    private static final Logger LOGGER = Logger.getLogger(FeatureService.class.getName());
    private static FeatureService instance;
    private static String olFeatureEndpoint;
    private static String wlpFeatureEndpoint;
    private Map<String, List<Feature>> featureCache = new HashMap<String, List<Feature>>();
    private List<Feature> defaultFeatureList;
    private long featureUpdateTime = -1L;

    public static FeatureService getInstance() {
        if (instance == null) {
            instance = new FeatureService();
        }
        return instance;
    }

    private FeatureService() {
    }

    private List<Feature> fetchFeaturesForVersion(String libertyVersion, String libertyRuntime) throws IOException, JsonParseException {
        String featureEndpoint = libertyRuntime.equals("wlp") ? String.format(wlpFeatureEndpoint, libertyVersion) : String.format(olFeatureEndpoint, libertyVersion);
        InputStreamReader reader = new InputStreamReader(new URL(featureEndpoint).openStream());
        ArrayList<Feature> publicFeatures = this.readPublicFeatures(reader);
        LOGGER.fine("Returning public features from Maven: " + publicFeatures.size());
        return publicFeatures;
    }

    private List<Feature> getDefaultFeatureList() {
        try {
            if (this.defaultFeatureList == null) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("features.json");
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                this.defaultFeatureList = this.readPublicFeatures(reader);
            }
            LOGGER.fine("Returning default feature list");
            return this.defaultFeatureList;
        }
        catch (JsonParseException e) {
            LOGGER.severe("Error: Unable to get default features.");
            return this.defaultFeatureList;
        }
    }

    private ArrayList<Feature> readPublicFeatures(InputStreamReader reader) throws JsonParseException {
        Feature[] featureList = (Feature[])new Gson().fromJson((Reader)reader, Feature[].class);
        ArrayList<Feature> publicFeatures = new ArrayList<Feature>();
        Arrays.asList(featureList).stream().filter(f -> f.getWlpInformation().getVisibility().equals("PUBLIC")).forEach(publicFeatures::add);
        this.defaultFeatureList = publicFeatures;
        return publicFeatures;
    }

    public List<Feature> getFeatures(String libertyVersion, String libertyRuntime, int requestDelay, String documentURI) {
        if (libertyRuntime == null || libertyVersion == null) {
            List<Feature> defaultFeatures = this.getDefaultFeatureList();
            return defaultFeatures;
        }
        String featureCacheKey = libertyRuntime + "-" + libertyVersion;
        if (this.featureCache.containsKey(featureCacheKey)) {
            LOGGER.fine("Getting cached features for: " + featureCacheKey);
            return this.featureCache.get(featureCacheKey);
        }
        LOGGER.fine("Getting features for: " + featureCacheKey);
        try {
            long currentTime = System.currentTimeMillis();
            if (this.featureUpdateTime == -1L || currentTime >= this.featureUpdateTime + (long)(requestDelay * 1000)) {
                List<Feature> features = this.fetchFeaturesForVersion(libertyVersion, libertyRuntime);
                this.featureCache.put(featureCacheKey, features);
                this.featureUpdateTime = System.currentTimeMillis();
                return features;
            }
        }
        catch (Exception currentTime) {
            // empty catch block
        }
        List<Feature> installedFeatures = this.getInstalledFeaturesList(documentURI, libertyRuntime, libertyVersion);
        if (installedFeatures.size() != 0) {
            return installedFeatures;
        }
        List<Feature> defaultFeatures = this.getDefaultFeatureList();
        return defaultFeatures;
    }

    public Optional<Feature> getFeature(String featureName, String libertyVersion, String libertyRuntime, int requestDelay, String documentURI) {
        List<Feature> features = this.getFeatures(libertyVersion, libertyRuntime, requestDelay, documentURI);
        return features.stream().filter(f -> f.getWlpInformation().getShortName().equalsIgnoreCase(featureName)).findFirst();
    }

    public boolean featureExists(String featureName, String libertyVersion, String libertyRuntime, int requestDelay, String documentURI) {
        return this.getFeature(featureName, libertyVersion, libertyRuntime, requestDelay, documentURI).isPresent();
    }

    private List<Feature> getInstalledFeaturesList(String documentURI, String libertyRuntime, String libertyVersion) {
        List<Feature> installedFeatures = new ArrayList<Feature>();
        try {
            LibertyWorkspace libertyWorkspace = LibertyProjectsManager.getInstance().getWorkspaceFolder(documentURI);
            if (libertyWorkspace == null || libertyWorkspace.getWorkspaceString() == null) {
                return installedFeatures;
            }
            if (libertyWorkspace.getInstalledFeatureList().size() != 0) {
                return libertyWorkspace.getInstalledFeatureList();
            }
            Path featureListJAR = LibertyUtils.findFileInWorkspace(documentURI, Paths.get("bin", "tools", "ws-featurelist.jar"));
            if (featureListJAR != null && featureListJAR.toFile().exists()) {
                File tempDir = LibertyUtils.getTempDir(libertyWorkspace);
                String featureListFileName = "featurelist-" + libertyRuntime + "-" + libertyVersion + ".xml";
                if (tempDir == null) {
                    LOGGER.warning("Could not create a temporary directory for generating the " + featureListFileName + " file. The cached features.json file will be used for the current workspace: " + libertyWorkspace.getWorkspaceString());
                    return installedFeatures;
                }
                File featureListFile = new File(tempDir, featureListFileName);
                ProcessBuilder pb = new ProcessBuilder("java", "-jar", featureListJAR.toAbsolutePath().toString(), featureListFile.getCanonicalPath());
                pb.directory(tempDir);
                pb.redirectErrorStream(true);
                pb.redirectOutput(new File(tempDir, "ws-featurelist.log"));
                Process proc = pb.start();
                if (!proc.waitFor(30L, TimeUnit.SECONDS)) {
                    proc.destroy();
                    LOGGER.warning("Exceeded 30 second timeout during feature list generation. Using cached features.json file.");
                    return installedFeatures;
                }
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FeatureInfo.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                FeatureInfo featureInfo = (FeatureInfo)jaxbUnmarshaller.unmarshal(featureListFile);
                if (featureInfo.getFeatures() != null && featureInfo.getFeatures().size() > 0) {
                    for (int i = 0; i < featureInfo.getFeatures().size(); ++i) {
                        Feature f = featureInfo.getFeatures().get(i);
                        f.setShortDescription(f.getDescription());
                        WlpInformation wlpInfo = new WlpInformation(f.getName());
                        f.setWlpInformation(wlpInfo);
                    }
                    installedFeatures = featureInfo.getFeatures();
                    libertyWorkspace.setInstalledFeatureList(installedFeatures);
                } else {
                    LOGGER.warning("Unable to get installed features for current Liberty workspace: " + libertyWorkspace.getWorkspaceString());
                }
            } else {
                LOGGER.warning("Unable to generate the feature list for the current Liberty workspace:" + libertyWorkspace.getWorkspaceString());
            }
        }
        catch (IOException | InterruptedException | JAXBException e) {
            LOGGER.warning("Unable to get installed features: " + (Exception)e);
        }
        LOGGER.fine("Returning installed features: " + installedFeatures.size());
        return installedFeatures;
    }

    static {
        olFeatureEndpoint = "https://repo1.maven.org/maven2/io/openliberty/features/features/%1$s/features-%1$s.json";
        wlpFeatureEndpoint = "https://repo1.maven.org/maven2/com/ibm/websphere/appserver/features/features/%1$s/features-%1$s.json";
    }
}

