/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.lemminx.services;

import io.openliberty.tools.langserver.lemminx.models.settings.AllSettings;
import io.openliberty.tools.langserver.lemminx.models.settings.LibertySettings;
import org.eclipse.lemminx.utils.JSONUtility;

public class SettingsService {
    private static SettingsService instance = new SettingsService();
    private static int DEFAULT_REQUEST_DELAY = 120;
    private LibertySettings settings;

    public static SettingsService getInstance() {
        return instance;
    }

    private SettingsService() {
    }

    public void updateLibertySettings(Object xmlSettings) {
        AllSettings rootSettings = (AllSettings)JSONUtility.toModel((Object)xmlSettings, AllSettings.class);
        if (rootSettings != null) {
            this.settings = (LibertySettings)JSONUtility.toModel((Object)rootSettings.getLiberty(), LibertySettings.class);
        }
    }

    public String getLibertyVersion() {
        return this.settings != null ? this.settings.getVersion() : null;
    }

    public String getLibertyRuntime() {
        return this.settings != null ? this.settings.getRuntime() : null;
    }

    public int getRequestDelay() {
        int requestDelay;
        if (this.settings != null && (requestDelay = this.settings.getRequestDelay()) > 0) {
            return requestDelay;
        }
        return DEFAULT_REQUEST_DELAY;
    }
}

