/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver;

import java.util.logging.Logger;

public class AbstractLanguageServer {
    private static final Logger LOGGER = Logger.getLogger(AbstractLanguageServer.class.getName());
    private Thread runner;
    private volatile boolean shutdown;

    public int startServer() {
        this.runner = new Thread((Runnable)new LibertyServerRunnable(), "Liberty Language Client Watcher");
        this.runner.start();
        return 0;
    }

    public void stopServer() {
        LOGGER.info("Stopping Liberty language server");
        if (this.runner != null) {
            this.runner.interrupt();
        } else {
            LOGGER.info("Received request to stop Liberty language server, but it wasn't started.");
        }
    }

    public void shutdownServer() {
        LOGGER.info("Shutting down language server");
        this.shutdown = true;
    }

    private final class LibertyServerRunnable
    implements Runnable {
        private LibertyServerRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info("Starting Liberty Language Server");
            while (!AbstractLanguageServer.this.shutdown && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning(e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                LOGGER.info("Liberty Language Server - Client vanished...");
            }
        }
    }
}

