/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver;

import io.openliberty.tools.langserver.AbstractLanguageServer;
import io.openliberty.tools.langserver.LibertyTextDocumentService;
import io.openliberty.tools.langserver.LibertyWorkspaceService;
import io.openliberty.tools.langserver.common.ParentProcessWatcher;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;

public class LibertyLanguageServer
extends AbstractLanguageServer
implements ParentProcessWatcher.ProcessLanguageServer,
LanguageClientAware {
    public static final String LANGUAGE_ID = "LANGUAGE_ID_LIBERTY";
    private static final Logger LOGGER = Logger.getLogger(LibertyLanguageServer.class.getName());
    private final WorkspaceService workspaceService;
    private final LibertyTextDocumentService textDocumentService = new LibertyTextDocumentService(this);
    private LanguageClient languageClient;
    private Integer parentProcessId;

    public LibertyLanguageServer() {
        this.workspaceService = new LibertyWorkspaceService(this);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        LOGGER.info("Initializing Liberty Language server");
        this.parentProcessId = params.getProcessId();
        ServerCapabilities serverCapabilities = this.createServerCapabilities();
        InitializeResult initializeResult = new InitializeResult(serverCapabilities);
        return CompletableFuture.completedFuture(initializeResult);
    }

    public void initialized(InitializedParams params) {
        LOGGER.info("Initialized Liberty Language server");
    }

    private ServerCapabilities createServerCapabilities() {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        capabilities.setHoverProvider(Boolean.TRUE);
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.TRUE, Arrays.asList("=")));
        return capabilities;
    }

    public synchronized void updateSettings(Object initializationOptionsSettings) {
        LOGGER.info("Updating settings...");
        if (initializationOptionsSettings == null) {
            return;
        }
    }

    public void connect(LanguageClient client) {
        this.languageClient = client;
    }

    public CompletableFuture<Object> shutdown() {
        super.shutdownServer();
        return CompletableFuture.completedFuture(new Object());
    }

    public void exit() {
        this.exit(0);
    }

    @Override
    public void exit(int exitCode) {
        super.stopServer();
        System.exit(exitCode);
    }

    @Override
    public long getParentProcessId() {
        return this.parentProcessId != null ? (long)this.parentProcessId.intValue() : 0L;
    }

    public LibertyTextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public LanguageClient getLanguageClient() {
        return this.languageClient;
    }

    public void setLanguageClient(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }
}

