/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver;

import io.openliberty.tools.langserver.LibertyLanguageServer;
import io.openliberty.tools.langserver.common.ParentProcessWatcher;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class LibertyLanguageServerLauncher {
    public static void main(String[] args) {
        LibertyLanguageServer server = new LibertyLanguageServer();
        ParentProcessWatcher wrapper = it -> it;
        if (!"false".equals(System.getProperty("watchParentProcess"))) {
            wrapper = new ParentProcessWatcher(server, wrapper);
        }
        Launcher<LanguageClient> launcher = LibertyLanguageServerLauncher.createServerLauncher(server, System.in, System.out, Executors.newCachedThreadPool(), wrapper);
        server.setLanguageClient((LanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(LanguageClient.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }
}

