/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver;

import io.openliberty.tools.langserver.LibertyLanguageServer;
import io.openliberty.tools.langserver.completion.LibertyPropertiesCompletionProvider;
import io.openliberty.tools.langserver.diagnostic.DiagnosticRunner;
import io.openliberty.tools.langserver.hover.LibertyPropertiesHoverProvider;
import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.ls.LibertyTextDocuments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class LibertyTextDocumentService
implements TextDocumentService {
    private static final Logger LOGGER = Logger.getLogger(LibertyTextDocumentService.class.getName());
    private final LibertyLanguageServer libertyLanguageServer;
    private final LibertyTextDocuments<LibertyTextDocument> documents = new LibertyTextDocuments();

    public LibertyTextDocumentService(LibertyLanguageServer libertyls) {
        this.libertyLanguageServer = libertyls;
    }

    public LibertyTextDocument getOpenedDocument(String uri) {
        return this.documents.get(uri);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        LibertyTextDocument document = this.documents.onDidOpenTextDocument(params);
        String uri = document.getUri();
        this.validate(Arrays.asList(uri));
        new DiagnosticRunner(this.libertyLanguageServer).compute(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        LibertyTextDocument document = this.documents.onDidChangeTextDocument(params);
        String uri = document.getUri();
        this.validate(Arrays.asList(uri));
        new DiagnosticRunner(this.libertyLanguageServer).compute(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documents.onDidCloseTextDocument(params);
        String uri = params.getTextDocument().getUri();
        this.libertyLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, new ArrayList()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.validate(Arrays.asList(params.getTextDocument().getUri()));
    }

    private void validateAll() {
        List<String> allDocs = this.documents.all().stream().map(doc -> doc.getUri()).collect(Collectors.toList());
        this.validate(allDocs);
    }

    public CompletableFuture<Hover> hover(HoverParams hoverParams) {
        LOGGER.info("hover: " + hoverParams.toString());
        String uri = hoverParams.getTextDocument().getUri();
        LibertyTextDocument textDocumentItem = this.documents.get(uri);
        return new LibertyPropertiesHoverProvider(textDocumentItem).getHover(hoverParams.getPosition());
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams completionParams) {
        String uri = completionParams.getTextDocument().getUri();
        LOGGER.info("completion: " + uri);
        LibertyTextDocument textDocumentItem = this.documents.get(uri);
        if (textDocumentItem != null) {
            return new LibertyPropertiesCompletionProvider(textDocumentItem).getCompletions(completionParams.getPosition()).thenApply(Either::forLeft);
        }
        LOGGER.info("The document with uri " + uri + " has not been found in opened documents. Cannot provide completion.");
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        LOGGER.info("resolveCompletionItem: " + unresolved.getLabel());
        return CompletableFuture.completedFuture(unresolved);
    }

    private void validate(List<String> uris) {
        if (uris.isEmpty()) {
            return;
        }
        LOGGER.info("Running validation for: " + uris.toString());
    }
}

