/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.diagnostic;

import io.openliberty.tools.langserver.LibertyLanguageServer;
import io.openliberty.tools.langserver.diagnostic.LibertyPropertiesDiagnosticService;
import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.utils.PropertiesValidationResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;

public class DiagnosticRunner {
    private LibertyLanguageServer libertyLanguageServer;
    private LibertyPropertiesDiagnosticService libertyPropertiesDiagnosticService;
    private static final Logger LOGGER = Logger.getLogger(DiagnosticRunner.class.getName());

    public DiagnosticRunner(LibertyLanguageServer libertyLanguageServer) {
        this.libertyLanguageServer = libertyLanguageServer;
        this.libertyPropertiesDiagnosticService = new LibertyPropertiesDiagnosticService();
    }

    public void compute(DidOpenTextDocumentParams params) {
        String text = params.getTextDocument().getText();
        this.computeDiagnostics(text, params.getTextDocument());
    }

    public void compute(DidChangeTextDocumentParams params) {
        String text = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        this.computeDiagnostics(text, this.libertyLanguageServer.getTextDocumentService().getOpenedDocument(params.getTextDocument().getUri()));
    }

    public void computeDiagnostics(String text, TextDocumentItem documentItem) {
        String uri = documentItem.getUri();
        CompletableFuture.runAsync(() -> {
            LibertyTextDocument openedDocument = this.libertyLanguageServer.getTextDocumentService().getOpenedDocument(uri);
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            Map<String, PropertiesValidationResult> propertiesErrors = this.libertyPropertiesDiagnosticService.compute(text, openedDocument);
            diagnostics.addAll(this.libertyPropertiesDiagnosticService.convertToLSPDiagnostics(propertiesErrors));
            this.libertyLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, diagnostics));
        });
    }
}

