/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.langserver.diagnostic;

import io.openliberty.tools.langserver.ls.LibertyTextDocument;
import io.openliberty.tools.langserver.utils.ParserFileHelperUtil;
import io.openliberty.tools.langserver.utils.PropertiesValidationResult;
import io.openliberty.tools.langserver.utils.ServerPropertyValues;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class LibertyPropertiesDiagnosticService {
    private static final Logger LOGGER = Logger.getLogger(LibertyPropertiesDiagnosticService.class.getName());
    private static final ResourceBundle DiagnosticMessages = ResourceBundle.getBundle("DiagnosticMessages", Locale.getDefault());

    public Map<String, PropertiesValidationResult> compute(String text, LibertyTextDocument openedDocument) {
        HashMap<String, PropertiesValidationResult> errors = new HashMap<String, PropertiesValidationResult>();
        if (ParserFileHelperUtil.isBootstrapPropertiesFile(openedDocument) || ParserFileHelperUtil.isServerEnvFile(openedDocument)) {
            BufferedReader br = new BufferedReader(new StringReader(text));
            String line = null;
            int lineNumber = 0;
            try {
                while ((line = br.readLine()) != null) {
                    PropertiesValidationResult validationResult = PropertiesValidationResult.validateServerProperty(line, openedDocument);
                    if (validationResult.hasErrors()) {
                        validationResult.setLineNumber(lineNumber);
                        errors.put(line, validationResult);
                    }
                    ++lineNumber;
                }
            }
            catch (IOException e) {
                LOGGER.warning("Exception while validating the document " + openedDocument.getUri() + "\n" + e);
            }
        }
        return errors;
    }

    public Collection<Diagnostic> convertToLSPDiagnostics(Map<String, PropertiesValidationResult> propertiesErrors) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        for (Map.Entry<String, PropertiesValidationResult> errorEntry : propertiesErrors.entrySet()) {
            PropertiesValidationResult validationResult = errorEntry.getValue();
            String lineContentInError = errorEntry.getKey();
            List<Diagnostic> invalidValueDiagnostics = this.computeInvalidValuesDiagnostic(validationResult, lineContentInError);
            lspDiagnostics.addAll(invalidValueDiagnostics);
        }
        return lspDiagnostics;
    }

    private List<Diagnostic> computeInvalidValuesDiagnostic(PropertiesValidationResult validationResult, String lineContentInError) {
        ArrayList<Diagnostic> lspDiagnostics = new ArrayList<Diagnostic>();
        if (validationResult.hasErrors()) {
            String property = validationResult.getKey();
            String messageTemplate = DiagnosticMessages.getString(validationResult.getDiagnosticType());
            String message = MessageFormat.format(messageTemplate, validationResult.getValue(), property, ServerPropertyValues.getIntegerRange(property));
            lspDiagnostics.add(new Diagnostic(this.computeRange(validationResult, lineContentInError, validationResult.getValue()), message));
        }
        return lspDiagnostics;
    }

    private Range computeRange(PropertiesValidationResult validationResult, String lineContentInError, String value) {
        int endCharacter;
        int startCharacter;
        int indexOfValue = lineContentInError.lastIndexOf(value);
        if (indexOfValue != -1) {
            startCharacter = indexOfValue;
            endCharacter = indexOfValue + value.length();
        } else {
            startCharacter = 0;
            endCharacter = lineContentInError.length();
        }
        int lineNumber = validationResult.getLineNumber();
        return new Range(new Position(lineNumber, startCharacter), new Position(lineNumber, endCharacter));
    }
}

